/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.mixin;

import com.google.common.collect.ImmutableList;
import com.nyfaria.nyfsspiders.common.CollisionSmoothingUtil;
import com.nyfaria.nyfsspiders.common.Matrix4f;
import com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity;
import com.nyfaria.nyfsspiders.common.entity.mob.IEntityMovementHook;
import com.nyfaria.nyfsspiders.common.entity.mob.IEntityReadWriteHook;
import com.nyfaria.nyfsspiders.common.entity.mob.ILivingEntityDataManagerHook;
import com.nyfaria.nyfsspiders.common.entity.mob.ILivingEntityJumpHook;
import com.nyfaria.nyfsspiders.common.entity.mob.ILivingEntityLookAtHook;
import com.nyfaria.nyfsspiders.common.entity.mob.ILivingEntityRotationHook;
import com.nyfaria.nyfsspiders.common.entity.mob.ILivingEntityTravelHook;
import com.nyfaria.nyfsspiders.common.entity.mob.IMobEntityLivingTickHook;
import com.nyfaria.nyfsspiders.common.entity.mob.IMobEntityTickHook;
import com.nyfaria.nyfsspiders.common.entity.mob.Orientation;
import com.nyfaria.nyfsspiders.common.entity.mob.PathingTarget;
import com.nyfaria.nyfsspiders.common.entity.movement.BetterSpiderPathNavigator;
import com.nyfaria.nyfsspiders.common.entity.movement.ClimberJumpController;
import com.nyfaria.nyfsspiders.common.entity.movement.ClimberLookController;
import com.nyfaria.nyfsspiders.common.entity.movement.ClimberMoveController;
import com.nyfaria.nyfsspiders.common.entity.movement.DirectionalPathPoint;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Spider.class})
public abstract class ClimberEntityMixin
extends PathfinderMob
implements IClimberEntity,
IMobEntityLivingTickHook,
ILivingEntityLookAtHook,
IMobEntityTickHook,
ILivingEntityRotationHook,
ILivingEntityDataManagerHook,
ILivingEntityTravelHook,
IEntityMovementHook,
IEntityReadWriteHook,
ILivingEntityJumpHook {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Float> MOVEMENT_TARGET_X;
    private static final EntityDataAccessor<Float> MOVEMENT_TARGET_Y;
    private static final EntityDataAccessor<Float> MOVEMENT_TARGET_Z;
    private static final ImmutableList<EntityDataAccessor<Optional<BlockPos>>> PATHING_TARGETS;
    private static final ImmutableList<EntityDataAccessor<Direction>> PATHING_SIDES;
    private static final EntityDataAccessor<Rotations> ROTATION_BODY;
    private static final EntityDataAccessor<Rotations> ROTATION_HEAD;
    private double prevAttachmentOffsetX;
    private double prevAttachmentOffsetY;
    private double prevAttachmentOffsetZ;
    private double attachmentOffsetX;
    private double attachmentOffsetY;
    private double attachmentOffsetZ;
    private Vec3 attachmentNormal = new Vec3(0.0, 1.0, 0.0);
    private Vec3 prevAttachmentNormal = new Vec3(0.0, 1.0, 0.0);
    private float prevOrientationYawDelta;
    private float orientationYawDelta;
    private double lastAttachmentOffsetX;
    private double lastAttachmentOffsetY;
    private double lastAttachmentOffsetZ;
    private Vec3 lastAttachmentOrientationNormal = new Vec3(0.0, 1.0, 0.0);
    private int attachedTicks = 5;
    private Vec3 attachedSides = new Vec3(0.0, 0.0, 0.0);
    private Vec3 prevAttachedSides = new Vec3(0.0, 0.0, 0.0);
    private boolean canClimbInWater = false;
    private boolean canClimbInLava = false;
    private boolean isTravelingInFluid = false;
    private float collisionsInclusionRange = 2.0f;
    private float collisionsSmoothingRange = 1.25f;
    private Orientation orientation;
    private Pair<Direction, Vec3> groundDirecton;
    private Orientation renderOrientation;
    private float nextStepDistance;
    private float nextFlap;
    private Vec3 preWalkingPosition;
    private double preMoveY;
    private Vec3 jumpDir;

    private ClimberEntityMixin(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.m_274367_(0.1f);
        this.orientation = this.calculateOrientation(1.0f);
        this.groundDirecton = this.getGroundDirection();
        this.f_21342_ = new ClimberMoveController<ClimberEntityMixin>(this);
        this.f_21365_ = new ClimberLookController<ClimberEntityMixin>(this);
        this.f_21343_ = new ClimberJumpController<ClimberEntityMixin>(this);
    }

    @Inject(method={"createNavigation"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateNavigator(Level world, CallbackInfoReturnable<PathNavigation> ci) {
        BetterSpiderPathNavigator<ClimberEntityMixin> navigate = new BetterSpiderPathNavigator<ClimberEntityMixin>(this, world, false);
        navigate.m_7008_(true);
        ci.setReturnValue(navigate);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    public void onDefineSynchedData(CallbackInfo ci) {
        this.onRegisterData();
    }

    public void onRegisterData() {
        if (this.shouldTrackPathingTargets()) {
            this.f_19804_.m_135372_(MOVEMENT_TARGET_X, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(MOVEMENT_TARGET_Y, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135372_(MOVEMENT_TARGET_Z, (Object)Float.valueOf(0.0f));
            for (EntityDataAccessor pathingTarget : PATHING_TARGETS) {
                this.f_19804_.m_135372_(pathingTarget, Optional.empty());
            }
            for (EntityDataAccessor pathingSide : PATHING_SIDES) {
                this.f_19804_.m_135372_(pathingSide, (Object)Direction.DOWN);
            }
        }
        this.f_19804_.m_135372_(ROTATION_BODY, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(ROTATION_HEAD, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    @Override
    public void onWrite(CompoundTag nbt) {
        nbt.m_128347_("nyfsspiders.AttachmentNormalX", this.attachmentNormal.f_82479_);
        nbt.m_128347_("nyfsspiders.AttachmentNormalY", this.attachmentNormal.f_82480_);
        nbt.m_128347_("nyfsspiders.AttachmentNormalZ", this.attachmentNormal.f_82481_);
        nbt.m_128405_("nyfsspiders.AttachedTicks", this.attachedTicks);
    }

    @Override
    public void onRead(CompoundTag nbt) {
        this.prevAttachmentNormal = this.attachmentNormal = new Vec3(nbt.m_128459_("nyfsspiders.AttachmentNormalX"), nbt.m_128459_("nyfsspiders.AttachmentNormalY"), nbt.m_128459_("nyfsspiders.AttachmentNormalZ"));
        this.attachedTicks = nbt.m_128451_("nyfsspiders.AttachedTicks");
        this.orientation = this.calculateOrientation(1.0f);
    }

    @Override
    public boolean canClimbInWater() {
        return this.canClimbInWater;
    }

    @Override
    public void setCanClimbInWater(boolean value) {
        this.canClimbInWater = value;
    }

    @Override
    public boolean canClimbInLava() {
        return this.canClimbInLava;
    }

    @Override
    public void setCanClimbInLava(boolean value) {
        this.canClimbInLava = value;
    }

    @Override
    public float getCollisionsInclusionRange() {
        return this.collisionsInclusionRange;
    }

    @Override
    public void setCollisionsInclusionRange(float range) {
        this.collisionsInclusionRange = range;
    }

    @Override
    public float getCollisionsSmoothingRange() {
        return this.collisionsSmoothingRange;
    }

    @Override
    public void setCollisionsSmoothingRange(float range) {
        this.collisionsSmoothingRange = range;
    }

    @Override
    public float getBridgePathingMalus(Mob entity, BlockPos pos, Node fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(Direction facing) {
    }

    public int m_6056_() {
        return 0;
    }

    @Override
    public float getMovementSpeed() {
        AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
        return attribute != null ? (float)attribute.m_22135_() : 1.0f;
    }

    private static double calculateXOffset(AABB aabb, AABB other, double offsetX) {
        if (other.f_82292_ > aabb.f_82289_ && other.f_82289_ < aabb.f_82292_ && other.f_82293_ > aabb.f_82290_ && other.f_82290_ < aabb.f_82293_) {
            double dx;
            if (offsetX > 0.0 && other.f_82291_ <= aabb.f_82288_) {
                double dx2 = aabb.f_82288_ - other.f_82291_;
                if (dx2 < offsetX) {
                    offsetX = dx2;
                }
            } else if (offsetX < 0.0 && other.f_82288_ >= aabb.f_82291_ && (dx = aabb.f_82291_ - other.f_82288_) > offsetX) {
                offsetX = dx;
            }
            return offsetX;
        }
        return offsetX;
    }

    private static double calculateYOffset(AABB aabb, AABB other, double offsetY) {
        if (other.f_82291_ > aabb.f_82288_ && other.f_82288_ < aabb.f_82291_ && other.f_82293_ > aabb.f_82290_ && other.f_82290_ < aabb.f_82293_) {
            double dy;
            if (offsetY > 0.0 && other.f_82292_ <= aabb.f_82289_) {
                double dy2 = aabb.f_82289_ - other.f_82292_;
                if (dy2 < offsetY) {
                    offsetY = dy2;
                }
            } else if (offsetY < 0.0 && other.f_82289_ >= aabb.f_82292_ && (dy = aabb.f_82292_ - other.f_82289_) > offsetY) {
                offsetY = dy;
            }
            return offsetY;
        }
        return offsetY;
    }

    private static double calculateZOffset(AABB aabb, AABB other, double offsetZ) {
        if (other.f_82291_ > aabb.f_82288_ && other.f_82288_ < aabb.f_82291_ && other.f_82292_ > aabb.f_82289_ && other.f_82289_ < aabb.f_82292_) {
            double dz;
            if (offsetZ > 0.0 && other.f_82293_ <= aabb.f_82290_) {
                double dz2 = aabb.f_82290_ - other.f_82293_;
                if (dz2 < offsetZ) {
                    offsetZ = dz2;
                }
            } else if (offsetZ < 0.0 && other.f_82290_ >= aabb.f_82293_ && (dz = aabb.f_82293_ - other.f_82290_) > offsetZ) {
                offsetZ = dz;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    private void updateWalkingSide() {
        Object avoidPathingFacing = null;
        AABB entityBox = this.m_20191_();
        double closestFacingDst = Double.MAX_VALUE;
        Direction closestFacing = null;
        Vec3 weighting = new Vec3(0.0, 0.0, 0.0);
        float stickingDistance = this.f_20902_ != 0.0f ? 1.5f : 0.1f;
        for (Direction facing : Direction.values()) {
            if (avoidPathingFacing == facing) continue;
            List<AABB> collisionBoxes = this.getCollisionBoxes(entityBox.m_82400_((double)0.2f).m_82363_((double)((float)facing.m_122429_() * stickingDistance), (double)((float)facing.m_122430_() * stickingDistance), (double)((float)facing.m_122431_() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (AABB collisionBox : collisionBoxes) {
                switch (facing) {
                    case EAST: 
                    case WEST: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateXOffset(entityBox, collisionBox, (float)(-facing.m_122429_()) * stickingDistance)));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateYOffset(entityBox, collisionBox, (float)(-facing.m_122430_()) * stickingDistance)));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateZOffset(entityBox, collisionBox, (float)(-facing.m_122431_()) * stickingDistance)));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.m_82549_(new Vec3((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_()).m_82490_(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        this.groundDirecton = closestFacing == null ? Pair.of((Object)Direction.DOWN, (Object)new Vec3(0.0, -1.0, 0.0)) : Pair.of(closestFacing, (Object)weighting.m_82541_().m_82520_(0.0, (double)-0.001f, 0.0).m_82541_());
    }

    @Override
    public Pair<Direction, Vec3> getGroundDirection() {
        return this.groundDirecton;
    }

    @Override
    public Direction getGroundSide() {
        return (Direction)this.groundDirecton.getKey();
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setRenderOrientation(Orientation orientation) {
        this.renderOrientation = orientation;
    }

    @Override
    public Orientation getRenderOrientation() {
        return this.renderOrientation;
    }

    @Override
    public float getAttachmentOffset(Direction.Axis axis, float partialTicks) {
        switch (axis) {
            default: {
                return (float)(this.prevAttachmentOffsetX + (this.attachmentOffsetX - this.prevAttachmentOffsetX) * (double)partialTicks);
            }
            case Y: {
                return (float)(this.prevAttachmentOffsetY + (this.attachmentOffsetY - this.prevAttachmentOffsetY) * (double)partialTicks);
            }
            case Z: 
        }
        return (float)(this.prevAttachmentOffsetZ + (this.attachmentOffsetZ - this.prevAttachmentOffsetZ) * (double)partialTicks);
    }

    @Override
    public Vec3 onLookAt(EntityAnchorArgument.Anchor anchor, Vec3 vec) {
        Vec3 dir = vec.m_82546_(this.m_20182_());
        dir = this.getOrientation().getLocal(dir);
        return dir;
    }

    @Override
    public void onTick() {
        block13: {
            ChunkMap.TrackedEntity entityTracker;
            if (this.m_9236_().f_46443_ || !(this.m_9236_() instanceof ServerLevel) || (entityTracker = (ChunkMap.TrackedEntity)((ServerLevel)this.m_9236_()).m_7726_().f_8325_.f_140150_.get(this.m_19879_())) == null || entityTracker.f_140471_.f_8521_ % entityTracker.f_140471_.f_8511_ != 0) break block13;
            Orientation orientation = this.getOrientation();
            Vec3 look = orientation.getGlobal(this.m_146908_(), this.m_146909_());
            this.f_19804_.m_135381_(ROTATION_BODY, (Object)new Rotations((float)look.f_82479_, (float)look.f_82480_, (float)look.f_82481_));
            look = orientation.getGlobal(this.f_20885_, 0.0f);
            this.f_19804_.m_135381_(ROTATION_HEAD, (Object)new Rotations((float)look.f_82479_, (float)look.f_82480_, (float)look.f_82481_));
            if (this.shouldTrackPathingTargets()) {
                if (this.f_20900_ != 0.0f) {
                    Vec3 forwardVector = orientation.getGlobal(this.m_146908_(), 0.0f);
                    Vec3 strafeVector = orientation.getGlobal(this.m_146908_() + 90.0f, 0.0f);
                    Vec3 offset = forwardVector.m_82490_((double)this.f_20902_).m_82549_(strafeVector.m_82490_((double)this.f_20900_)).m_82541_();
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_X, (Object)Float.valueOf((float)(this.m_20185_() + offset.f_82479_)));
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_Y, (Object)Float.valueOf((float)(this.m_20186_() + (double)(this.m_20206_() * 0.5f) + offset.f_82480_)));
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_Z, (Object)Float.valueOf((float)(this.m_20189_() + offset.f_82481_)));
                } else {
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_X, (Object)Float.valueOf((float)this.m_21566_().m_25000_()));
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_Y, (Object)Float.valueOf((float)this.m_21566_().m_25001_()));
                    this.f_19804_.m_135381_(MOVEMENT_TARGET_Z, (Object)Float.valueOf((float)this.m_21566_().m_25002_()));
                }
                Path path = this.m_21573_().m_26570_();
                if (path != null) {
                    int i = 0;
                    for (EntityDataAccessor pathingTarget : PATHING_TARGETS) {
                        EntityDataAccessor pathingSide = (EntityDataAccessor)PATHING_SIDES.get(i);
                        if (path.m_77399_() + i < path.m_77398_()) {
                            Node point = path.m_77375_(path.m_77399_() + i);
                            this.f_19804_.m_135381_(pathingTarget, Optional.of(new BlockPos(point.f_77271_, point.f_77272_, point.f_77273_)));
                            if (point instanceof DirectionalPathPoint) {
                                Direction dir = ((DirectionalPathPoint)point).getPathSide();
                                if (dir != null) {
                                    this.f_19804_.m_135381_(pathingSide, (Object)dir);
                                } else {
                                    this.f_19804_.m_135381_(pathingSide, (Object)Direction.DOWN);
                                }
                            }
                        } else {
                            this.f_19804_.m_135381_(pathingTarget, Optional.empty());
                            this.f_19804_.m_135381_(pathingSide, (Object)Direction.DOWN);
                        }
                        ++i;
                    }
                } else {
                    for (EntityDataAccessor pathingTarget : PATHING_TARGETS) {
                        this.f_19804_.m_135381_(pathingTarget, Optional.empty());
                    }
                    for (EntityDataAccessor pathingSide : PATHING_SIDES) {
                        this.f_19804_.m_135381_(pathingSide, (Object)Direction.DOWN);
                    }
                }
            }
        }
    }

    @Override
    public void onLivingTick() {
        this.updateWalkingSide();
    }

    public boolean m_6147_() {
        return false;
    }

    @Override
    @Nullable
    public Vec3 getTrackedMovementTarget() {
        if (this.shouldTrackPathingTargets()) {
            return new Vec3((double)((Float)this.f_19804_.m_135370_(MOVEMENT_TARGET_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(MOVEMENT_TARGET_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(MOVEMENT_TARGET_Z)).floatValue());
        }
        return null;
    }

    @Override
    @Nullable
    public List<PathingTarget> getTrackedPathingTargets() {
        if (this.shouldTrackPathingTargets()) {
            ArrayList<PathingTarget> pathingTargets = new ArrayList<PathingTarget>(PATHING_TARGETS.size());
            int i = 0;
            for (EntityDataAccessor key : PATHING_TARGETS) {
                BlockPos pos = ((Optional)this.f_19804_.m_135370_(key)).orElse(null);
                if (pos != null) {
                    pathingTargets.add(new PathingTarget(pos, (Direction)this.f_19804_.m_135370_((EntityDataAccessor)PATHING_SIDES.get(i))));
                }
                ++i;
            }
            return pathingTargets;
        }
        return null;
    }

    @Override
    public float getVerticalOffset(float partialTicks) {
        return 0.075f;
    }

    private void forEachCollisonBox(AABB aabb, Shapes.DoubleLineConsumer action) {
        int minChunkX = Mth.m_14107_((double)(aabb.f_82288_ - 1.0E-7)) - 1 >> 4;
        int maxChunkX = Mth.m_14107_((double)(aabb.f_82291_ + 1.0E-7)) + 1 >> 4;
        int minChunkZ = Mth.m_14107_((double)(aabb.f_82290_ - 1.0E-7)) - 1 >> 4;
        int maxChunkZ = Mth.m_14107_((double)(aabb.f_82293_ + 1.0E-7)) + 1 >> 4;
        int width = maxChunkX - minChunkX + 1;
        int depth = maxChunkZ - minChunkZ + 1;
        BlockGetter[] blockReaderCache = new BlockGetter[width * depth];
        Level collisionReader = this.m_9236_();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                blockReaderCache[cx - minChunkX + (cz - minChunkZ) * width] = collisionReader.m_7925_(cx, cz);
            }
        }
        CollisionGetter cachedCollisionReader = new CollisionGetter(){
            final /* synthetic */ CollisionGetter val$collisionReader;
            final /* synthetic */ BlockGetter[] val$blockReaderCache;
            final /* synthetic */ int val$minChunkX;
            final /* synthetic */ int val$minChunkZ;
            final /* synthetic */ int val$width;
            {
                this.val$collisionReader = collisionGetter;
                this.val$blockReaderCache = blockGetterArray;
                this.val$minChunkX = n;
                this.val$minChunkZ = n2;
                this.val$width = n3;
            }

            public int m_141928_() {
                return ClimberEntityMixin.this.m_9236_().m_141928_();
            }

            public int m_141937_() {
                return ClimberEntityMixin.this.m_9236_().m_141937_();
            }

            public BlockEntity m_7702_(BlockPos pos) {
                return this.val$collisionReader.m_7702_(pos);
            }

            public BlockState m_8055_(BlockPos pos) {
                return this.val$collisionReader.m_8055_(pos);
            }

            public FluidState m_6425_(BlockPos pos) {
                return this.val$collisionReader.m_6425_(pos);
            }

            public WorldBorder m_6857_() {
                return this.val$collisionReader.m_6857_();
            }

            public List<VoxelShape> m_183134_(Entity entity, AABB aabb) {
                return this.val$collisionReader.m_183134_(entity, aabb);
            }

            public BlockGetter m_7925_(int chunkX, int chunkZ) {
                return this.val$blockReaderCache[chunkX - this.val$minChunkX + (chunkZ - this.val$minChunkZ) * this.val$width];
            }
        };
        Iterable shapes = cachedCollisionReader.m_186434_((Entity)this, aabb);
        shapes.forEach(shape -> shape.m_83286_(action));
    }

    private List<AABB> getCollisionBoxes(AABB aabb) {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        this.forEachCollisonBox(aabb, (minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ)));
        return boxes;
    }

    @Override
    public boolean canClimbOnBlock(BlockState state, BlockPos pos) {
        return true;
    }

    @Override
    public float getBlockSlipperiness(BlockPos pos) {
        BlockState offsetState = this.m_9236_().m_8055_(pos);
        return offsetState.m_60734_().m_49958_() * 0.91f;
    }

    private void updateOffsetsAndOrientation() {
        Vec3 direction = this.getOrientation().getGlobal(this.m_146908_(), this.m_146909_());
        boolean isAttached = false;
        double baseStickingOffsetX = 0.0;
        double baseStickingOffsetY = this.getVerticalOffset(1.0f);
        double baseStickingOffsetZ = 0.0;
        Vec3 baseOrientationNormal = new Vec3(0.0, 1.0, 0.0);
        if (!this.isTravelingInFluid && this.m_20096_() && this.m_20202_() == null) {
            Vec3 p = this.m_20182_();
            Vec3 s = p.m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
            AABB inclusionBox = new AABB(s.f_82479_, s.f_82480_, s.f_82481_, s.f_82479_, s.f_82480_, s.f_82481_).m_82400_((double)this.collisionsInclusionRange);
            Pair<Vec3, Vec3> attachmentPoint = CollisionSmoothingUtil.findClosestPoint(consumer -> this.forEachCollisonBox(inclusionBox, (Shapes.DoubleLineConsumer)consumer), s, this.attachmentNormal.m_82490_(-1.0), this.collisionsSmoothingRange, 1.0f, 0.001f, 20, 0.05f, s);
            AABB entityBox = this.m_20191_();
            if (attachmentPoint != null) {
                double dz;
                double dy;
                Vec3 attachmentPos = (Vec3)attachmentPoint.getLeft();
                double dx = Math.max(entityBox.f_82288_ - attachmentPos.f_82479_, attachmentPos.f_82479_ - entityBox.f_82291_);
                if (Math.max(dx, Math.max(dy = Math.max(entityBox.f_82289_ - attachmentPos.f_82480_, attachmentPos.f_82480_ - entityBox.f_82292_), dz = Math.max(entityBox.f_82290_ - attachmentPos.f_82481_, attachmentPos.f_82481_ - entityBox.f_82293_))) < 0.5) {
                    isAttached = true;
                    this.lastAttachmentOffsetX = Mth.m_14008_((double)(attachmentPos.f_82479_ - p.f_82479_), (double)(-this.m_20205_() / 2.0f), (double)(this.m_20205_() / 2.0f));
                    this.lastAttachmentOffsetY = Mth.m_14008_((double)(attachmentPos.f_82480_ - p.f_82480_), (double)0.0, (double)this.m_20206_());
                    this.lastAttachmentOffsetZ = Mth.m_14008_((double)(attachmentPos.f_82481_ - p.f_82481_), (double)(-this.m_20205_() / 2.0f), (double)(this.m_20205_() / 2.0f));
                    this.lastAttachmentOrientationNormal = (Vec3)attachmentPoint.getRight();
                }
            }
        }
        this.prevAttachmentOffsetX = this.attachmentOffsetX;
        this.prevAttachmentOffsetY = this.attachmentOffsetY;
        this.prevAttachmentOffsetZ = this.attachmentOffsetZ;
        this.prevAttachmentNormal = this.attachmentNormal;
        float attachmentBlend = (float)this.attachedTicks * 0.2f;
        this.attachmentOffsetX = baseStickingOffsetX + (this.lastAttachmentOffsetX - baseStickingOffsetX) * (double)attachmentBlend;
        this.attachmentOffsetY = baseStickingOffsetY + (this.lastAttachmentOffsetY - baseStickingOffsetY) * (double)attachmentBlend;
        this.attachmentOffsetZ = baseStickingOffsetZ + (this.lastAttachmentOffsetZ - baseStickingOffsetZ) * (double)attachmentBlend;
        this.attachmentNormal = baseOrientationNormal.m_82549_(this.lastAttachmentOrientationNormal.m_82546_(baseOrientationNormal).m_82490_((double)attachmentBlend)).m_82541_();
        this.attachedTicks = !isAttached ? Math.max(0, this.attachedTicks - 1) : Math.min(5, this.attachedTicks + 1);
        this.orientation = this.calculateOrientation(1.0f);
        Pair<Float, Float> newRotations = this.getOrientation().getLocalRotation(direction);
        float yawDelta = ((Float)newRotations.getLeft()).floatValue() - this.m_146908_();
        float pitchDelta = ((Float)newRotations.getRight()).floatValue() - this.m_146909_();
        this.prevOrientationYawDelta = this.orientationYawDelta;
        this.orientationYawDelta = yawDelta;
        this.f_19857_ = Mth.m_14177_((float)(this.f_19857_ + yawDelta));
        this.f_19859_ = this.wrapAngleInRange(this.f_19859_, this.f_19857_);
        this.f_20907_ = Mth.m_14175_((double)(this.f_20907_ + (double)yawDelta));
        this.f_20883_ = Mth.m_14177_((float)(this.f_20883_ + yawDelta));
        this.f_20884_ = this.wrapAngleInRange(this.f_20884_, this.f_20883_);
        this.f_20885_ = Mth.m_14177_((float)(this.f_20885_ + yawDelta));
        this.f_20886_ = this.wrapAngleInRange(this.f_20886_, this.f_20885_);
        this.f_20933_ = Mth.m_14175_((double)(this.f_20933_ + (double)yawDelta));
        this.f_19858_ = Mth.m_14177_((float)(this.f_19858_ + pitchDelta));
        this.f_19860_ = this.wrapAngleInRange(this.f_19860_, this.f_19858_);
        this.f_20908_ = Mth.m_14175_((double)(this.f_20908_ + (double)pitchDelta));
    }

    private float wrapAngleInRange(float angle, float target) {
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public Orientation calculateOrientation(float partialTicks) {
        Vec3 attachmentNormal = this.prevAttachmentNormal.m_82549_(this.attachmentNormal.m_82546_(this.prevAttachmentNormal).m_82490_((double)partialTicks));
        Vec3 localZ = new Vec3(0.0, 0.0, 1.0);
        Vec3 localY = new Vec3(0.0, 1.0, 0.0);
        Vec3 localX = new Vec3(1.0, 0.0, 0.0);
        float componentZ = (float)localZ.m_82526_(attachmentNormal);
        float componentX = (float)localX.m_82526_(attachmentNormal);
        float yaw = (float)Math.toDegrees(Mth.m_14136_((double)componentX, (double)componentZ));
        localZ = new Vec3(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        localY = new Vec3(0.0, 1.0, 0.0);
        localX = new Vec3(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        componentZ = (float)localZ.m_82526_(attachmentNormal);
        float componentY = (float)localY.m_82526_(attachmentNormal);
        componentX = (float)localX.m_82526_(attachmentNormal);
        float pitch = (float)Math.toDegrees(Mth.m_14136_((double)Mth.m_14116_((float)(componentX * componentX + componentZ * componentZ)), (double)componentY));
        Matrix4f m = new Matrix4f();
        m.multiply(new Matrix4f((float)Math.toRadians(yaw), 0.0f, 1.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(pitch), 1.0f, 0.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(Math.signum(0.5f - componentY - componentZ - componentX) * yaw), 0.0f, 1.0f, 0.0f));
        localZ = m.multiply(new Vec3(0.0, 0.0, -1.0));
        localY = m.multiply(new Vec3(0.0, 1.0, 0.0));
        localX = m.multiply(new Vec3(1.0, 0.0, 0.0));
        return new Orientation(attachmentNormal, localZ, localY, localX, componentZ, componentY, componentX, yaw, pitch);
    }

    @Override
    public float getTargetYaw(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        return (float)this.f_20907_;
    }

    @Override
    public float getTargetPitch(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        return (float)this.f_20908_;
    }

    @Override
    public float getTargetHeadYaw(float yaw, int rotationIncrements) {
        return (float)this.f_20933_;
    }

    @Override
    public void onNotifyDataManagerChange(EntityDataAccessor<?> key) {
        if (ROTATION_BODY.equals(key)) {
            Rotations rotation = (Rotations)this.f_19804_.m_135370_(ROTATION_BODY);
            Vec3 look = new Vec3((double)rotation.m_123156_(), (double)rotation.m_123157_(), (double)rotation.m_123158_());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.f_20907_ = ((Float)rotations.getLeft()).floatValue();
            this.f_20908_ = ((Float)rotations.getRight()).floatValue();
        } else if (ROTATION_HEAD.equals(key)) {
            Rotations rotation = (Rotations)this.f_19804_.m_135370_(ROTATION_HEAD);
            Vec3 look = new Vec3((double)rotation.m_123156_(), (double)rotation.m_123157_(), (double)rotation.m_123158_());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.f_20933_ = ((Float)rotations.getLeft()).floatValue();
            this.f_20934_ = 3;
        }
    }

    private double getGravity() {
        boolean isFalling;
        if (this.m_20068_()) {
            return 0.0;
        }
        double gravity = 0.08;
        boolean bl = isFalling = this.m_20184_().f_82480_ <= 0.0;
        if (isFalling && this.m_21023_(MobEffects.f_19591_)) {
            gravity = 0.1;
        }
        return gravity;
    }

    private Vec3 getStickingForce(Pair<Direction, Vec3> walkingSide) {
        double uprightness = Math.max(this.attachmentNormal.f_82480_, 0.0);
        double gravity = this.getGravity();
        double stickingForce = gravity * uprightness + 0.08 * (1.0 - uprightness);
        return ((Vec3)walkingSide.getRight()).m_82490_(stickingForce);
    }

    @Override
    public void setJumpDirection(Vec3 dir) {
        this.jumpDir = dir != null ? dir.m_82541_() : null;
    }

    @Override
    public boolean onJump() {
        if (this.jumpDir != null) {
            float jumpStrength = this.m_6118_();
            if (this.m_21023_(MobEffects.f_19603_)) {
                jumpStrength += 0.1f * (float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1);
            }
            Vec3 motion = this.m_20184_();
            Vec3 orthogonalMotion = this.jumpDir.m_82490_(this.jumpDir.m_82526_(motion));
            Vec3 tangentialMotion = motion.m_82546_(orthogonalMotion);
            this.m_20334_(tangentialMotion.f_82479_ + this.jumpDir.f_82479_ * (double)jumpStrength, tangentialMotion.f_82480_ + this.jumpDir.f_82480_ * (double)jumpStrength, tangentialMotion.f_82481_ + this.jumpDir.f_82481_ * (double)jumpStrength);
            if (this.m_20142_()) {
                Vec3 boost = this.getOrientation().getGlobal(this.f_19857_, 0.0f).m_82490_((double)0.2f);
                this.m_20256_(this.m_20184_().m_82549_(boost));
            }
            this.f_19812_ = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onTravel(Vec3 relative, boolean pre) {
        if (pre) {
            boolean canTravel = this.m_21515_() || this.m_6109_();
            this.isTravelingInFluid = false;
            FluidState fluidState = this.m_9236_().m_6425_(this.m_20183_());
            if (!this.canClimbInWater && this.m_20069_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (!this.canClimbInLava && this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidState)) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (canTravel) {
                this.travelOnGround(relative);
            }
            if (!canTravel) {
                this.m_267651_(true);
            }
            this.updateOffsetsAndOrientation();
            return true;
        }
        this.updateOffsetsAndOrientation();
        return false;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.m_20096_() ? this.m_6113_() * (0.16277136f / (slipperiness * slipperiness * slipperiness)) : this.m_274460_();
    }

    private void travelOnGround(Vec3 relative) {
        boolean detachedZ;
        boolean isFalling;
        Orientation orientation = this.getOrientation();
        Vec3 forwardVector = orientation.getGlobal(this.f_19857_, 0.0f);
        Vec3 strafeVector = orientation.getGlobal(this.f_19857_ + 90.0f, 0.0f);
        Vec3 upVector = orientation.getGlobal(this.f_19857_, -90.0f);
        Pair<Direction, Vec3> groundDirection = this.getGroundDirection();
        Vec3 stickingForce = this.getStickingForce(groundDirection);
        boolean bl = isFalling = this.m_20184_().f_82480_ <= 0.0;
        if (isFalling && this.m_21023_(MobEffects.f_19591_)) {
            this.f_19789_ = 0.0f;
        }
        float forward = (float)relative.f_82481_;
        float strafe = (float)relative.f_82479_;
        if (forward != 0.0f || strafe != 0.0f) {
            float f;
            float slipperiness = 0.91f;
            if (this.m_20096_()) {
                BlockPos offsetPos = new BlockPos((Vec3i)this.m_20183_()).m_121945_((Direction)groundDirection.getLeft());
                slipperiness = this.getBlockSlipperiness(offsetPos);
            }
            if ((f = forward * forward + strafe * strafe) >= 1.0E-4f) {
                boolean isInnerCorner;
                f = Math.max(Mth.m_14116_((float)f), 1.0f);
                f = this.getRelevantMoveFactor(slipperiness) / f;
                Vec3 movementOffset = new Vec3(forwardVector.f_82479_ * (double)(forward *= f) + strafeVector.f_82479_ * (double)(strafe *= f), forwardVector.f_82480_ * (double)forward + strafeVector.f_82480_ * (double)strafe, forwardVector.f_82481_ * (double)forward + strafeVector.f_82481_ * (double)strafe);
                double px = this.m_20185_();
                double py = this.m_20186_();
                double pz = this.m_20189_();
                Vec3 motion = this.m_20184_();
                AABB aabb = this.m_20191_();
                this.m_6478_(MoverType.SELF, movementOffset);
                Vec3 movementDir = new Vec3(this.m_20185_() - px, this.m_20186_() - py, this.m_20189_() - pz).m_82541_();
                this.m_20011_(aabb);
                this.setLocationFromBoundingbox();
                this.m_20256_(motion);
                Vec3 probeVector = new Vec3(Math.abs(movementDir.f_82479_) < 0.001 ? -Math.signum(upVector.f_82479_) : 0.0, Math.abs(movementDir.f_82480_) < 0.001 ? -Math.signum(upVector.f_82480_) : 0.0, Math.abs(movementDir.f_82481_) < 0.001 ? -Math.signum(upVector.f_82481_) : 0.0).m_82541_().m_82490_(1.0E-4);
                this.m_6478_(MoverType.SELF, probeVector);
                Vec3 collisionNormal = new Vec3(Math.abs(this.m_20185_() - px - probeVector.f_82479_) > 1.0E-6 ? Math.signum(-probeVector.f_82479_) : 0.0, Math.abs(this.m_20186_() - py - probeVector.f_82480_) > 1.0E-6 ? Math.signum(-probeVector.f_82480_) : 0.0, Math.abs(this.m_20189_() - pz - probeVector.f_82481_) > 1.0E-6 ? Math.signum(-probeVector.f_82481_) : 0.0).m_82541_();
                this.m_20011_(aabb);
                this.setLocationFromBoundingbox();
                this.m_20256_(motion);
                Vec3 surfaceMovementDir = movementDir.m_82546_(collisionNormal.m_82490_(collisionNormal.m_82526_(movementDir))).m_82541_();
                boolean bl2 = isInnerCorner = Math.abs(collisionNormal.f_82479_) + Math.abs(collisionNormal.f_82480_) + Math.abs(collisionNormal.f_82481_) > (double)1.0001f;
                if (!isInnerCorner) {
                    movementDir = surfaceMovementDir;
                }
                stickingForce = stickingForce.m_82546_(surfaceMovementDir.m_82490_(surfaceMovementDir.m_82541_().m_82526_(stickingForce)));
                float moveSpeed = Mth.m_14116_((float)(forward * forward + strafe * strafe));
                this.m_20256_(this.m_20184_().m_82549_(movementDir.m_82490_((double)moveSpeed)));
            }
        }
        this.m_20256_(this.m_20184_().m_82549_(stickingForce));
        double px = this.m_20185_();
        double py = this.m_20186_();
        double pz = this.m_20189_();
        Vec3 motion = this.m_20184_();
        this.m_6478_(MoverType.SELF, motion);
        this.prevAttachedSides = this.attachedSides;
        this.attachedSides = new Vec3(Math.abs(this.m_20185_() - px - motion.f_82479_) > 0.001 ? -Math.signum(motion.f_82479_) : 0.0, Math.abs(this.m_20186_() - py - motion.f_82480_) > 0.001 ? -Math.signum(motion.f_82480_) : 0.0, Math.abs(this.m_20189_() - pz - motion.f_82481_) > 0.001 ? -Math.signum(motion.f_82481_) : 0.0);
        float slipperiness = 0.91f;
        if (this.m_20096_()) {
            this.f_19789_ = 0.0f;
            BlockPos offsetPos = new BlockPos((Vec3i)this.m_20183_()).m_121945_((Direction)groundDirection.getLeft());
            slipperiness = this.getBlockSlipperiness(offsetPos);
        }
        motion = this.m_20184_();
        Vec3 orthogonalMotion = upVector.m_82490_(upVector.m_82526_(motion));
        Vec3 tangentialMotion = motion.m_82546_(orthogonalMotion);
        this.m_20334_(tangentialMotion.f_82479_ * (double)slipperiness + orthogonalMotion.f_82479_ * (double)0.98f, tangentialMotion.f_82480_ * (double)slipperiness + orthogonalMotion.f_82480_ * (double)0.98f, tangentialMotion.f_82481_ * (double)slipperiness + orthogonalMotion.f_82481_ * (double)0.98f);
        boolean detachedX = this.attachedSides.f_82479_ != this.prevAttachedSides.f_82479_ && Math.abs(this.attachedSides.f_82479_) < 0.001;
        boolean detachedY = this.attachedSides.f_82480_ != this.prevAttachedSides.f_82480_ && Math.abs(this.attachedSides.f_82480_) < 0.001;
        boolean bl3 = detachedZ = this.attachedSides.f_82481_ != this.prevAttachedSides.f_82481_ && Math.abs(this.attachedSides.f_82481_) < 0.001;
        if (detachedX || detachedY || detachedZ) {
            float stepHeight = this.m_274421_();
            this.m_274367_(0.0f);
            boolean prevOnGround = this.m_20096_();
            boolean prevCollidedHorizontally = this.f_19862_;
            boolean prevCollidedVertically = this.f_19863_;
            this.m_6478_(MoverType.SELF, new Vec3(detachedX ? -this.prevAttachedSides.f_82479_ * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.f_82480_ * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.f_82481_ * 0.25 : 0.0));
            Vec3 axis = this.prevAttachedSides.m_82541_();
            Vec3 attachVector = upVector.m_82490_(-1.0);
            attachVector = attachVector.m_82546_(axis.m_82490_(axis.m_82526_(attachVector)));
            attachVector = Math.abs(attachVector.f_82479_) > Math.abs(attachVector.f_82480_) && Math.abs(attachVector.f_82479_) > Math.abs(attachVector.f_82481_) ? new Vec3(Math.signum(attachVector.f_82479_), 0.0, 0.0) : (Math.abs(attachVector.f_82480_) > Math.abs(attachVector.f_82481_) ? new Vec3(0.0, Math.signum(attachVector.f_82480_), 0.0) : new Vec3(0.0, 0.0, Math.signum(attachVector.f_82481_)));
            double attachDst = motion.m_82553_() + (double)0.1f;
            AABB aabb = this.m_20191_();
            motion = this.m_20184_();
            for (int i = 0; i < 2 && !this.m_20096_(); ++i) {
                this.m_6478_(MoverType.SELF, attachVector.m_82490_(attachDst));
            }
            this.m_274367_(stepHeight);
            if (!this.m_20096_()) {
                this.m_20011_(aabb);
                this.setLocationFromBoundingbox();
                this.m_20256_(motion);
                this.m_6853_(prevOnGround);
                this.f_19862_ = prevCollidedHorizontally;
                this.f_19863_ = prevCollidedVertically;
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        }
        this.m_267651_(true);
    }

    @Override
    public boolean onMove(MoverType type, Vec3 pos, boolean pre) {
        if (pre) {
            this.preWalkingPosition = this.m_20182_();
            this.preMoveY = this.m_20186_();
        } else {
            if (Math.abs(this.m_20186_() - this.preMoveY - pos.f_82480_) > 1.0E-6) {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
            this.m_6853_(this.f_19862_ || this.f_19863_);
        }
        return false;
    }

    @Override
    public BlockPos getAdjustedOnPosition(BlockPos onPosition) {
        float verticalOffset = this.getVerticalOffset(1.0f);
        int x = Mth.m_14107_((double)(this.m_20185_() + this.attachmentOffsetX - (double)((float)this.attachmentNormal.f_82479_ * (verticalOffset + 0.2f))));
        int y = Mth.m_14107_((double)(this.m_20186_() + this.attachmentOffsetY - (double)((float)this.attachmentNormal.f_82480_ * (verticalOffset + 0.2f))));
        int z = Mth.m_14107_((double)(this.m_20189_() + this.attachmentOffsetZ - (double)((float)this.attachmentNormal.f_82481_ * (verticalOffset + 0.2f))));
        BlockPos pos = new BlockPos(x, y, z);
        if (this.m_9236_().m_46859_(pos) && this.attachmentNormal.f_82480_ < 0.0) {
            BlockPos posDown = pos.m_7495_();
            BlockState stateDown = this.m_9236_().m_8055_(posDown);
            if (stateDown.m_204336_(BlockTags.f_13039_) || stateDown.m_204336_(BlockTags.f_13032_) || stateDown.m_60734_() instanceof FenceGateBlock) {
                return posDown;
            }
        }
        return pos;
    }

    @Override
    public boolean getAdjustedCanTriggerWalking(boolean canTriggerWalking) {
        if (this.preWalkingPosition != null && this.canClimberTriggerWalking() && !this.m_20159_()) {
            Vec3 moved = this.m_20182_().m_82546_(this.preWalkingPosition);
            this.preWalkingPosition = null;
            BlockPos pos = this.m_20097_();
            BlockState state = this.m_9236_().m_8055_(pos);
            double dx = moved.f_82479_;
            double dy = moved.f_82480_;
            double dz = moved.f_82481_;
            Vec3 tangentialMovement = moved.m_82546_(this.attachmentNormal.m_82490_(this.attachmentNormal.m_82526_(moved)));
            this.f_19787_ = (float)((double)this.f_19787_ + tangentialMovement.m_82553_() * 0.6);
            this.f_19788_ = (float)((double)this.f_19788_ + Math.sqrt(dx * dx + dy * dy + dz * dz) * 0.6);
            if (this.f_19788_ > this.nextStepDistance && !state.m_60795_()) {
                this.nextStepDistance = this.m_6059_();
                if (this.m_20069_()) {
                    ClimberEntityMixin controller = this.m_20160_() && this.m_6688_() != null ? this.m_6688_() : this;
                    float multiplier = controller == this ? 0.35f : 0.4f;
                    Vec3 motion = controller.m_20184_();
                    float swimStrength = (float)Math.sqrt(motion.f_82479_ * motion.f_82479_ * (double)0.2f + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_ * (double)0.2f) * multiplier;
                    if (swimStrength > 1.0f) {
                        swimStrength = 1.0f;
                    }
                    this.m_5625_(swimStrength);
                } else {
                    this.m_7355_(pos, state);
                }
            } else if (state.m_60795_()) {
                this.m_146874_();
            }
        }
        return false;
    }

    @Override
    public boolean canClimberTriggerWalking() {
        return true;
    }

    public void setLocationFromBoundingbox() {
        AABB axisalignedbb = this.m_20191_();
        this.m_20343_((axisalignedbb.f_82288_ + axisalignedbb.f_82291_) / 2.0, axisalignedbb.f_82289_, (axisalignedbb.f_82290_ + axisalignedbb.f_82293_) / 2.0);
    }

    static {
        Class<?> cls = MethodHandles.lookup().lookupClass();
        MOVEMENT_TARGET_X = SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        MOVEMENT_TARGET_Y = SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        MOVEMENT_TARGET_Z = SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        ImmutableList.Builder pathingTargets = ImmutableList.builder();
        ImmutableList.Builder pathingSides = ImmutableList.builder();
        for (int i = 0; i < 8; ++i) {
            pathingTargets.add((Object)SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135039_));
            pathingSides.add((Object)SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135040_));
        }
        PATHING_TARGETS = pathingTargets.build();
        PATHING_SIDES = pathingSides.build();
        ROTATION_BODY = SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135037_);
        ROTATION_HEAD = SynchedEntityData.m_135353_(cls, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    }
}

