/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.spiderstpo.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static final Config DEFAULT = new Config(true, false);
    private final boolean preventClimbingInRain;
    private final boolean pathFinderDebugPreview;
    private static Config INSTANCE = null;

    private Config(boolean preventClimbingInRain, boolean pathFinderDebugPreview) {
        this.preventClimbingInRain = preventClimbingInRain;
        this.pathFinderDebugPreview = pathFinderDebugPreview;
    }

    public static Config getConfig() {
        return Config.getConfig(false);
    }

    public static Config getConfig(boolean serialize) {
        if (INSTANCE == null || serialize) {
            INSTANCE = Config.readConfig();
        }
        return INSTANCE;
    }

    private static Config readConfig() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("spiders-2.0.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!path.toFile().exists()) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
                String s = gson.toJson((Object)DEFAULT);
                Files.write(path, s.getBytes(), new OpenOption[0]);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            return (Config)gson.fromJson((Reader)new FileReader(path.toFile()), Config.class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return DEFAULT;
        }
    }

    public boolean isPathFinderDebugPreview() {
        return this.pathFinderDebugPreview;
    }

    public boolean isPreventClimbingInRain() {
        return this.preventClimbingInRain;
    }
}

