/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.spiderstpo.common.entity.movement;

import com.google.common.collect.ImmutableSet;
import com.nyfaria.spiderstpo.common.entity.mob.IClimberEntity;
import com.nyfaria.spiderstpo.common.entity.mob.Orientation;
import com.nyfaria.spiderstpo.common.entity.movement.AdvancedGroundPathNavigator;
import com.nyfaria.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;
import com.nyfaria.spiderstpo.common.entity.movement.ClimberMoveController;
import com.nyfaria.spiderstpo.common.entity.movement.DirectionalPathPoint;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1335;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4209;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class AdvancedClimberPathNavigator<T extends class_1308>
extends AdvancedGroundPathNavigator<T> {
    protected final IClimberEntity climber;
    protected class_2350 verticalFacing = class_2350.field_11033;
    protected boolean findDirectPathPoints = false;

    public AdvancedClimberPathNavigator(T entity, class_1937 worldIn, boolean checkObstructions, boolean canPathWalls, boolean canPathCeiling) {
        super(entity, worldIn, checkObstructions);
        this.climber = (IClimberEntity)entity;
        if (this.field_6678 instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.field_6678;
            processor.setStartPathOnGround(false);
            processor.setCanPathWalls(canPathWalls);
            processor.setCanPathCeiling(canPathCeiling);
        }
    }

    protected class_243 method_6347() {
        return this.field_6684.method_19538().method_1031(0.0, (double)(this.field_6684.method_17682() / 2.0f), 0.0);
    }

    @Nullable
    public class_11 method_6348(class_2338 pos, int checkpointRange) {
        return this.method_35142((Set<class_2338>)ImmutableSet.of((Object)pos), 8, false, checkpointRange);
    }

    @Nullable
    public class_11 method_6349(class_1297 entityIn, int checkpointRange) {
        return this.method_35142((Set<class_2338>)ImmutableSet.of((Object)entityIn.method_24515()), 16, true, checkpointRange);
    }

    public void method_6360() {
        ++this.field_6675;
        if (this.field_6679) {
            this.method_6356();
        }
        if (!this.method_6357()) {
            if (this.method_6358()) {
                this.method_6339();
            } else if (this.field_6681 != null && !this.field_6681.method_46()) {
                class_243 pos = this.method_6347();
                class_243 targetPos = this.field_6681.method_49((class_1297)this.field_6684);
                if (pos.field_1351 > targetPos.field_1351 && !this.field_6684.method_24828() && class_3532.method_15357((double)pos.field_1352) == class_3532.method_15357((double)targetPos.field_1352) && class_3532.method_15357((double)pos.field_1350) == class_3532.method_15357((double)targetPos.field_1350)) {
                    this.field_6681.method_44();
                }
            }
            class_4209.method_19470((class_1937)this.field_6677, (class_1308)this.field_6684, (class_11)this.field_6681, (float)this.field_6683);
            if (!this.method_6357()) {
                class_9 targetPoint = this.field_6681.method_40(this.field_6681.method_39());
                class_2350 dir = null;
                if (targetPoint instanceof DirectionalPathPoint) {
                    dir = ((DirectionalPathPoint)targetPoint).getPathSide();
                }
                if (dir == null) {
                    dir = class_2350.field_11033;
                }
                class_243 targetPos = this.getExactPathingTarget((class_1922)this.field_6677, targetPoint.method_22879(), dir);
                class_1335 moveController = this.field_6684.method_5962();
                if (moveController instanceof ClimberMoveController && targetPoint instanceof DirectionalPathPoint && ((DirectionalPathPoint)targetPoint).getPathSide() != null) {
                    ((ClimberMoveController)moveController).setMoveTo(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, targetPoint.method_22879().method_10093(dir), ((DirectionalPathPoint)targetPoint).getPathSide(), this.field_6668);
                } else {
                    moveController.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, this.field_6668);
                }
            }
        }
    }

    public class_243 getExactPathingTarget(class_1922 blockaccess, class_2338 pos, class_2350 dir) {
        class_2338 offsetPos = pos.method_10093(dir);
        class_265 shape = blockaccess.method_8320(offsetPos).method_26220(blockaccess, offsetPos);
        class_2350.class_2351 axis = dir.method_10166();
        int sign = dir.method_10148() + dir.method_10164() + dir.method_10165();
        double offset = shape.method_1110() ? (double)sign : (sign > 0 ? shape.method_1091(axis) - 1.0 : shape.method_1105(axis));
        double marginXZ = 1.0f - this.field_6684.method_17681() % 1.0f;
        double marginY = 1.0f - this.field_6684.method_17682() % 1.0f;
        double pathingOffsetXZ = (double)((int)(this.field_6684.method_17681() + 1.0f)) * 0.5;
        double pathingOffsetY = (double)((int)(this.field_6684.method_17682() + 1.0f)) * 0.5 - (double)(this.field_6684.method_17682() * 0.5f);
        double x = (double)offsetPos.method_10263() + pathingOffsetXZ + (double)dir.method_10148() * marginXZ;
        double y = (double)offsetPos.method_10264() + pathingOffsetY + (dir == class_2350.field_11033 ? -pathingOffsetY : 0.0) + (dir == class_2350.field_11036 ? -pathingOffsetY + marginY : 0.0);
        double z = (double)offsetPos.method_10260() + pathingOffsetXZ + (double)dir.method_10165() * marginXZ;
        switch (axis) {
            default: {
                return new class_243(x + offset, y, z);
            }
            case field_11052: {
                return new class_243(x, y + offset, z);
            }
            case field_11051: 
        }
        return new class_243(x, y, z + offset);
    }

    protected void method_6339() {
        class_243 pos = this.method_6347();
        this.field_6683 = this.field_6684.method_17681() > 0.75f ? this.field_6684.method_17681() / 2.0f : 0.75f - this.field_6684.method_17681() / 2.0f;
        float maxDistanceToWaypointY = Math.max(1.0f, this.field_6684.method_17682() > 0.75f ? this.field_6684.method_17682() / 2.0f : 0.75f - this.field_6684.method_17682() / 2.0f);
        int sizeX = class_3532.method_15386((float)this.field_6684.method_17681());
        int sizeY = class_3532.method_15386((float)this.field_6684.method_17682());
        int sizeZ = sizeX;
        Orientation orientation = this.climber.getOrientation();
        class_243 upVector = orientation.getGlobal(this.field_6684.field_6031, -90.0f);
        this.verticalFacing = class_2350.method_10147((float)((float)upVector.field_1352), (float)((float)upVector.field_1351), (float)((float)upVector.field_1350));
        for (int i = 4; i >= 0; --i) {
            class_2350 targetSide;
            if (this.field_6681.method_39() + i >= this.field_6681.method_38()) continue;
            class_9 currentTarget = this.field_6681.method_40(this.field_6681.method_39() + i);
            double dx = Math.abs((double)((float)currentTarget.field_40 + (float)((int)(this.field_6684.method_17681() + 1.0f)) * 0.5f) - this.field_6684.method_23317());
            double dy = Math.abs((double)currentTarget.field_39 - this.field_6684.method_23318());
            double dz = Math.abs((double)((float)currentTarget.field_38 + (float)((int)(this.field_6684.method_17681() + 1.0f)) * 0.5f) - this.field_6684.method_23321());
            boolean isWaypointInReach = dx < (double)this.field_6683 && dy < (double)maxDistanceToWaypointY && dz < (double)this.field_6683;
            boolean isOnSameSideAsTarget = false;
            isOnSameSideAsTarget = this.method_6350() && (currentTarget.field_41 == class_7.field_18 || currentTarget.field_41 == class_7.field_4 || currentTarget.field_41 == class_7.field_14) ? true : (currentTarget instanceof DirectionalPathPoint ? (targetSide = ((DirectionalPathPoint)currentTarget).getPathSide()) == null || this.climber.getGroundDirection().getLeft() == targetSide : true);
            if (!isOnSameSideAsTarget || !isWaypointInReach && (i != 0 || !this.field_6684.method_29244(this.field_6681.method_29301().field_41) || !this.isNextTargetInLine(pos, sizeX, sizeY, sizeZ, 1 + i))) continue;
            this.field_6681.method_42(this.field_6681.method_39() + 1 + i);
            break;
        }
        if (this.findDirectPathPoints) {
            class_2350.class_2351 verticalAxis = this.verticalFacing.method_10166();
            int firstDifferentHeightPoint = this.field_6681.method_38();
            block0 : switch (verticalAxis) {
                case field_11048: {
                    for (int i = this.field_6681.method_39(); i < this.field_6681.method_38(); ++i) {
                        if ((double)this.field_6681.method_40((int)i).field_40 == Math.floor(pos.field_1352)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case field_11052: {
                    for (int i = this.field_6681.method_39(); i < this.field_6681.method_38(); ++i) {
                        if ((double)this.field_6681.method_40((int)i).field_39 == Math.floor(pos.field_1351)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case field_11051: {
                    for (int i = this.field_6681.method_39(); i < this.field_6681.method_38(); ++i) {
                        if ((double)this.field_6681.method_40((int)i).field_38 == Math.floor(pos.field_1350)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
            }
            for (int i = firstDifferentHeightPoint - 1; i >= this.field_6681.method_39(); --i) {
                if (!this.method_6341(pos, this.field_6681.method_47((class_1297)this.field_6684, i))) continue;
                this.field_6681.method_42(i);
                break;
            }
        }
        this.method_6346(pos);
    }

    private boolean isNextTargetInLine(class_243 pos, int sizeX, int sizeY, int sizeZ, int offset) {
        class_243 currentDir;
        if (this.field_6681.method_39() + offset >= this.field_6681.method_38()) {
            return false;
        }
        class_243 currentTarget = class_243.method_24955((class_2382)this.field_6681.method_31032());
        if (!pos.method_24802((class_2374)currentTarget, 2.0)) {
            return false;
        }
        class_243 nextTarget = class_243.method_24955((class_2382)this.field_6681.method_31031(this.field_6681.method_39() + offset));
        class_243 targetDir = nextTarget.method_1020(currentTarget);
        if (targetDir.method_1026(currentDir = pos.method_1020(currentTarget)) > 0.0) {
            class_2350.class_2351 az;
            class_2350.class_2351 ay;
            class_2350.class_2351 ax;
            return this.isSafeToStandAt(class_3532.method_15357((double)nextTarget.field_1352), class_3532.method_15357((double)nextTarget.field_1351), class_3532.method_15357((double)nextTarget.field_1350), sizeX, sizeY, sizeZ, currentTarget, 0.0, 0.0, -1.0, ax, ay, az, switch (this.verticalFacing.method_10166()) {
                case class_2350.class_2351.field_11048 -> {
                    ax = class_2350.class_2351.field_11051;
                    ay = class_2350.class_2351.field_11048;
                    az = class_2350.class_2351.field_11052;
                    yield this.verticalFacing.method_10148() < 0;
                }
                default -> {
                    ax = class_2350.class_2351.field_11048;
                    ay = class_2350.class_2351.field_11052;
                    az = class_2350.class_2351.field_11051;
                    yield this.verticalFacing.method_10164() < 0;
                }
                case class_2350.class_2351.field_11051 -> {
                    ax = class_2350.class_2351.field_11052;
                    ay = class_2350.class_2351.field_11051;
                    az = class_2350.class_2351.field_11048;
                    yield this.verticalFacing.method_10165() < 0;
                }
            });
        }
        return false;
    }

    protected boolean method_6341(class_243 start, class_243 end) {
        int sizeX = 0;
        int sizeY = 0;
        int sizeZ = 0;
        switch (this.verticalFacing.method_10166()) {
            case field_11048: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, class_2350.class_2351.field_11051, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, 0.0, this.verticalFacing.method_10148() < 0);
            }
            case field_11052: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051, 0.0, this.verticalFacing.method_10164() < 0);
            }
            case field_11051: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051, class_2350.class_2351.field_11048, 0.0, this.verticalFacing.method_10165() < 0);
            }
        }
        return false;
    }

    protected static double swizzle(class_243 vec, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return vec.field_1352;
            }
            case field_11052: {
                return vec.field_1351;
            }
            case field_11051: {
                return vec.field_1350;
            }
        }
        return 0.0;
    }

    protected static int swizzle(int x, int y, int z, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return x;
            }
            case field_11052: {
                return y;
            }
            case field_11051: {
                return z;
            }
        }
        return 0;
    }

    protected static int unswizzle(int x, int y, int z, class_2350.class_2351 ax, class_2350.class_2351 ay, class_2350.class_2351 az, class_2350.class_2351 axis) {
        class_2350.class_2351 unswizzle = axis == ax ? class_2350.class_2351.field_11048 : (axis == ay ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
        return AdvancedClimberPathNavigator.swizzle(x, y, z, unswizzle);
    }

    protected boolean isDirectPathBetweenPoints(class_243 start, class_243 end, int sizeX, int sizeY, int sizeZ, class_2350.class_2351 ax, class_2350.class_2351 ay, class_2350.class_2351 az, double minDotProduct, boolean invertY) {
        int bx = class_3532.method_15357((double)AdvancedClimberPathNavigator.swizzle(start, ax));
        int bz = class_3532.method_15357((double)AdvancedClimberPathNavigator.swizzle(start, az));
        double dx = AdvancedClimberPathNavigator.swizzle(end, ax) - AdvancedClimberPathNavigator.swizzle(start, ax);
        double dz = AdvancedClimberPathNavigator.swizzle(end, az) - AdvancedClimberPathNavigator.swizzle(start, az);
        double dSq = dx * dx + dz * dz;
        int by = (int)AdvancedClimberPathNavigator.swizzle(start, ay);
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeY2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ay);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        if (dSq < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(dSq);
        if (!this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11051), AdvancedClimberPathNavigator.unswizzle(sizeX2 += 2, sizeY2, sizeZ2 += 2, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, class_2350.class_2351.field_11051), start, dx *= d3, dz *= d3, minDotProduct, ax, ay, az, invertY)) {
            return false;
        }
        sizeX2 -= 2;
        sizeZ2 -= 2;
        double stepX = 1.0 / Math.abs(dx);
        double stepZ = 1.0 / Math.abs(dz);
        double relX = (double)bx - AdvancedClimberPathNavigator.swizzle(start, ax);
        double relZ = (double)bz - AdvancedClimberPathNavigator.swizzle(start, az);
        if (dx >= 0.0) {
            relX += 1.0;
        }
        if (dz >= 0.0) {
            relZ += 1.0;
        }
        relX /= dx;
        relZ /= dz;
        int dirX = dx < 0.0 ? -1 : 1;
        int dirZ = dz < 0.0 ? -1 : 1;
        int ex = class_3532.method_15357((double)AdvancedClimberPathNavigator.swizzle(end, ax));
        int ez = class_3532.method_15357((double)AdvancedClimberPathNavigator.swizzle(end, az));
        int offsetX = ex - bx;
        int offsetZ = ez - bz;
        while (offsetX * dirX > 0 || offsetZ * dirZ > 0) {
            if (relX < relZ) {
                relX += stepX;
                offsetX = ex - (bx += dirX);
            } else {
                relZ += stepZ;
                offsetZ = ez - (bz += dirZ);
            }
            if (this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, class_2350.class_2351.field_11051), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, class_2350.class_2351.field_11051), start, dx, dz, minDotProduct, ax, ay, az, invertY)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, class_243 start, double dx, double dz, double minDotProduct, class_2350.class_2351 ax, class_2350.class_2351 ay, class_2350.class_2351 az, boolean invertY) {
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        int bx = AdvancedClimberPathNavigator.swizzle(x, y, z, ax) - sizeX2 / 2;
        int bz = AdvancedClimberPathNavigator.swizzle(x, y, z, az) - sizeZ2 / 2;
        int by = AdvancedClimberPathNavigator.swizzle(x, y, z, ay);
        if (!this.isPositionClear(AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, class_2350.class_2351.field_11051), sizeX, sizeY, sizeZ, start, dx, dz, minDotProduct, ax, ay, az)) {
            return false;
        }
        for (int obx = bx; obx < bx + sizeX2; ++obx) {
            for (int obz = bz; obz < bz + sizeZ2; ++obz) {
                double offsetZ;
                double offsetX = (double)obx + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
                if (!(offsetX * dx + (offsetZ = (double)obz + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct)) continue;
                class_7 nodeTypeBelow = this.field_6678.method_25((class_1922)this.field_6677, AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, class_2350.class_2351.field_11051), this.field_6684, sizeX, sizeY, sizeZ, true, true);
                if (nodeTypeBelow == class_7.field_18) {
                    return false;
                }
                if (nodeTypeBelow == class_7.field_14) {
                    return false;
                }
                if (nodeTypeBelow == class_7.field_7) {
                    return false;
                }
                class_7 nodeType = this.field_6678.method_25((class_1922)this.field_6677, AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, class_2350.class_2351.field_11048), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, class_2350.class_2351.field_11052), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, class_2350.class_2351.field_11051), this.field_6684, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_6684.method_5944(nodeType);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (nodeType != class_7.field_3 && nodeType != class_7.field_9 && nodeType != class_7.field_17) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, class_243 start, double dx, double dz, double minDotProduct, class_2350.class_2351 ax, class_2350.class_2351 ay, class_2350.class_2351 az) {
        for (class_2338 pos : class_2338.method_10097((class_2338)new class_2338(x, y, z), (class_2338)new class_2338(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            class_2680 state;
            double pffsetZ;
            double offsetX;
            if (!this.field_6677.method_8477(pos) || !((offsetX = (double)AdvancedClimberPathNavigator.swizzle(pos.method_10263(), pos.method_10264(), pos.method_10260(), ax) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax)) * dx + (pffsetZ = (double)AdvancedClimberPathNavigator.swizzle(pos.method_10263(), pos.method_10264(), pos.method_10260(), az) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct) || (state = this.field_6677.method_8320(pos)).method_26171((class_1922)this.field_6677, pos, class_10.field_50)) continue;
            return false;
        }
        return true;
    }
}

