/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.spiderstpo.common.entity.movement;

import com.nyfaria.spiderstpo.common.entity.movement.DirectionalPathPoint;
import com.nyfaria.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class AdvancedWalkNodeProcessor
extends class_14 {
    protected static final class_7[] PATH_NODE_TYPES = class_7.values();
    protected static final class_2350[] DIRECTIONS = class_2350.values();
    protected static final class_2382 PX = new class_2382(1, 0, 0);
    protected static final class_2382 NX = new class_2382(-1, 0, 0);
    protected static final class_2382 PY = new class_2382(0, 1, 0);
    protected static final class_2382 NY = new class_2382(0, -1, 0);
    protected static final class_2382 PZ = new class_2382(0, 0, 1);
    protected static final class_2382 NZ = new class_2382(0, 0, -1);
    protected static final class_2382 PXPY = new class_2382(1, 1, 0);
    protected static final class_2382 NXPY = new class_2382(-1, 1, 0);
    protected static final class_2382 PXNY = new class_2382(1, -1, 0);
    protected static final class_2382 NXNY = new class_2382(-1, -1, 0);
    protected static final class_2382 PXPZ = new class_2382(1, 0, 1);
    protected static final class_2382 NXPZ = new class_2382(-1, 0, 1);
    protected static final class_2382 PXNZ = new class_2382(1, 0, -1);
    protected static final class_2382 NXNZ = new class_2382(-1, 0, -1);
    protected static final class_2382 PYPZ = new class_2382(0, 1, 1);
    protected static final class_2382 NYPZ = new class_2382(0, -1, 1);
    protected static final class_2382 PYNZ = new class_2382(0, 1, -1);
    protected static final class_2382 NYNZ = new class_2382(0, -1, -1);
    protected IAdvancedPathFindingEntity advancedPathFindingEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<class_2350> pathableFacings = EnumSet.of(class_2350.field_11033);
    protected class_2350[] pathableFacingsArray;
    private final Long2LongMap pathNodeTypeCache = new Long2LongOpenHashMap();
    private final Long2ObjectMap<class_7> rawPathNodeTypeCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<class_238> aabbCollisionCache = new Object2BooleanOpenHashMap();
    protected boolean alwaysAllowDiagonals = true;

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(class_2350.field_11043);
            this.pathableFacings.add(class_2350.field_11034);
            this.pathableFacings.add(class_2350.field_11035);
            this.pathableFacings.add(class_2350.field_11039);
        } else {
            this.pathableFacings.remove(class_2350.field_11043);
            this.pathableFacings.remove(class_2350.field_11034);
            this.pathableFacings.remove(class_2350.field_11035);
            this.pathableFacings.remove(class_2350.field_11039);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(class_2350.field_11036);
        } else {
            this.pathableFacings.remove(class_2350.field_11036);
        }
    }

    public void method_12(class_1950 sourceIn, class_1308 mob) {
        super.method_12(sourceIn, mob);
        if (!(mob instanceof IAdvancedPathFindingEntity)) {
            throw new IllegalArgumentException("Only mobs that extend " + IAdvancedPathFindingEntity.class.getSimpleName() + " are supported. Received: " + mob.getClass().getName());
        }
        this.advancedPathFindingEntity = (IAdvancedPathFindingEntity)mob;
        this.pathingSizeOffsetX = Math.max(1, class_3532.method_15375((float)(this.field_33.method_17681() / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, class_3532.method_15375((float)(this.field_33.method_17682() + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, class_3532.method_15375((float)(this.field_33.method_17681() / 2.0f + 1.0f)));
        this.pathableFacingsArray = this.pathableFacings.toArray(new class_2350[0]);
    }

    public void method_19() {
        super.method_19();
        this.pathNodeTypeCache.clear();
        this.rawPathNodeTypeCache.clear();
        this.aabbCollisionCache.clear();
        this.advancedPathFindingEntity.pathFinderCleanup();
    }

    private boolean checkAabbCollision(class_238 aabb) {
        return this.aabbCollisionCache.computeIfAbsent((Object)aabb, p_237237_2_ -> !this.field_20622.method_8587((class_1297)this.field_33, aabb));
    }

    public class_9 method_21() {
        class_2338 initialStartPos;
        int by;
        class_2338.class_2339 checkPos;
        double z;
        double x;
        block12: {
            x = this.field_33.method_23317();
            double y = this.field_33.method_23318();
            z = this.field_33.method_23321();
            checkPos = new class_2338.class_2339();
            by = class_3532.method_15357((double)y);
            class_2680 state = this.field_20622.method_8320((class_2338)checkPos.method_10102(x, (double)by, z));
            if (!this.field_33.method_26319(state.method_26227())) {
                if (this.method_22() && this.field_33.method_5799()) {
                    while (true) {
                        if (state.method_26204() != class_2246.field_10382 && state.method_26227() != class_3612.field_15910.method_15729(false)) {
                            --by;
                            break block12;
                        }
                        state = this.field_20622.method_8320((class_2338)checkPos.method_10102(x, (double)(++by), z));
                    }
                }
                if (this.field_33.method_24828() || !this.startFromGround) {
                    by = class_3532.method_15357((double)(y + Math.min(0.5, Math.max((double)(this.field_33.method_17682() - 0.1f), 0.0))));
                } else {
                    class_2338 blockpos = this.field_33.method_24515();
                    while ((this.field_20622.method_8320(blockpos).method_26215() || this.field_20622.method_8320(blockpos).method_26171((class_1922)this.field_20622, blockpos, class_10.field_50)) && blockpos.method_10264() > 0) {
                        blockpos = blockpos.method_10074();
                    }
                    by = blockpos.method_10084().method_10264();
                }
            } else {
                while (this.field_33.method_26319(state.method_26227())) {
                    state = this.field_20622.method_8320((class_2338)checkPos.method_10102(x, (double)(++by), z));
                }
                --by;
            }
        }
        class_2338 startPos = initialStartPos = new class_2338(x, (double)by, z);
        long packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_33, startPos.method_10263(), startPos.method_10264(), startPos.method_10260()));
        DirectionalPathPoint startPathPoint = this.openPoint(startPos.method_10263(), startPos.method_10264(), startPos.method_10260(), packed, false);
        startPathPoint.field_41 = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        startPathPoint.field_43 = this.field_33.method_5944(startPathPoint.field_41);
        startPos = this.findSuitableStartingPosition(startPos, startPathPoint);
        if (!initialStartPos.equals((Object)startPos)) {
            packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_33, startPos.method_10263(), startPos.method_10264(), startPos.method_10260()));
            startPathPoint = this.openPoint(startPos.method_10263(), startPos.method_10264(), startPos.method_10260(), packed, false);
            startPathPoint.field_41 = AdvancedWalkNodeProcessor.unpackNodeType(packed);
            startPathPoint.field_43 = this.field_33.method_5944(startPathPoint.field_41);
        }
        if (this.field_33.method_5944(startPathPoint.field_41) < 0.0f) {
            class_238 aabb = this.field_33.method_5829();
            if (this.isSafeStartingPosition((class_2338)checkPos.method_10102(aabb.field_1323, (double)by, aabb.field_1321)) || this.isSafeStartingPosition((class_2338)checkPos.method_10102(aabb.field_1323, (double)by, aabb.field_1324)) || this.isSafeStartingPosition((class_2338)checkPos.method_10102(aabb.field_1320, (double)by, aabb.field_1321)) || this.isSafeStartingPosition((class_2338)checkPos.method_10102(aabb.field_1320, (double)by, aabb.field_1324))) {
                packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_33, checkPos.method_10263(), checkPos.method_10264(), checkPos.method_10260()));
                startPathPoint = this.openPoint(checkPos.method_10263(), checkPos.method_10264(), checkPos.method_10260(), packed, false);
                startPathPoint.field_41 = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                startPathPoint.field_43 = this.field_33.method_5944(startPathPoint.field_41);
            }
        }
        return startPathPoint;
    }

    private long removeNonStartingSides(long packed) {
        long newPacked = packed & 0xFFFFFFFF00000000L;
        for (class_2350 side : DIRECTIONS) {
            if (!AdvancedWalkNodeProcessor.unpackDirection(side, packed) || !this.isValidStartingSide(side)) continue;
            newPacked = AdvancedWalkNodeProcessor.packDirection(side, newPacked);
        }
        return newPacked;
    }

    protected boolean isValidStartingSide(class_2350 side) {
        class_2350 groundSide = this.advancedPathFindingEntity.getGroundSide();
        return side == groundSide || side.method_10166() != groundSide.method_10166();
    }

    protected class_2338 findSuitableStartingPosition(class_2338 pos, DirectionalPathPoint startPathPoint) {
        if (startPathPoint.getPathableSides().length == 0) {
            class_2350 avoidedOffset = this.advancedPathFindingEntity.getGroundSide().method_10153();
            for (int xo = -1; xo <= 1; ++xo) {
                for (int yo = -1; yo <= 1; ++yo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        class_2338 offsetPos;
                        long packed;
                        class_7 nodeType;
                        if (xo == avoidedOffset.method_10148() || yo == avoidedOffset.method_10164() || zo == avoidedOffset.method_10165() || (nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed = this.getDirectionalPathNodeTypeCached(this.field_33, (offsetPos = pos.method_10069(xo, yo, zo)).method_10263(), offsetPos.method_10264(), offsetPos.method_10260()))) != class_7.field_12 || !AdvancedWalkNodeProcessor.unpackDirection(packed)) continue;
                        return offsetPos;
                    }
                }
            }
        }
        return pos;
    }

    private boolean isSafeStartingPosition(class_2338 pos) {
        class_7 pathnodetype = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.field_33, pos.method_10263(), pos.method_10264(), pos.method_10260()));
        return this.field_33.method_5944(pathnodetype) >= 0.0f;
    }

    private boolean allowDiagonalPathOptions(class_9[] options) {
        return this.alwaysAllowDiagonals || options == null || options.length == 0 || (options[0] == null || options[0].field_41 == class_7.field_7 || options[0].field_43 != 0.0f) && (options.length <= 1 || options[1] == null || options[1].field_41 == class_7.field_7 || options[1].field_43 != 0.0f);
    }

    public int method_18(class_9[] pathOptions, class_9 currentPointIn) {
        int k;
        int k2;
        boolean foundDiagonal;
        boolean is3DPathing;
        int k3;
        DirectionalPathPoint currentPoint = currentPointIn instanceof DirectionalPathPoint ? (DirectionalPathPoint)currentPointIn : new DirectionalPathPoint(currentPointIn);
        int openedNodeCount = 0;
        int stepHeight = 0;
        class_7 nodeTypeAbove = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.field_33, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38));
        if (this.field_33.method_5944(nodeTypeAbove) >= 0.0f) {
            stepHeight = class_3532.method_15375((float)Math.max(1.0f, this.field_33.field_6013));
        }
        double height = (double)currentPoint.field_39 - AdvancedWalkNodeProcessor.method_60((class_1922)this.field_20622, (class_2338)new class_2338(currentPoint.field_40, currentPoint.field_39, currentPoint.field_38));
        class_9[] pathsPZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, stepHeight, height, PZ, this.checkObstructions);
        class_9[] pathsNX = this.getSafePoints(currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, stepHeight, height, NX, this.checkObstructions);
        class_9[] pathsPX = this.getSafePoints(currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, stepHeight, height, PX, this.checkObstructions);
        class_9[] pathsNZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, stepHeight, height, NZ, this.checkObstructions);
        for (k3 = 0; k3 < pathsPZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsPZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k3];
        }
        for (k3 = 0; k3 < pathsNX.length; ++k3) {
            if (!this.isSuitablePoint(pathsNX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k3];
        }
        for (k3 = 0; k3 < pathsPX.length; ++k3) {
            if (!this.isSuitablePoint(pathsPX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k3];
        }
        for (k3 = 0; k3 < pathsNZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsNZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k3];
        }
        class_9[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            pathsNY = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, stepHeight, height, NY, this.checkObstructions);
            for (int k4 = 0; k4 < pathsNY.length; ++k4) {
                if (!this.isSuitablePoint(pathsNY[k4], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsNY[k4];
            }
        }
        class_9[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            pathsPY = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, stepHeight, height, PY, this.checkObstructions);
            for (int k5 = 0; k5 < pathsPY.length; ++k5) {
                if (!this.isSuitablePoint(pathsPY[k5], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsPY[k5];
            }
        }
        boolean allowDiagonalNZ = this.allowDiagonalPathOptions(pathsNZ);
        boolean allowDiagonalPZ = this.allowDiagonalPathOptions(pathsPZ);
        boolean allowDiagonalPX = this.allowDiagonalPathOptions(pathsPX);
        boolean allowDiagonalNX = this.allowDiagonalPathOptions(pathsNX);
        boolean fitsThroughPoles = this.field_33.method_17681() < 0.5f;
        boolean bl = is3DPathing = this.pathableFacings.size() >= 3;
        if (allowDiagonalNZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.field_40 - this.field_31, currentPoint.field_39, currentPoint.field_38 - 1, stepHeight, height, NXNZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_31 == 1 && this.field_28 == 1)) {
                pathsNXNZ = this.getSafePoints(currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38 - this.field_28, stepHeight, height, NXNZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                }
            }
        }
        if (allowDiagonalNZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38 - 1, stepHeight, height, PXNZ, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsPXNZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38 + 1, stepHeight, height, NXPZ, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsNXPZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.field_40 + this.field_31, currentPoint.field_39, currentPoint.field_38 + 1, stepHeight, height, PXPZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_31 == 1 && this.field_28 == 1)) {
                pathsPXPZ = this.getSafePoints(currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38 + this.field_28, stepHeight, height, PXPZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                }
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k6;
            int k7;
            boolean foundDiagonal2;
            boolean allowDiagonalPY = this.allowDiagonalPathOptions(pathsPY);
            boolean allowDiagonalNY = this.allowDiagonalPathOptions(pathsNY);
            if (allowDiagonalNY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsNYNX = this.getSafePoints(currentPoint.field_40 - this.field_31, currentPoint.field_39 - 1, currentPoint.field_38, stepHeight, height, NXNY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNX, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_31 == 1 && this.field_30 == 1)) {
                    pathsNYNX = this.getSafePoints(currentPoint.field_40 - 1, currentPoint.field_39 - this.field_30, currentPoint.field_38, stepHeight, height, NXNY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNX, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsNYPX = this.getSafePoints(currentPoint.field_40 + 1, currentPoint.field_39 - 1, currentPoint.field_38, stepHeight, height, PXNY, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, pathsNYPX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k6];
                }
            }
            if (allowDiagonalNY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 - this.field_30, currentPoint.field_38 - 1, stepHeight, height, NYNZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_30 == 1 && this.field_28 == 1)) {
                    pathsNYNZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38 - this.field_28, stepHeight, height, NYNZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38 + 1, stepHeight, height, NYPZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_40, currentPoint.field_39 - 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsNYPZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsPYNX = this.getSafePoints(currentPoint.field_40 - 1, currentPoint.field_39 + 1, currentPoint.field_38, stepHeight, height, NXPY, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40 - 1, currentPoint.field_39, currentPoint.field_38, pathsPYNX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsPYPX = this.getSafePoints(currentPoint.field_40 + this.field_31, currentPoint.field_39 + 1, currentPoint.field_38, stepHeight, height, PXPY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_31 == 1 && this.field_30 == 1)) {
                    pathsPYPX = this.getSafePoints(currentPoint.field_40 + 1, currentPoint.field_39 + this.field_30, currentPoint.field_38, stepHeight, height, PXPY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPX, currentPoint.field_40 + 1, currentPoint.field_39, currentPoint.field_38, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    }
                }
            }
            if (allowDiagonalPY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38 - 1, stepHeight, height, PYNZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsNZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 - 1, pathsPYNZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 + this.field_30, currentPoint.field_38 + 1, stepHeight, height, PYPZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_30 == 1 && this.field_28 == 1)) {
                    pathsPYPZ = this.getSafePoints(currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38 + this.field_28, stepHeight, height, PYPZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_40, currentPoint.field_39 + 1, currentPoint.field_38, (DirectionalPathPoint[])pathsPZ, currentPoint.field_40, currentPoint.field_39, currentPoint.field_38 + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    }
                }
            }
        }
        return openedNodeCount;
    }

    protected boolean isTraversible(DirectionalPathPoint from, DirectionalPathPoint to) {
        if (this.method_22() && (from.field_41 == class_7.field_18 || from.field_41 == class_7.field_4 || from.field_41 == class_7.field_14 || to.field_41 == class_7.field_18 || to.field_41 == class_7.field_4 || to.field_41 == class_7.field_14)) {
            return true;
        }
        boolean dx = to.field_40 - from.field_40 != 0;
        boolean dy = to.field_39 - from.field_39 != 0;
        boolean dz = to.field_38 - from.field_38 != 0;
        boolean isDiagonal = (dx ? 1 : 0) + (dy ? 1 : 0) + (dz ? 1 : 0) > 1;
        class_2350[] fromDirections = from.getPathableSides();
        class_2350[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            class_2350 d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                class_2350 d2 = toDirections[j];
                if (d1 == d2) {
                    return true;
                }
                if (!isDiagonal) continue;
                class_2350.class_2351 a1 = d1.method_10166();
                class_2350.class_2351 a2 = d2.method_10166();
                if (a1 == class_2350.class_2351.field_11048 && a2 == class_2350.class_2351.field_11052 || a1 == class_2350.class_2351.field_11052 && a2 == class_2350.class_2351.field_11048) {
                    return !dz;
                }
                if (a1 == class_2350.class_2351.field_11048 && a2 == class_2350.class_2351.field_11051 || a1 == class_2350.class_2351.field_11051 && a2 == class_2350.class_2351.field_11048) {
                    return !dy;
                }
                if ((a1 != class_2350.class_2351.field_11051 || a2 != class_2350.class_2351.field_11052) && (a1 != class_2350.class_2351.field_11052 || a2 != class_2350.class_2351.field_11051)) continue;
                return !dx;
            }
        }
        return false;
    }

    protected static boolean isSharingDirection(DirectionalPathPoint from, DirectionalPathPoint to) {
        class_2350[] fromDirections = from.getPathableSides();
        class_2350[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            class_2350 d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                class_2350 d2 = toDirections[j];
                if (d1 != d2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint newPoint, DirectionalPathPoint currentPoint, boolean allowObstructions) {
        return newPoint != null && !newPoint.field_42 && (allowObstructions || newPoint.field_43 >= 0.0f || currentPoint.field_43 < 0.0f) && this.isTraversible(currentPoint, newPoint);
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint[] newPoints1, int np1x, int np1y, int np1z, @Nullable DirectionalPathPoint[] newPoints2, int np2x, int np2y, int np2z, @Nullable DirectionalPathPoint newPointDiagonal, DirectionalPathPoint currentPoint, boolean allowObstructions, boolean fitsThroughPoles, boolean is3DPathing) {
        if (!is3DPathing) {
            if (!(newPointDiagonal == null || newPointDiagonal.field_42 || newPoints2 == null || newPoints2.length <= 0 || newPoints2[0] == null && (newPoints2.length <= 1 || newPoints2[1] == null) || newPoints1 == null || newPoints1.length <= 0 || newPoints1[0] == null && (newPoints1.length <= 1 || newPoints1[1] == null) || newPoints1[0] != null && newPoints1[0].field_41 == class_7.field_26446 || newPoints2[0] != null && newPoints2[0].field_41 == class_7.field_26446 || newPointDiagonal.field_41 == class_7.field_26446)) {
                boolean canPassPoleDiagonally = newPoints2[0] != null && newPoints2[0].field_41 == class_7.field_10 && newPoints1[0] != null && newPoints1[0].field_41 == class_7.field_10 && fitsThroughPoles;
                return (allowObstructions || newPointDiagonal.field_43 >= 0.0f) && (canPassPoleDiagonally || (newPoints2[0] != null && (allowObstructions || newPoints2[0].field_43 >= 0.0f) || newPoints2.length > 1 && newPoints2[1] != null && (allowObstructions || newPoints2[1].field_43 >= 0.0f)) && (newPoints1[0] != null && (allowObstructions || newPoints1[0].field_43 >= 0.0f) || newPoints1.length > 1 && newPoints1[1] != null && (allowObstructions || newPoints1[1].field_43 >= 0.0f)));
            }
        } else if (newPointDiagonal != null && !newPointDiagonal.field_42 && this.isTraversible(currentPoint, newPointDiagonal)) {
            long packed2 = this.getDirectionalPathNodeTypeCached(this.field_33, np2x, np2y, np2z);
            class_7 pathNodeType2 = AdvancedWalkNodeProcessor.unpackNodeType(packed2);
            boolean open2 = pathNodeType2 == class_7.field_7 || pathNodeType2 == class_7.field_12;
            long packed1 = this.getDirectionalPathNodeTypeCached(this.field_33, np1x, np1y, np1z);
            class_7 pathNodeType1 = AdvancedWalkNodeProcessor.unpackNodeType(packed1);
            boolean open1 = pathNodeType1 == class_7.field_7 || pathNodeType1 == class_7.field_12;
            return open1 != open2 || open1 && open2 && AdvancedWalkNodeProcessor.isSharingDirection(newPointDiagonal, currentPoint);
        }
        return false;
    }

    protected DirectionalPathPoint openPoint(int x, int y, int z, long packed, boolean isDrop) {
        int hash = class_9.method_30((int)x, (int)y, (int)z);
        class_9 point = (class_9)this.field_32.computeIfAbsent(hash, key -> new DirectionalPathPoint(x, y, z, packed, isDrop));
        if (!(point instanceof DirectionalPathPoint)) {
            point = new DirectionalPathPoint(point);
            this.field_32.put(hash, (Object)point);
        }
        return (DirectionalPathPoint)point;
    }

    @Nullable
    private DirectionalPathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, class_2382 direction, boolean allowBlocked) {
        long initialPacked;
        DirectionalPathPoint directPathPoint = null;
        class_2338 pos = new class_2338(x, y, z);
        double blockHeight = (double)y - AdvancedWalkNodeProcessor.method_60((class_1922)this.field_20622, (class_2338)new class_2338(x, y, z));
        if (blockHeight - height > 1.125) {
            return new DirectionalPathPoint[0];
        }
        long packed = initialPacked = this.getDirectionalPathNodeTypeCached(this.field_33, x, y, z);
        class_7 nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        float malus = this.advancedPathFindingEntity.getPathingMalus((class_1922)this.field_20622, this.field_33, nodeType, pos, direction, dir -> AdvancedWalkNodeProcessor.unpackDirection(dir, initialPacked));
        double halfWidth = (double)this.field_33.method_17681() / 2.0;
        DirectionalPathPoint[] result = new DirectionalPathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != class_7.field_22)) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.field_41 = nodeType;
            directPathPoint.field_43 = Math.max(directPathPoint.field_43, malus);
            if (directPathPoint.field_41 == class_7.field_22) {
                result = new DirectionalPathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == class_7.field_12) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != class_7.field_10 && nodeType != class_7.field_25418 && nodeType != class_7.field_19 && direction.method_10264() == 0 && Math.abs(direction.method_10263()) + Math.abs(direction.method_10264()) + Math.abs(direction.method_10260()) == 1) {
            double offsetZ;
            double offsetX;
            class_238 enclosingAabb;
            DirectionalPathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, direction, false);
            DirectionalPathPoint directionalPathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.field_41 == class_7.field_7 || directPathPoint.field_41 == class_7.field_12) && this.field_33.method_17681() < 1.0f && this.checkAabbCollision(enclosingAabb = new class_238((offsetX = (double)(x - direction.method_10263()) + 0.5) - halfWidth, AdvancedWalkNodeProcessor.method_60((class_1922)this.field_20622, (class_2338)new class_2338(offsetX, (double)(y + 1), offsetZ = (double)(z - direction.method_10264()) + 0.5)) + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)this.field_33.method_17682() + AdvancedWalkNodeProcessor.method_60((class_1922)this.field_20622, (class_2338)new class_2338(directPathPoint.field_40, directPathPoint.field_39, directPathPoint.field_38)) - 0.002, offsetZ + halfWidth))) {
                directPathPoint = null;
            }
        }
        if (nodeType == class_7.field_7) {
            float bridingMalus;
            directPathPoint = null;
            class_238 checkAabb = new class_238((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_33.method_17682()), (double)z + halfWidth + 0.5);
            if (this.checkAabbCollision(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.field_33.method_17681() >= 1.0f) {
                for (int i = 0; i < this.pathableFacingsArray.length; ++i) {
                    class_2350 pathableFacing = this.pathableFacingsArray[i];
                    long packedAtFacing = this.getDirectionalPathNodeTypeCached(this.field_33, x + pathableFacing.method_10148() * this.pathingSizeOffsetX, y + (pathableFacing == class_2350.field_11033 ? -1 : (pathableFacing == class_2350.field_11036 ? this.pathingSizeOffsetY : 0)), z + pathableFacing.method_10165() * this.pathingSizeOffsetZ);
                    class_7 nodeTypeAtFacing = AdvancedWalkNodeProcessor.unpackNodeType(packedAtFacing);
                    if (nodeTypeAtFacing != class_7.field_22) continue;
                    directPathPoint = this.openPoint(x, y, z, packedAtFacing, false);
                    directPathPoint.field_41 = class_7.field_12;
                    directPathPoint.field_43 = Math.max(directPathPoint.field_43, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            DirectionalPathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > this.field_20622.method_31607() && nodeType == class_7.field_7) {
                if (fallDistance++ >= Math.max(1, this.field_33.method_5850()) || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                packed = this.getDirectionalPathNodeTypeCached(this.field_33, x, y, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.field_33.method_5944(nodeType);
                if ((this.field_33.method_5850() > 0 && nodeType != class_7.field_7 || nodeType == class_7.field_18 || nodeType == class_7.field_14) && malus >= 0.0f) {
                    fallPathPoint = this.openPoint(x, y, z, packed, true);
                    fallPathPoint.field_41 = nodeType;
                    fallPathPoint.field_43 = Math.max(fallPathPoint.field_43, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                packed = this.getDirectionalPathNodeTypeCached(this.field_33, x, preFallY, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.field_33.method_5944(nodeType);
                if (nodeType != class_7.field_7 && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new DirectionalPathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.openPoint(x, preFallY, z, packed, false);
                    directPathPoint.field_41 = nodeType;
                    directPathPoint.field_43 = Math.max(directPathPoint.field_43, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new DirectionalPathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = this.advancedPathFindingEntity.getBridgePathingMalus(this.field_33, new class_2338(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new DirectionalPathPoint[2];
                result[0] = directPathPoint;
                DirectionalPathPoint bridgePathPoint = this.openPoint(x, preFallY, z, packed, false);
                bridgePathPoint.field_41 = class_7.field_12;
                bridgePathPoint.field_43 = Math.max(bridgePathPoint.field_43, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        if (nodeType == class_7.field_10) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.field_42 = true;
            directPathPoint.field_41 = nodeType;
            directPathPoint.field_43 = nodeType.method_11();
        }
        result[0] = directPathPoint;
        return result;
    }

    protected long getDirectionalPathNodeTypeCached(class_1308 entitylivingIn, int x, int y, int z) {
        return this.pathNodeTypeCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), key -> this.getDirectionalPathNodeType((class_1922)this.field_20622, x, y, z, entitylivingIn, this.field_31, this.field_30, this.field_28, this.method_24(), this.method_23()));
    }

    static long packDirection(class_2350 facing, long packed) {
        return packed | 1L << facing.ordinal();
    }

    static long packDirection(long packed1, long packed2) {
        return packed1 & 0xFFFFFFFF00000000L | packed1 & 0xFFFFFFFFL | packed2 & 0xFFFFFFFFL;
    }

    static boolean unpackDirection(class_2350 facing, long packed) {
        return (packed & 1L << facing.ordinal()) != 0L;
    }

    static boolean unpackDirection(long packed) {
        return (packed & 0xFFFFFFFFL) != 0L;
    }

    static long packNodeType(class_7 type, long packed) {
        return (long)type.ordinal() << 32 | packed & 0xFFFFFFFFL;
    }

    static class_7 unpackNodeType(long packed) {
        return PATH_NODE_TYPES[(int)(packed >> 32)];
    }

    public class_7 method_25(class_1922 blockaccessIn, int x, int y, int z, class_1308 entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z, entity, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn));
    }

    protected long getDirectionalPathNodeType(class_1922 blockaccessIn, int x, int y, int z, class_1308 entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        class_2338 pos = new class_2338(entity.method_19538());
        EnumSet<class_7> applicablePathNodeTypes = EnumSet.noneOf(class_7.class);
        long centerPacked = this.getDirectionalPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, class_7.field_22, pos);
        class_7 centerPathNodeType = AdvancedWalkNodeProcessor.unpackNodeType(centerPacked);
        if (applicablePathNodeTypes.contains(class_7.field_10)) {
            return AdvancedWalkNodeProcessor.packNodeType(class_7.field_10, centerPacked);
        }
        if (applicablePathNodeTypes.contains(class_7.field_25418)) {
            return AdvancedWalkNodeProcessor.packNodeType(class_7.field_25418, centerPacked);
        }
        class_7 selectedPathNodeType = class_7.field_22;
        for (class_7 applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.method_5944(applicablePathNodeType) < 0.0f) {
                return AdvancedWalkNodeProcessor.packNodeType(applicablePathNodeType, centerPacked);
            }
            float p1 = entity.method_5944(applicablePathNodeType);
            if (!(p1 > (p2 = entity.method_5944(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == class_7.field_12 && applicablePathNodeType == class_7.field_7) && (p1 != p2 || selectedPathNodeType != class_7.field_7 || applicablePathNodeType != class_7.field_12)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == class_7.field_7 && entity.method_5944(selectedPathNodeType) == 0.0f) {
            return AdvancedWalkNodeProcessor.packNodeType(class_7.field_7, 0L);
        }
        return AdvancedWalkNodeProcessor.packNodeType(selectedPathNodeType, centerPacked);
    }

    protected long getDirectionalPathNodeType(class_1922 blockaccessIn, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<class_7> nodeTypeEnum, class_7 nodeType, class_2338 pos) {
        long packed = 0L;
        for (int ox = 0; ox < xSize; ++ox) {
            for (int oy = 0; oy < ySize; ++oy) {
                for (int oz = 0; oz < zSize; ++oz) {
                    int bx = ox + x;
                    int by = oy + y;
                    int bz = oz + z;
                    long packedAdjusted = this.getDirectionalPathNodeType(blockaccessIn, bx, by, bz);
                    class_7 adjustedNodeType = AdvancedWalkNodeProcessor.unpackNodeType(packedAdjusted);
                    adjustedNodeType = this.method_61(blockaccessIn, canOpenDoorsIn, canEnterDoorsIn, pos, adjustedNodeType);
                    if (ox == 0 && oy == 0 && oz == 0) {
                        packed = AdvancedWalkNodeProcessor.packNodeType(adjustedNodeType, packedAdjusted);
                    }
                    nodeTypeEnum.add(adjustedNodeType);
                }
            }
        }
        return packed;
    }

    public class_7 method_17(class_1922 blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z));
    }

    protected long getDirectionalPathNodeType(class_1922 blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.getDirectionalPathNodeType(this.rawPathNodeTypeCache, blockaccessIn, x, y, z, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacingsArray);
    }

    protected static class_7 getRawPathNodeTypeCached(Long2ObjectMap<class_7> cache, class_1922 blockaccessIn, class_2338.class_2339 pos) {
        return (class_7)cache.computeIfAbsent(class_2338.method_10064((int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260()), key -> AdvancedWalkNodeProcessor.method_58((class_1922)blockaccessIn, (class_2338)pos));
    }

    protected static long getDirectionalPathNodeType(Long2ObjectMap<class_7> rawPathNodeTypeCache, class_1922 blockaccessIn, int x, int y, int z, int pathingSizeOffsetX, int pathingSizeOffsetY, int pathingSizeOffsetZ, class_2350[] pathableFacings) {
        long packed = 0L;
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_7 nodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos.method_10103(x, y, z));
        boolean isWalkable = false;
        if (nodeType == class_7.field_7 && y >= blockaccessIn.method_31607() + 1) {
            for (int i = 0; i < pathableFacings.length; ++i) {
                class_2350 pathableFacing = pathableFacings[i];
                int checkHeight = pathableFacing.method_10166() != class_2350.class_2351.field_11052 ? Math.min(4, pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.method_10148() * pathingSizeOffsetX;
                int cy = y + (pathableFacing == class_2350.field_11033 ? -1 : (pathableFacing == class_2350.field_11036 ? pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.method_10165() * pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.method_10103(cx, cy + yo, cz);
                    class_7 offsetNodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos);
                    class_7 class_72 = nodeType = offsetNodeType != class_7.field_12 && offsetNodeType != class_7.field_7 && offsetNodeType != class_7.field_18 && offsetNodeType != class_7.field_14 ? class_7.field_12 : class_7.field_7;
                    if (offsetNodeType == class_7.field_3) {
                        nodeType = class_7.field_3;
                    }
                    if (offsetNodeType == class_7.field_11) {
                        nodeType = class_7.field_11;
                    }
                    if (offsetNodeType == class_7.field_17) {
                        nodeType = class_7.field_17;
                    }
                    if (offsetNodeType == class_7.field_21326) {
                        nodeType = class_7.field_21326;
                    }
                    if (nodeType != class_7.field_12) continue;
                    if (AdvancedWalkNodeProcessor.isColliderNodeType(offsetNodeType)) {
                        packed = AdvancedWalkNodeProcessor.packDirection(pathableFacing, packed);
                    }
                    isWalkable = true;
                }
            }
        }
        if (isWalkable) {
            nodeType = AdvancedWalkNodeProcessor.method_59((class_1922)blockaccessIn, (class_2338.class_2339)pos.method_10103(x, y, z), (class_7)class_7.field_12);
        }
        return AdvancedWalkNodeProcessor.packNodeType(nodeType, packed);
    }

    protected static boolean isColliderNodeType(class_7 type) {
        return type == class_7.field_22 || type == class_7.field_19 || type == class_7.field_10 || type == class_7.field_23 || type == class_7.field_8 || type == class_7.field_6 || type == class_7.field_21326 || type == class_7.field_21516;
    }
}

