/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;

public class BetterLeapAtTargetGoal<T extends Mob>
extends Goal {
    private final T leaper;
    private final float leapMotionY;
    private LivingEntity leapTarget;
    private Vec3 forwardJumpDirection;
    private Vec3 upwardJumpDirection;

    public BetterLeapAtTargetGoal(T leapingEntity, float leapMotionYIn) {
        this.leaper = leapingEntity;
        this.leapMotionY = leapMotionYIn;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.leaper.m_20160_()) {
            this.leapTarget = this.leaper.m_5448_();
            if (this.leapTarget != null && this.leaper.m_20096_()) {
                Triple<Vec3, Vec3, Vec3> projectedVector = this.getProjectedVector(this.leapTarget.m_20182_());
                double dstSq = ((Vec3)projectedVector.getLeft()).m_82556_();
                double dstSqDot = ((Vec3)projectedVector.getMiddle()).m_82556_();
                if (dstSq >= 4.0 && dstSq <= 16.0 && dstSqDot <= (double)1.2f && this.leaper.m_21187_().nextInt(5) == 0) {
                    this.forwardJumpDirection = ((Vec3)projectedVector.getLeft()).m_82541_();
                    this.upwardJumpDirection = ((Vec3)projectedVector.getRight()).m_82541_();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.leaper.m_20096_();
    }

    public void m_8056_() {
        Vec3 motion = this.leaper.m_20184_();
        Vec3 jumpVector = this.forwardJumpDirection;
        if (jumpVector.m_82556_() > 1.0E-7) {
            jumpVector = jumpVector.m_82541_().m_82490_(0.4).m_82549_(motion.m_82490_(0.2));
        }
        jumpVector = jumpVector.m_82549_(this.upwardJumpDirection.m_82490_((double)this.leapMotionY));
        jumpVector = new Vec3(jumpVector.f_82479_ * (1.0 - Math.abs(this.upwardJumpDirection.f_82479_)), jumpVector.f_82480_, jumpVector.f_82481_ * (1.0 - Math.abs(this.upwardJumpDirection.f_82481_)));
        this.leaper.m_20256_(jumpVector);
        Orientation orientation = ((IClimberEntity)this.leaper).getOrientation();
        float rx = (float)orientation.localZ.m_82526_(jumpVector);
        float ry = (float)orientation.localX.m_82526_(jumpVector);
        ((Mob)this.leaper).f_19857_ = 270.0f - (float)Math.toDegrees(Mth.m_14136_((double)rx, (double)ry));
    }

    protected Triple<Vec3, Vec3, Vec3> getProjectedVector(Vec3 target) {
        Orientation orientation = ((IClimberEntity)this.leaper).getOrientation();
        Vec3 up = orientation.getGlobal(((Mob)this.leaper).f_19857_, -90.0f);
        Vec3 diff = target.m_82546_(this.leaper.m_20182_());
        Vec3 dot = up.m_82490_(up.m_82526_(diff));
        return Triple.of((Object)diff.m_82546_(dot), (Object)dot, (Object)up);
    }
}

