/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.movement.AdvancedGroundPathNavigator;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;
import tcb.spiderstpo.common.entity.movement.ClimberMoveController;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;

public class AdvancedClimberPathNavigator<T extends Mob>
extends AdvancedGroundPathNavigator<T> {
    protected final IClimberEntity climber;
    protected Direction verticalFacing = Direction.DOWN;
    protected boolean findDirectPathPoints = false;

    public AdvancedClimberPathNavigator(T entity, Level worldIn, boolean checkObstructions, boolean canPathWalls, boolean canPathCeiling) {
        super(entity, worldIn, checkObstructions);
        this.climber = (IClimberEntity)entity;
        if (this.f_26508_ instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.f_26508_;
            processor.setStartPathOnGround(false);
            processor.setCanPathWalls(canPathWalls);
            processor.setCanPathCeiling(canPathCeiling);
        }
    }

    protected Vec3 m_7475_() {
        return this.f_26494_.m_20182_().m_82520_(0.0, (double)(this.f_26494_.m_20206_() / 2.0f), 0.0);
    }

    @Nullable
    public Path m_7864_(BlockPos pos, int checkpointRange) {
        return this.m_26551_((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, checkpointRange);
    }

    @Nullable
    public Path m_6570_(Entity entityIn, int checkpointRange) {
        return this.m_26551_((Set<BlockPos>)ImmutableSet.of((Object)entityIn.m_142538_()), 16, true, checkpointRange);
    }

    public void m_7638_() {
        ++this.f_26498_;
        if (this.f_26506_) {
            this.m_26569_();
        }
        if (!this.m_26571_()) {
            if (this.m_7632_()) {
                this.m_7636_();
            } else if (this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                Vec3 pos = this.m_7475_();
                Vec3 targetPos = this.f_26496_.m_77380_((Entity)this.f_26494_);
                if (pos.f_82480_ > targetPos.f_82480_ && !this.f_26494_.m_20096_() && Mth.m_14107_((double)pos.f_82479_) == Mth.m_14107_((double)targetPos.f_82479_) && Mth.m_14107_((double)pos.f_82481_) == Mth.m_14107_((double)targetPos.f_82481_)) {
                    this.f_26496_.m_77374_();
                }
            }
            DebugPackets.m_133703_((Level)this.f_26495_, (Mob)this.f_26494_, (Path)this.f_26496_, (float)this.f_26505_);
            if (!this.m_26571_()) {
                Node targetPoint = this.f_26496_.m_77375_(this.f_26496_.m_77399_());
                Direction dir = null;
                if (targetPoint instanceof DirectionalPathPoint) {
                    dir = ((DirectionalPathPoint)targetPoint).getPathSide();
                }
                if (dir == null) {
                    dir = Direction.DOWN;
                }
                Vec3 targetPos = this.getExactPathingTarget((BlockGetter)this.f_26495_, targetPoint.m_77288_(), dir);
                MoveControl moveController = this.f_26494_.m_21566_();
                if (moveController instanceof ClimberMoveController && targetPoint instanceof DirectionalPathPoint && ((DirectionalPathPoint)targetPoint).getPathSide() != null) {
                    ((ClimberMoveController)moveController).setMoveTo(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, targetPoint.m_77288_().m_142300_(dir), ((DirectionalPathPoint)targetPoint).getPathSide(), this.f_26497_);
                } else {
                    moveController.m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.f_26497_);
                }
            }
        }
    }

    public Vec3 getExactPathingTarget(BlockGetter blockaccess, BlockPos pos, Direction dir) {
        BlockPos offsetPos = pos.m_142300_(dir);
        VoxelShape shape = blockaccess.m_8055_(offsetPos).m_60812_(blockaccess, offsetPos);
        Direction.Axis axis = dir.m_122434_();
        int sign = dir.m_122429_() + dir.m_122430_() + dir.m_122431_();
        double offset = shape.m_83281_() ? (double)sign : (sign > 0 ? shape.m_83288_(axis) - 1.0 : shape.m_83297_(axis));
        double marginXZ = 1.0f - this.f_26494_.m_20205_() % 1.0f;
        double marginY = 1.0f - this.f_26494_.m_20206_() % 1.0f;
        double pathingOffsetXZ = (double)((int)(this.f_26494_.m_20205_() + 1.0f)) * 0.5;
        double pathingOffsetY = (double)((int)(this.f_26494_.m_20206_() + 1.0f)) * 0.5 - (double)(this.f_26494_.m_20206_() * 0.5f);
        double x = (double)offsetPos.m_123341_() + pathingOffsetXZ + (double)dir.m_122429_() * marginXZ;
        double y = (double)offsetPos.m_123342_() + pathingOffsetY + (dir == Direction.DOWN ? -pathingOffsetY : 0.0) + (dir == Direction.UP ? -pathingOffsetY + marginY : 0.0);
        double z = (double)offsetPos.m_123343_() + pathingOffsetXZ + (double)dir.m_122431_() * marginXZ;
        switch (axis) {
            default: {
                return new Vec3(x + offset, y, z);
            }
            case Y: {
                return new Vec3(x, y + offset, z);
            }
            case Z: 
        }
        return new Vec3(x, y, z + offset);
    }

    protected void m_7636_() {
        Vec3 pos = this.m_7475_();
        this.f_26505_ = this.f_26494_.m_20205_() > 0.75f ? this.f_26494_.m_20205_() / 2.0f : 0.75f - this.f_26494_.m_20205_() / 2.0f;
        float maxDistanceToWaypointY = Math.max(1.0f, this.f_26494_.m_20206_() > 0.75f ? this.f_26494_.m_20206_() / 2.0f : 0.75f - this.f_26494_.m_20206_() / 2.0f);
        int sizeX = Mth.m_14167_((float)this.f_26494_.m_20205_());
        int sizeY = Mth.m_14167_((float)this.f_26494_.m_20206_());
        int sizeZ = sizeX;
        Orientation orientation = this.climber.getOrientation();
        Vec3 upVector = orientation.getGlobal(this.f_26494_.f_19857_, -90.0f);
        this.verticalFacing = Direction.m_122372_((float)((float)upVector.f_82479_), (float)((float)upVector.f_82480_), (float)((float)upVector.f_82481_));
        for (int i = 4; i >= 0; --i) {
            Direction targetSide;
            if (this.f_26496_.m_77399_() + i >= this.f_26496_.m_77398_()) continue;
            Node currentTarget = this.f_26496_.m_77375_(this.f_26496_.m_77399_() + i);
            double dx = Math.abs((double)((float)currentTarget.f_77271_ + (float)((int)(this.f_26494_.m_20205_() + 1.0f)) * 0.5f) - this.f_26494_.m_20185_());
            double dy = Math.abs((double)currentTarget.f_77272_ - this.f_26494_.m_20186_());
            double dz = Math.abs((double)((float)currentTarget.f_77273_ + (float)((int)(this.f_26494_.m_20205_() + 1.0f)) * 0.5f) - this.f_26494_.m_20189_());
            boolean isWaypointInReach = dx < (double)this.f_26505_ && dy < (double)maxDistanceToWaypointY && dz < (double)this.f_26505_;
            boolean isOnSameSideAsTarget = false;
            isOnSameSideAsTarget = this.m_26576_() && (currentTarget.f_77282_ == BlockPathTypes.WATER || currentTarget.f_77282_ == BlockPathTypes.WATER_BORDER || currentTarget.f_77282_ == BlockPathTypes.LAVA) ? true : (currentTarget instanceof DirectionalPathPoint ? (targetSide = ((DirectionalPathPoint)currentTarget).getPathSide()) == null || this.climber.getGroundDirection().getLeft() == targetSide : true);
            if (!isOnSameSideAsTarget || !isWaypointInReach && (i != 0 || !this.f_26494_.m_21481_(this.f_26496_.m_77401_().f_77282_) || !this.isNextTargetInLine(pos, sizeX, sizeY, sizeZ, 1 + i))) continue;
            this.f_26496_.m_77393_(this.f_26496_.m_77399_() + 1 + i);
            break;
        }
        if (this.findDirectPathPoints) {
            Direction.Axis verticalAxis = this.verticalFacing.m_122434_();
            int firstDifferentHeightPoint = this.f_26496_.m_77398_();
            block0 : switch (verticalAxis) {
                case X: {
                    for (int i = this.f_26496_.m_77399_(); i < this.f_26496_.m_77398_(); ++i) {
                        if ((double)this.f_26496_.m_77375_((int)i).f_77271_ == Math.floor(pos.f_82479_)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Y: {
                    for (int i = this.f_26496_.m_77399_(); i < this.f_26496_.m_77398_(); ++i) {
                        if ((double)this.f_26496_.m_77375_((int)i).f_77272_ == Math.floor(pos.f_82480_)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Z: {
                    for (int i = this.f_26496_.m_77399_(); i < this.f_26496_.m_77398_(); ++i) {
                        if ((double)this.f_26496_.m_77375_((int)i).f_77273_ == Math.floor(pos.f_82481_)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
            }
            for (int i = firstDifferentHeightPoint - 1; i >= this.f_26496_.m_77399_(); --i) {
                if (!this.m_183431_(pos, this.f_26496_.m_77382_((Entity)this.f_26494_, i))) continue;
                this.f_26496_.m_77393_(i);
                break;
            }
        }
        this.m_6481_(pos);
    }

    private boolean isNextTargetInLine(Vec3 pos, int sizeX, int sizeY, int sizeZ, int offset) {
        Vec3 currentDir;
        if (this.f_26496_.m_77399_() + offset >= this.f_26496_.m_77398_()) {
            return false;
        }
        Vec3 currentTarget = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
        if (!pos.m_82509_((Position)currentTarget, 2.0)) {
            return false;
        }
        Vec3 nextTarget = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + offset));
        Vec3 targetDir = nextTarget.m_82546_(currentTarget);
        if (targetDir.m_82526_(currentDir = pos.m_82546_(currentTarget)) > 0.0) {
            Direction.Axis az;
            Direction.Axis ay;
            Direction.Axis ax;
            return this.isSafeToStandAt(Mth.m_14107_((double)nextTarget.f_82479_), Mth.m_14107_((double)nextTarget.f_82480_), Mth.m_14107_((double)nextTarget.f_82481_), sizeX, sizeY, sizeZ, currentTarget, 0.0, 0.0, -1.0, ax, ay, az, switch (this.verticalFacing.m_122434_()) {
                case Direction.Axis.X -> {
                    ax = Direction.Axis.Z;
                    ay = Direction.Axis.X;
                    az = Direction.Axis.Y;
                    yield this.verticalFacing.m_122429_() < 0;
                }
                default -> {
                    ax = Direction.Axis.X;
                    ay = Direction.Axis.Y;
                    az = Direction.Axis.Z;
                    yield this.verticalFacing.m_122430_() < 0;
                }
                case Direction.Axis.Z -> {
                    ax = Direction.Axis.Y;
                    ay = Direction.Axis.Z;
                    az = Direction.Axis.X;
                    yield this.verticalFacing.m_122431_() < 0;
                }
            });
        }
        return false;
    }

    protected boolean m_183431_(Vec3 start, Vec3 end) {
        int sizeX = 0;
        int sizeY = 0;
        int sizeZ = 0;
        switch (this.verticalFacing.m_122434_()) {
            case X: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Z, Direction.Axis.X, Direction.Axis.Y, 0.0, this.verticalFacing.m_122429_() < 0);
            }
            case Y: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z, 0.0, this.verticalFacing.m_122430_() < 0);
            }
            case Z: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Y, Direction.Axis.Z, Direction.Axis.X, 0.0, this.verticalFacing.m_122431_() < 0);
            }
        }
        return false;
    }

    protected static double swizzle(Vec3 vec, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return vec.f_82479_;
            }
            case Y: {
                return vec.f_82480_;
            }
            case Z: {
                return vec.f_82481_;
            }
        }
        return 0.0;
    }

    protected static int swizzle(int x, int y, int z, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0;
    }

    protected static int unswizzle(int x, int y, int z, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, Direction.Axis axis) {
        Direction.Axis unswizzle = axis == ax ? Direction.Axis.X : (axis == ay ? Direction.Axis.Y : Direction.Axis.Z);
        return AdvancedClimberPathNavigator.swizzle(x, y, z, unswizzle);
    }

    protected boolean isDirectPathBetweenPoints(Vec3 start, Vec3 end, int sizeX, int sizeY, int sizeZ, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, double minDotProduct, boolean invertY) {
        int bx = Mth.m_14107_((double)AdvancedClimberPathNavigator.swizzle(start, ax));
        int bz = Mth.m_14107_((double)AdvancedClimberPathNavigator.swizzle(start, az));
        double dx = AdvancedClimberPathNavigator.swizzle(end, ax) - AdvancedClimberPathNavigator.swizzle(start, ax);
        double dz = AdvancedClimberPathNavigator.swizzle(end, az) - AdvancedClimberPathNavigator.swizzle(start, az);
        double dSq = dx * dx + dz * dz;
        int by = (int)AdvancedClimberPathNavigator.swizzle(start, ay);
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeY2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ay);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        if (dSq < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(dSq);
        if (!this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2 += 2, sizeY2, sizeZ2 += 2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx *= d3, dz *= d3, minDotProduct, ax, ay, az, invertY)) {
            return false;
        }
        sizeX2 -= 2;
        sizeZ2 -= 2;
        double stepX = 1.0 / Math.abs(dx);
        double stepZ = 1.0 / Math.abs(dz);
        double relX = (double)bx - AdvancedClimberPathNavigator.swizzle(start, ax);
        double relZ = (double)bz - AdvancedClimberPathNavigator.swizzle(start, az);
        if (dx >= 0.0) {
            relX += 1.0;
        }
        if (dz >= 0.0) {
            relZ += 1.0;
        }
        relX /= dx;
        relZ /= dz;
        int dirX = dx < 0.0 ? -1 : 1;
        int dirZ = dz < 0.0 ? -1 : 1;
        int ex = Mth.m_14107_((double)AdvancedClimberPathNavigator.swizzle(end, ax));
        int ez = Mth.m_14107_((double)AdvancedClimberPathNavigator.swizzle(end, az));
        int offsetX = ex - bx;
        int offsetZ = ez - bz;
        while (offsetX * dirX > 0 || offsetZ * dirZ > 0) {
            if (relX < relZ) {
                relX += stepX;
                offsetX = ex - (bx += dirX);
            } else {
                relZ += stepZ;
                offsetZ = ez - (bz += dirZ);
            }
            if (this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx, dz, minDotProduct, ax, ay, az, invertY)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, boolean invertY) {
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        int bx = AdvancedClimberPathNavigator.swizzle(x, y, z, ax) - sizeX2 / 2;
        int bz = AdvancedClimberPathNavigator.swizzle(x, y, z, az) - sizeZ2 / 2;
        int by = AdvancedClimberPathNavigator.swizzle(x, y, z, ay);
        if (!this.isPositionClear(AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Z), sizeX, sizeY, sizeZ, start, dx, dz, minDotProduct, ax, ay, az)) {
            return false;
        }
        for (int obx = bx; obx < bx + sizeX2; ++obx) {
            for (int obz = bz; obz < bz + sizeZ2; ++obz) {
                double offsetZ;
                double offsetX = (double)obx + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
                if (!(offsetX * dx + (offsetZ = (double)obz + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct)) continue;
                BlockPathTypes nodeTypeBelow = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Z), this.f_26494_, sizeX, sizeY, sizeZ, true, true);
                if (nodeTypeBelow == BlockPathTypes.WATER) {
                    return false;
                }
                if (nodeTypeBelow == BlockPathTypes.LAVA) {
                    return false;
                }
                if (nodeTypeBelow == BlockPathTypes.OPEN) {
                    return false;
                }
                BlockPathTypes nodeType = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Z), this.f_26494_, sizeX, sizeY, sizeZ, true, true);
                float f = this.f_26494_.m_21439_(nodeType);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (nodeType != BlockPathTypes.DAMAGE_FIRE && nodeType != BlockPathTypes.DANGER_FIRE && nodeType != BlockPathTypes.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3 start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            BlockState state;
            double pffsetZ;
            double offsetX = (double)AdvancedClimberPathNavigator.swizzle(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ax) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
            if (!(offsetX * dx + (pffsetZ = (double)AdvancedClimberPathNavigator.swizzle(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), az) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct) || (state = this.f_26495_.m_8055_(pos)).m_60647_((BlockGetter)this.f_26495_, pos, PathComputationType.LAND)) continue;
            return false;
        }
        return true;
    }
}

