/*
 * Decompiled with CFR 0.152.
 */
package com.snapblocks.client.screen;

import com.snapblocks.SnapBlocks;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ScreenshotGalleryScreen
extends class_437 {
    private static final int PADDING = 10;
    private static final int THUMBNAIL_WIDTH = 140;
    private static final int THUMBNAIL_HEIGHT = 80;
    private static final int SPACING = 3;
    private static final int VERTICAL_SPACING = 3;
    private static final int SIDEBAR_WIDTH = 150;
    private static final class_2561 TITLE = class_2561.method_43470((String)"Screenshot Gallery");
    private static final class_2960 EDIT_ICON = class_2960.method_60655((String)"snapblocks", (String)"editicon.png");
    private static final class_2960 LOGO = class_2960.method_60655((String)"snapblocks", (String)"logo.png");
    private final List<ScreenshotEntry> screenshots = new ArrayList<ScreenshotEntry>();
    private Path screenshotsDir;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int selectedIndex = -1;
    private class_4185 openButton;
    private class_4185 editButton;
    private class_4185 deleteButton;
    private class_4185 fileLocationButton;
    private class_4185 backButton;
    private boolean viewingImage = false;
    private int viewingImageIndex = -1;
    private boolean editingImage = false;
    private int editingImageIndex = -1;
    private ResettableSlider brightnessContrastSlider;
    private ResettableSlider hueSlider;
    private ResettableSlider saturationSlider;
    private ResettableSlider lightnessSlider;
    private class_4185 resetButton;
    private class_4185 saveButton;
    private class_4185 backFromEditButton;
    private double brightnessContrast = 0.5;
    private double hue = 0.0;
    private double saturation = 0.5;
    private double lightness = 0.5;
    private class_2960 previewTextureId = null;
    private double lastPreviewBC = 0.5;
    private double lastPreviewHue = 0.0;
    private double lastPreviewSat = 0.5;
    private double lastPreviewLight = 0.5;
    private long lastChangeTime = 0L;
    private boolean previewUpdatePending = false;
    private static final long PREVIEW_DELAY_MS = 100L;
    private long lastClickTime = 0L;
    private int lastClickedIndex = -1;
    private static final long DOUBLE_CLICK_DELAY_MS = 300L;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_PADDING = 2;
    private boolean draggingScrollbar = false;
    private int scrollbarDragStartY = 0;
    private int scrollOffsetAtDragStart = 0;

    private int calculateColumns() {
        int sidebarX = this.field_22789 - 150;
        int availableWidth = sidebarX - 20 - 6 - 2;
        int columnWidth = 143;
        int cols = Math.max(1, availableWidth / columnWidth);
        return cols;
    }

    public ScreenshotGalleryScreen() {
        super(TITLE);
        this.loadScreenshotList();
    }

    protected void method_25426() {
        int buttonWidth = 120;
        int buttonHeight = 20;
        int sidebarX = this.field_22789 - 150;
        int buttonX = sidebarX + (150 - buttonWidth) / 2;
        int spacing = 5;
        int startY = 45;
        this.openButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open"), button -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.screenshots.size()) {
                this.openFullscreen(this.selectedIndex);
            }
        }).method_46434(buttonX, startY, buttonWidth, buttonHeight).method_46431());
        this.openButton.field_22763 = false;
        this.editButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit"), button -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.screenshots.size()) {
                this.startEditingImage(this.selectedIndex);
            }
        }).method_46434(buttonX, startY + buttonHeight + spacing, buttonWidth, buttonHeight).method_46431());
        this.editButton.field_22763 = false;
        this.deleteButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), button -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.screenshots.size()) {
                this.deleteScreenshot(this.selectedIndex);
            }
        }).method_46434(buttonX, startY + (buttonHeight + spacing) * 2, buttonWidth, buttonHeight).method_46431());
        this.deleteButton.field_22763 = false;
        this.backButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> {
            this.viewingImage = false;
            this.viewingImageIndex = -1;
            this.updateButtonVisibility();
        }).method_46434(0, 0, 80, 22).method_46431());
        this.backButton.field_22764 = false;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete All"), button -> this.showDeleteAllConfirmation()).method_46434(buttonX, this.field_22790 - buttonHeight * 3 - spacing * 2 - 10, buttonWidth, buttonHeight).method_46431());
        this.fileLocationButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"File Location"), button -> this.openFileLocation()).method_46434(buttonX, this.field_22790 - buttonHeight * 2 - spacing - 10, buttonWidth, buttonHeight).method_46431());
        int buttonY = this.field_22790 - buttonHeight - 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
        }).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431());
        int editStartY = 50;
        this.brightnessContrastSlider = (ResettableSlider)this.method_37063((class_364)new ResettableSlider(buttonX, editStartY, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Brightness/Contrast"), 0.5){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)String.format("B/C: %.1f", ScreenshotGalleryScreen.this.brightnessContrast * 2.0 - 1.0)));
            }

            protected void method_25344() {
                ScreenshotGalleryScreen.this.brightnessContrast = this.field_22753;
            }
        });
        this.brightnessContrastSlider.field_22764 = false;
        this.hueSlider = (ResettableSlider)this.method_37063((class_364)new ResettableSlider(buttonX, editStartY + (buttonHeight + spacing), buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Hue"), 0.0){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)String.format("Hue: %.0f\u00b0", ScreenshotGalleryScreen.this.hue * 360.0)));
            }

            protected void method_25344() {
                ScreenshotGalleryScreen.this.hue = this.field_22753;
            }
        });
        this.hueSlider.field_22764 = false;
        this.saturationSlider = (ResettableSlider)this.method_37063((class_364)new ResettableSlider(buttonX, editStartY + (buttonHeight + spacing) * 2, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Saturation"), 0.5){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)String.format("Sat: %.1f", ScreenshotGalleryScreen.this.saturation * 2.0)));
            }

            protected void method_25344() {
                ScreenshotGalleryScreen.this.saturation = this.field_22753;
            }
        });
        this.saturationSlider.field_22764 = false;
        this.lightnessSlider = (ResettableSlider)this.method_37063((class_364)new ResettableSlider(buttonX, editStartY + (buttonHeight + spacing) * 3, buttonWidth, buttonHeight, (class_2561)class_2561.method_43470((String)"Lightness"), 0.5){

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)String.format("Light: %.1f", ScreenshotGalleryScreen.this.lightness * 2.0)));
            }

            protected void method_25344() {
                ScreenshotGalleryScreen.this.lightness = this.field_22753;
            }
        });
        this.lightnessSlider.field_22764 = false;
        this.resetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            this.brightnessContrast = 0.5;
            this.hue = 0.0;
            this.saturation = 0.5;
            this.lightness = 0.5;
            this.brightnessContrastSlider.resetValue(0.5);
            this.hueSlider.resetValue(0.0);
            this.saturationSlider.resetValue(0.5);
            this.lightnessSlider.resetValue(0.5);
            if (this.previewTextureId != null) {
                this.field_22787.method_1531().method_4615(this.previewTextureId);
                this.previewTextureId = null;
            }
        }).method_46434(buttonX, editStartY + (buttonHeight + spacing) * 4, buttonWidth, buttonHeight).method_46431());
        this.resetButton.field_22764 = false;
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            this.saveEditedImage();
            if (this.previewTextureId != null) {
                this.field_22787.method_1531().method_4615(this.previewTextureId);
                this.previewTextureId = null;
            }
            this.editingImage = false;
            this.editingImageIndex = -1;
            this.brightnessContrast = 0.5;
            this.hue = 0.0;
            this.saturation = 0.5;
            this.lightness = 0.5;
            this.updateButtonVisibility();
        }).method_46434(buttonX, editStartY + (buttonHeight + spacing) * 5, buttonWidth, buttonHeight).method_46431());
        this.saveButton.field_22764 = false;
        this.backFromEditButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> {
            if (this.previewTextureId != null) {
                this.field_22787.method_1531().method_4615(this.previewTextureId);
                this.previewTextureId = null;
            }
            this.editingImage = false;
            this.editingImageIndex = -1;
            this.brightnessContrast = 0.5;
            this.hue = 0.0;
            this.saturation = 0.5;
            this.lightness = 0.5;
            this.updateButtonVisibility();
        }).method_46434(buttonX, editStartY + (buttonHeight + spacing) * 6, buttonWidth, buttonHeight).method_46431());
        this.backFromEditButton.field_22764 = false;
        this.calculateMaxScroll();
        this.updateButtonVisibility();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int sidebarX = this.field_22789 - 150;
        context.method_25294(0, 0, sidebarX, this.field_22790, -870704614);
        context.method_25294(sidebarX, 0, this.field_22789, this.field_22790, -870704614);
        context.method_25294(sidebarX, 0, sidebarX + 1, this.field_22790, -12303292);
        int logoWidth = 588;
        int logoHeight = 74;
        float logoScale = 130.0f / (float)logoWidth;
        int scaledLogoWidth = (int)((float)logoWidth * logoScale);
        int scaledLogoHeight = (int)((float)logoHeight * logoScale);
        int logoX = sidebarX + (150 - scaledLogoWidth) / 2;
        int logoY = 10;
        context.method_25302(class_10799.field_56883, LOGO, logoX, logoY, 0.0f, 0.0f, scaledLogoWidth, scaledLogoHeight, logoWidth, logoHeight, logoWidth, logoHeight);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, TITLE, this.field_22789 / 2, 10, 0xFFFFFF);
        if (this.screenshots.isEmpty()) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No screenshots found."), this.field_22789 / 2, this.field_22790 / 2, 0xAAAAAA);
            if (this.screenshotsDir != null) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.screenshotsDir.toString()), this.field_22789 / 2, this.field_22790 / 2 + 14, 0x666666);
            }
            return;
        }
        if (this.editingImage && this.editingImageIndex >= 0 && this.editingImageIndex < this.screenshots.size()) {
            this.renderEditingImage(context, this.editingImageIndex, sidebarX);
            int infoY = 280;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)String.format("B/C: %.2f", this.brightnessContrast * 2.0 - 1.0)), sidebarX + 10, infoY, 0xFFFFFF);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)String.format("Hue: %.0f\u00b0", this.hue * 360.0)), sidebarX + 10, infoY + 15, 0xFFFFFF);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)String.format("Sat: %.2f", this.saturation * 2.0)), sidebarX + 10, infoY + 30, 0xFFFFFF);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)String.format("Light: %.2f", this.lightness * 2.0)), sidebarX + 10, infoY + 45, 0xFFFFFF);
            return;
        }
        if (this.viewingImage && this.viewingImageIndex >= 0 && this.viewingImageIndex < this.screenshots.size()) {
            this.renderEnlargedImage(context, this.viewingImageIndex, sidebarX);
            return;
        }
        int cols = this.calculateColumns();
        int startY = 30;
        int x = 10;
        int y = startY - this.scrollOffset;
        int col = 0;
        int index = 0;
        for (ScreenshotEntry entry : this.screenshots) {
            if (y + 80 > startY && y < this.field_22790 - 40 && entry.textureId != null) {
                float scale = Math.min(140.0f / (float)entry.width, 80.0f / (float)entry.height);
                int drawWidth = Math.max(1, Math.round((float)entry.width * scale));
                int drawHeight = Math.max(1, Math.round((float)entry.height * scale));
                int drawX = x + (140 - drawWidth) / 2;
                int drawY = y + (80 - drawHeight) / 2;
                context.method_25302(class_10799.field_56883, entry.textureId, drawX, drawY, 0.0f, 0.0f, drawWidth, drawHeight, entry.width, entry.height, entry.width, entry.height);
                if (index == this.selectedIndex) {
                    context.method_25294(drawX, drawY, drawX + drawWidth, drawY + drawHeight, 0x50FFFFFF);
                } else if (mouseX >= drawX && mouseX < drawX + drawWidth && mouseY >= drawY && mouseY < drawY + drawHeight) {
                    context.method_25294(drawX, drawY, drawX + drawWidth, drawY + drawHeight, 0x30FFFFFF);
                }
                if (entry.path.getFileName().toString().contains("_edited")) {
                    int iconSize = 12;
                    int iconX = drawX + drawWidth - iconSize - 2;
                    int iconY = drawY + 2;
                    context.method_25290(class_10799.field_56883, EDIT_ICON, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                }
            }
            ++index;
            if (++col >= cols) {
                col = 0;
                x = 10;
                y += 83;
                continue;
            }
            x += 143;
        }
        if (this.maxScroll > 0 && !this.viewingImage && !this.editingImage) {
            this.drawScrollbar(context, sidebarX, mouseX, mouseY);
        }
    }

    private void drawScrollbar(class_332 context, int sidebarX, int mouseX, int mouseY) {
        int scrollbarX = sidebarX - 6 - 2;
        int scrollbarStartY = 30;
        int scrollbarEndY = this.field_22790 - 10;
        int scrollbarTrackHeight = scrollbarEndY - scrollbarStartY;
        int contentHeight = this.maxScroll + this.field_22790;
        float visibleRatio = (float)this.field_22790 / (float)contentHeight;
        int thumbHeight = Math.max(20, (int)((float)scrollbarTrackHeight * visibleRatio));
        float scrollRatio = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f;
        int thumbY = scrollbarStartY + (int)((float)(scrollbarTrackHeight - thumbHeight) * scrollRatio);
        context.method_25294(scrollbarX, scrollbarStartY, scrollbarX + 6, scrollbarEndY, Integer.MIN_VALUE);
        boolean isHovered = mouseX >= scrollbarX && mouseX <= scrollbarX + 6 && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
        int thumbColor = this.draggingScrollbar || isHovered ? -5592406 : -7829368;
        context.method_25294(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, thumbColor);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int scrollAmount = (int)(verticalAmount * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset - scrollAmount));
        return true;
    }

    public boolean method_25402(class_11909 click, boolean rightClick) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (super.method_25402(click, rightClick)) {
            return true;
        }
        if (!(rightClick || this.viewingImage || this.editingImage || this.maxScroll <= 0)) {
            int sidebarX = this.field_22789 - 150;
            int scrollbarX = sidebarX - 6 - 2;
            int scrollbarStartY = 30;
            int scrollbarEndY = this.field_22790 - 10;
            int scrollbarTrackHeight = scrollbarEndY - scrollbarStartY;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 6) && mouseY >= (double)scrollbarStartY && mouseY <= (double)scrollbarEndY) {
                float scrollRatio;
                int contentHeight = this.maxScroll + this.field_22790;
                float visibleRatio = (float)this.field_22790 / (float)contentHeight;
                int thumbHeight = Math.max(20, (int)((float)scrollbarTrackHeight * visibleRatio));
                int thumbY = scrollbarStartY + (int)((float)(scrollbarTrackHeight - thumbHeight) * (scrollRatio = this.maxScroll > 0 ? (float)this.scrollOffset / (float)this.maxScroll : 0.0f));
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.scrollbarDragStartY = (int)mouseY;
                    this.scrollOffsetAtDragStart = this.scrollOffset;
                    return true;
                }
                float clickRatio = (float)(mouseY - (double)scrollbarStartY) / (float)scrollbarTrackHeight;
                this.scrollOffset = Math.max(0, Math.min(this.maxScroll, (int)((float)this.maxScroll * clickRatio)));
                return true;
            }
        }
        if (!rightClick) {
            int cols = this.calculateColumns();
            int startY = 30;
            int x = 10;
            int y = startY - this.scrollOffset;
            int col = 0;
            for (int i = 0; i < this.screenshots.size(); ++i) {
                if (y + 80 > startY && y < this.field_22790 - 40 && mouseX >= (double)x && mouseX < (double)(x + 140) && mouseY >= (double)y && mouseY < (double)(y + 80)) {
                    boolean isDoubleClick;
                    long currentTime = System.currentTimeMillis();
                    long timeDiff = currentTime - this.lastClickTime;
                    boolean bl = isDoubleClick = i == this.lastClickedIndex && timeDiff > 0L && timeDiff < 300L;
                    if (isDoubleClick) {
                        this.openFullscreen(i);
                        this.lastClickTime = 0L;
                        this.lastClickedIndex = -1;
                    } else {
                        this.selectedIndex = i;
                        this.updateButtonStates();
                        this.lastClickTime = currentTime;
                        this.lastClickedIndex = i;
                    }
                    return true;
                }
                if (++col >= cols) {
                    col = 0;
                    x = 10;
                    y += 83;
                    continue;
                }
                x += 143;
            }
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double deltaX, double deltaY) {
        if (this.draggingScrollbar && this.maxScroll > 0) {
            double mouseY = click.comp_4799();
            int sidebarX = this.field_22789 - 150;
            int scrollbarStartY = 30;
            int scrollbarEndY = this.field_22790 - 10;
            int scrollbarTrackHeight = scrollbarEndY - scrollbarStartY;
            int dragDelta = (int)mouseY - this.scrollbarDragStartY;
            int contentHeight = this.maxScroll + this.field_22790;
            float visibleRatio = (float)this.field_22790 / (float)contentHeight;
            int thumbHeight = Math.max(20, (int)((float)scrollbarTrackHeight * visibleRatio));
            int availableTrackHeight = scrollbarTrackHeight - thumbHeight;
            if (availableTrackHeight > 0) {
                float dragRatio = (float)dragDelta / (float)availableTrackHeight;
                int newScrollOffset = this.scrollOffsetAtDragStart + (int)((float)this.maxScroll * dragRatio);
                this.scrollOffset = Math.max(0, Math.min(this.maxScroll, newScrollOffset));
            }
            return true;
        }
        return super.method_25403(click, deltaX, deltaY);
    }

    public boolean method_25406(class_11909 click) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(click);
    }

    private void openFullscreen(int index) {
        if (index >= 0 && index < this.screenshots.size()) {
            this.viewingImage = true;
            this.viewingImageIndex = index;
            this.updateButtonVisibility();
        }
    }

    private void startEditingImage(int index) {
        if (index >= 0 && index < this.screenshots.size()) {
            this.editingImage = true;
            this.editingImageIndex = index;
            this.brightnessContrast = 0.5;
            this.hue = 0.0;
            this.saturation = 0.5;
            this.lightness = 0.5;
            this.brightnessContrastSlider.resetValue(0.5);
            this.hueSlider.resetValue(0.0);
            this.saturationSlider.resetValue(0.5);
            this.lightnessSlider.resetValue(0.5);
            if (this.previewTextureId != null) {
                this.field_22787.method_1531().method_4615(this.previewTextureId);
                this.previewTextureId = null;
            }
            this.updateButtonVisibility();
        }
    }

    private void renderEditingImage(class_332 context, int index, int sidebarX) {
        boolean valuesChanged;
        ScreenshotEntry entry = this.screenshots.get(index);
        if (entry.textureId == null) {
            return;
        }
        int availableWidth = sidebarX - 40;
        int availableHeight = this.field_22790 - 100;
        float scale = Math.min((float)availableWidth / (float)entry.width, (float)availableHeight / (float)entry.height);
        int drawWidth = Math.max(1, Math.round((float)entry.width * scale));
        int drawHeight = Math.max(1, Math.round((float)entry.height * scale));
        int drawX = (sidebarX - drawWidth) / 2;
        int drawY = (this.field_22790 - drawHeight) / 2;
        boolean bl = valuesChanged = Math.abs(this.lastPreviewBC - this.brightnessContrast) > 0.01 || Math.abs(this.lastPreviewHue - this.hue) > 0.01 || Math.abs(this.lastPreviewSat - this.saturation) > 0.01 || Math.abs(this.lastPreviewLight - this.lightness) > 0.01;
        if (valuesChanged) {
            if (this.previewTextureId != null) {
                this.field_22787.method_1531().method_4615(this.previewTextureId);
                this.previewTextureId = null;
            }
            try {
                InputStream inputStream = Files.newInputStream(entry.path, new OpenOption[0]);
                class_1011 originalImage = class_1011.method_4309((InputStream)inputStream);
                inputStream.close();
                class_1011 imageToProcess = originalImage;
                if (originalImage.method_4307() > 1280 || originalImage.method_4323() > 720) {
                    float previewScale = Math.min(1280.0f / (float)originalImage.method_4307(), 720.0f / (float)originalImage.method_4323());
                    int newWidth = (int)((float)originalImage.method_4307() * previewScale);
                    int newHeight = (int)((float)originalImage.method_4323() * previewScale);
                    imageToProcess = new class_1011(newWidth, newHeight, false);
                    int[] pixels = originalImage.method_4322();
                    for (int y = 0; y < newHeight; ++y) {
                        for (int x = 0; x < newWidth; ++x) {
                            int srcX = (int)((float)x / previewScale);
                            int srcY = (int)((float)y / previewScale);
                            int srcIndex = srcY * originalImage.method_4307() + srcX;
                            int color = pixels[srcIndex];
                            int a = color >> 24 & 0xFF;
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            int abgr = a << 24 | b << 16 | g << 8 | r;
                            imageToProcess.method_4305(x, y, abgr);
                        }
                    }
                    originalImage.close();
                }
                class_1011 previewImage = this.applyEffectsToImage(imageToProcess);
                imageToProcess.close();
                this.previewTextureId = class_2960.method_60655((String)"snapblocks", (String)("preview_" + System.currentTimeMillis()));
                this.field_22787.method_1531().method_4616(this.previewTextureId, (class_1044)new class_1043(() -> "preview_texture", previewImage));
                this.lastPreviewBC = this.brightnessContrast;
                this.lastPreviewHue = this.hue;
                this.lastPreviewSat = this.saturation;
                this.lastPreviewLight = this.lightness;
            }
            catch (IOException e) {
                SnapBlocks.LOGGER.error("Failed to create preview texture", (Throwable)e);
            }
        }
        class_2960 textureToUse = this.previewTextureId != null ? this.previewTextureId : entry.textureId;
        context.method_25302(class_10799.field_56883, textureToUse, drawX, drawY, 0.0f, 0.0f, drawWidth, drawHeight, entry.width, entry.height, entry.width, entry.height);
    }

    private void renderEnlargedImage(class_332 context, int index, int sidebarX) {
        ScreenshotEntry entry = this.screenshots.get(index);
        if (entry.textureId == null) {
            return;
        }
        int availableWidth = sidebarX - 40;
        int availableHeight = this.field_22790 - 100;
        float scale = Math.min((float)availableWidth / (float)entry.width, (float)availableHeight / (float)entry.height);
        int drawWidth = Math.max(1, Math.round((float)entry.width * scale));
        int drawHeight = Math.max(1, Math.round((float)entry.height * scale));
        int drawX = (sidebarX - drawWidth) / 2;
        int drawY = (this.field_22790 - drawHeight - 40) / 2;
        context.method_25302(class_10799.field_56883, entry.textureId, drawX, drawY, 0.0f, 0.0f, drawWidth, drawHeight, entry.width, entry.height, entry.width, entry.height);
        if (this.backButton != null) {
            int buttonWidth = 80;
            int buttonHeight = 22;
            int buttonX = drawX + drawWidth - buttonWidth - 10;
            int buttonY = drawY + drawHeight + 10;
            this.backButton.method_48229(buttonX, buttonY);
            this.backButton.method_25358(buttonWidth);
        }
    }

    private void openFileLocation() {
        try {
            String command = "explorer.exe \"" + this.screenshotsDir.toString() + "\"";
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            SnapBlocks.LOGGER.error("Failed to open file location", (Throwable)e);
        }
    }

    private void updateButtonStates() {
        boolean hasSelection;
        boolean bl = hasSelection = this.selectedIndex >= 0 && this.selectedIndex < this.screenshots.size();
        if (this.openButton != null) {
            this.openButton.field_22763 = hasSelection;
        }
        if (this.editButton != null) {
            this.editButton.field_22763 = hasSelection;
        }
        if (this.deleteButton != null) {
            this.deleteButton.field_22763 = hasSelection;
        }
    }

    private void updateButtonVisibility() {
        if (this.editingImage) {
            if (this.openButton != null) {
                this.openButton.field_22764 = false;
            }
            if (this.editButton != null) {
                this.editButton.field_22764 = false;
            }
            if (this.deleteButton != null) {
                this.deleteButton.field_22764 = false;
            }
            if (this.backButton != null) {
                this.backButton.field_22764 = false;
            }
            if (this.brightnessContrastSlider != null) {
                this.brightnessContrastSlider.field_22764 = true;
            }
            if (this.hueSlider != null) {
                this.hueSlider.field_22764 = true;
            }
            if (this.saturationSlider != null) {
                this.saturationSlider.field_22764 = true;
            }
            if (this.lightnessSlider != null) {
                this.lightnessSlider.field_22764 = true;
            }
            if (this.resetButton != null) {
                this.resetButton.field_22764 = true;
            }
            if (this.saveButton != null) {
                this.saveButton.field_22764 = true;
            }
            if (this.backFromEditButton != null) {
                this.backFromEditButton.field_22764 = true;
            }
        } else if (this.viewingImage) {
            if (this.openButton != null) {
                this.openButton.field_22764 = false;
            }
            if (this.editButton != null) {
                this.editButton.field_22764 = false;
            }
            if (this.deleteButton != null) {
                this.deleteButton.field_22764 = false;
            }
            if (this.backButton != null) {
                this.backButton.field_22764 = true;
            }
            if (this.brightnessContrastSlider != null) {
                this.brightnessContrastSlider.field_22764 = false;
            }
            if (this.hueSlider != null) {
                this.hueSlider.field_22764 = false;
            }
            if (this.saturationSlider != null) {
                this.saturationSlider.field_22764 = false;
            }
            if (this.lightnessSlider != null) {
                this.lightnessSlider.field_22764 = false;
            }
            if (this.resetButton != null) {
                this.resetButton.field_22764 = false;
            }
            if (this.saveButton != null) {
                this.saveButton.field_22764 = false;
            }
            if (this.backFromEditButton != null) {
                this.backFromEditButton.field_22764 = false;
            }
        } else {
            if (this.openButton != null) {
                this.openButton.field_22764 = true;
            }
            if (this.editButton != null) {
                this.editButton.field_22764 = true;
            }
            if (this.deleteButton != null) {
                this.deleteButton.field_22764 = true;
            }
            if (this.backButton != null) {
                this.backButton.field_22764 = false;
            }
            if (this.brightnessContrastSlider != null) {
                this.brightnessContrastSlider.field_22764 = false;
            }
            if (this.hueSlider != null) {
                this.hueSlider.field_22764 = false;
            }
            if (this.saturationSlider != null) {
                this.saturationSlider.field_22764 = false;
            }
            if (this.lightnessSlider != null) {
                this.lightnessSlider.field_22764 = false;
            }
            if (this.resetButton != null) {
                this.resetButton.field_22764 = false;
            }
            if (this.saveButton != null) {
                this.saveButton.field_22764 = false;
            }
            if (this.backFromEditButton != null) {
                this.backFromEditButton.field_22764 = false;
            }
        }
        this.updateButtonStates();
    }

    private void saveEditedImage() {
        boolean hasChanges;
        if (this.editingImageIndex < 0 || this.editingImageIndex >= this.screenshots.size()) {
            return;
        }
        boolean bl = hasChanges = Math.abs(this.brightnessContrast - 0.5) > 0.001 || Math.abs(this.hue) > 0.001 || Math.abs(this.saturation - 0.5) > 0.001 || Math.abs(this.lightness - 0.5) > 0.001;
        if (!hasChanges) {
            return;
        }
        ScreenshotEntry entry = this.screenshots.get(this.editingImageIndex);
        try {
            Path newPath;
            InputStream inputStream = Files.newInputStream(entry.path, new OpenOption[0]);
            class_1011 image = class_1011.method_4309((InputStream)inputStream);
            inputStream.close();
            class_1011 editedImage = this.applyEffectsToImage(image);
            image.close();
            String originalFileName = entry.path.getFileName().toString();
            String fileNameWithoutExt = originalFileName.substring(0, originalFileName.lastIndexOf(46));
            String extension = originalFileName.substring(originalFileName.lastIndexOf(46));
            int counter = 1;
            do {
                String newFileName = fileNameWithoutExt + "_edited" + (String)(counter > 1 ? "_" + counter : "") + extension;
                newPath = entry.path.getParent().resolve(newFileName);
                ++counter;
            } while (Files.exists(newPath, new LinkOption[0]));
            editedImage.method_4314(newPath);
            Path finalNewPath = newPath;
            ScreenshotEntry newEntry = new ScreenshotEntry(finalNewPath);
            newEntry.width = editedImage.method_4307();
            newEntry.height = editedImage.method_4323();
            newEntry.texture = new class_1043(() -> "snapblocks_thumbnail_" + String.valueOf(finalNewPath.getFileName()), editedImage);
            newEntry.textureId = class_2960.method_60655((String)"snapblocks", (String)("thumbnail/" + Math.abs(finalNewPath.toString().hashCode()) + "_" + System.currentTimeMillis()));
            this.field_22787.method_1531().method_4616(newEntry.textureId, (class_1044)newEntry.texture);
            this.screenshots.add(this.editingImageIndex + 1, newEntry);
            this.selectedIndex = this.editingImageIndex + 1;
            this.calculateMaxScroll();
        }
        catch (IOException e) {
            SnapBlocks.LOGGER.error("Failed to save edited image", (Throwable)e);
        }
    }

    private void deleteScreenshot(int index) {
        if (index >= 0 && index < this.screenshots.size()) {
            ScreenshotEntry entry = this.screenshots.get(index);
            try {
                Files.deleteIfExists(entry.path);
                if (entry.texture != null) {
                    entry.texture.close();
                }
                this.screenshots.remove(index);
                this.selectedIndex = -1;
                this.updateButtonStates();
                this.calculateMaxScroll();
            }
            catch (IOException e) {
                SnapBlocks.LOGGER.error("Failed to delete screenshot", (Throwable)e);
            }
        }
    }

    private void showDeleteAllConfirmation() {
        if (this.field_22787 == null || this.screenshots.isEmpty()) {
            return;
        }
        this.field_22787.method_1507((class_437)new class_410(result -> {
            if (result) {
                ScreenshotGalleryScreen newScreen = new ScreenshotGalleryScreen();
                this.field_22787.method_1507((class_437)newScreen);
                newScreen.deleteAllScreenshots();
            } else {
                this.field_22787.method_1507((class_437)new ScreenshotGalleryScreen());
            }
        }, (class_2561)class_2561.method_43470((String)"Delete All Screenshots"), (class_2561)class_2561.method_43470((String)("Are you sure you want to delete all " + this.screenshots.size() + " screenshots?")), (class_2561)class_2561.method_43470((String)"Yes"), (class_2561)class_2561.method_43470((String)"No")));
    }

    private void deleteAllScreenshots() {
        if (this.screenshots.isEmpty()) {
            return;
        }
        try {
            for (ScreenshotEntry entry : this.screenshots) {
                Files.deleteIfExists(entry.path);
                if (entry.texture == null) continue;
                entry.texture.close();
            }
            this.screenshots.clear();
            this.selectedIndex = -1;
            this.updateButtonStates();
            this.calculateMaxScroll();
            SnapBlocks.LOGGER.info("Deleted all screenshots");
        }
        catch (IOException e) {
            SnapBlocks.LOGGER.error("Failed to delete all screenshots", (Throwable)e);
        }
    }

    public void method_25432() {
        for (ScreenshotEntry entry : this.screenshots) {
            if (entry.texture == null) continue;
            entry.texture.close();
        }
    }

    private void loadScreenshotList() {
        this.screenshots.clear();
        this.screenshotsDir = FabricLoader.getInstance().getGameDir().resolve("screenshots");
        if (!Files.isDirectory(this.screenshotsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(this.screenshotsDir);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> this.isImage(path.getFileName().toString())).sorted(Comparator.comparingLong(this::lastModified).reversed()).forEach(path -> {
                ScreenshotEntry entry = new ScreenshotEntry((Path)path);
                this.loadThumbnail(entry);
                this.screenshots.add(entry);
            });
        }
        catch (IOException exception) {
            SnapBlocks.LOGGER.warn("Failed to list screenshots", (Throwable)exception);
        }
    }

    private void loadThumbnail(ScreenshotEntry entry) {
        try {
            InputStream input = Files.newInputStream(entry.path, new OpenOption[0]);
            class_1011 image = class_1011.method_4309((InputStream)input);
            input.close();
            entry.width = image.method_4307();
            entry.height = image.method_4323();
            SnapBlocks.LOGGER.info("Loaded image: {} ({}x{})", new Object[]{entry.path.getFileName(), entry.width, entry.height});
            entry.texture = new class_1043(() -> "snapblocks_thumbnail_" + String.valueOf(entry.path.getFileName()), image);
            entry.textureId = class_2960.method_60655((String)"snapblocks", (String)("thumbnail/" + Math.abs(entry.path.toString().hashCode())));
            if (this.field_22787 != null) {
                this.field_22787.method_1531().method_4616(entry.textureId, (class_1044)entry.texture);
                SnapBlocks.LOGGER.info("Registered texture: {}", (Object)entry.textureId);
            }
        }
        catch (IOException exception) {
            SnapBlocks.LOGGER.warn("Failed to load thumbnail {}", (Object)entry.path, (Object)exception);
        }
    }

    private void calculateMaxScroll() {
        int cols = this.calculateColumns();
        int rows = (int)Math.ceil((double)this.screenshots.size() / (double)cols);
        int totalHeight = rows * 83 - 3;
        int visibleHeight = this.field_22790 - 30 - 40;
        this.maxScroll = Math.max(0, totalHeight - visibleHeight);
    }

    private boolean isImage(String name) {
        String lower = name.toLowerCase(Locale.ROOT);
        return lower.endsWith(".png") || lower.endsWith(".jpg") || lower.endsWith(".jpeg");
    }

    private class_1011 applyEffectsToImage(class_1011 sourceImage) throws IOException {
        int[] pixels = sourceImage.method_4322();
        class_1011 editedImage = new class_1011(sourceImage.method_4307(), sourceImage.method_4323(), false);
        float bcMultiplier = (float)this.brightnessContrast * 2.0f;
        float hueShift = (float)this.hue * 360.0f;
        float satMultiplier = (float)this.saturation * 2.0f;
        float lightMultiplier = (float)this.lightness * 2.0f;
        boolean hasHSL = Math.abs(this.hue) > 0.001 || Math.abs(this.saturation - 0.5) > 0.001 || Math.abs(this.lightness - 0.5) > 0.001;
        for (int y = 0; y < sourceImage.method_4323(); ++y) {
            for (int x = 0; x < sourceImage.method_4307(); ++x) {
                int index = y * sourceImage.method_4307() + x;
                int color = pixels[index];
                int a = color >> 24 & 0xFF;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                r = Math.min(255, Math.max(0, (int)((float)r * bcMultiplier)));
                g = Math.min(255, Math.max(0, (int)((float)g * bcMultiplier)));
                b = Math.min(255, Math.max(0, (int)((float)b * bcMultiplier)));
                if (hasHSL) {
                    float[] hsl = this.rgbToHsl(r, g, b);
                    hsl[0] = (hsl[0] + hueShift) % 360.0f;
                    if (hsl[0] < 0.0f) {
                        hsl[0] = hsl[0] + 360.0f;
                    }
                    hsl[1] = Math.min(1.0f, Math.max(0.0f, hsl[1] * satMultiplier));
                    hsl[2] = Math.min(1.0f, Math.max(0.0f, hsl[2] * lightMultiplier));
                    int[] rgb = this.hslToRgb(hsl[0], hsl[1], hsl[2]);
                    r = rgb[0];
                    g = rgb[1];
                    b = rgb[2];
                }
                int newColor = a << 24 | b << 16 | g << 8 | r;
                editedImage.method_4305(x, y, newColor);
            }
        }
        return editedImage;
    }

    private float[] rgbToHsl(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float delta = max - min;
        float h = 0.0f;
        float s = 0.0f;
        float l = (max + min) / 2.0f;
        if (delta != 0.0f) {
            float f = s = l > 0.5f ? delta / (2.0f - max - min) : delta / (max + min);
            h = max == rf ? ((gf - bf) / delta + (float)(gf < bf ? 6 : 0)) / 6.0f : (max == gf ? ((bf - rf) / delta + 2.0f) / 6.0f : ((rf - gf) / delta + 4.0f) / 6.0f);
        }
        return new float[]{h * 360.0f, s, l};
    }

    private int[] hslToRgb(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (h >= 0.0f && h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h >= 60.0f && h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h >= 120.0f && h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h >= 180.0f && h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h >= 240.0f && h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else if (h >= 300.0f && h < 360.0f) {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new int[]{Math.min(255, Math.max(0, (int)((r + m) * 255.0f))), Math.min(255, Math.max(0, (int)((g + m) * 255.0f))), Math.min(255, Math.max(0, (int)((b + m) * 255.0f)))};
    }

    private long lastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException exception) {
            return 0L;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static abstract class ResettableSlider
    extends class_357 {
        public ResettableSlider(int x, int y, int width, int height, class_2561 text, double value) {
            super(x, y, width, height, text, value);
        }

        public void resetValue(double newValue) {
            this.field_22753 = newValue;
            this.method_25346();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ScreenshotEntry {
        final Path path;
        class_2960 textureId;
        class_1043 texture;
        int width;
        int height;

        ScreenshotEntry(Path path) {
            this.path = path;
        }
    }
}

