/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class AutoTitleGlobalData
extends SavedData {
    private static final String NAME = "mmorpgtitles_auto_titles";
    private final Map<String, UUID> claimedUniqueRules = new HashMap<String, UUID>();

    public static AutoTitleGlobalData get(ServerLevel level) {
        return (AutoTitleGlobalData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(AutoTitleGlobalData::new, AutoTitleGlobalData::load), NAME);
    }

    public boolean isClaimed(String ruleId) {
        return this.claimedUniqueRules.containsKey(ruleId);
    }

    public UUID getClaimedBy(String ruleId) {
        return this.claimedUniqueRules.get(ruleId);
    }

    public boolean claim(String ruleId, UUID playerId) {
        if (this.claimedUniqueRules.containsKey(ruleId)) {
            return false;
        }
        this.claimedUniqueRules.put(ruleId, playerId);
        this.setDirty();
        return true;
    }

    public void unclaim(String ruleId) {
        if (this.claimedUniqueRules.remove(ruleId) != null) {
            this.setDirty();
        }
    }

    public static AutoTitleGlobalData load(CompoundTag tag, HolderLookup.Provider lookup) {
        AutoTitleGlobalData data = new AutoTitleGlobalData();
        CompoundTag claimed = tag.getCompound("ClaimedUniqueRules");
        for (String key : claimed.getAllKeys()) {
            try {
                data.claimedUniqueRules.put(key, claimed.getUUID(key));
            }
            catch (Exception exception) {}
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        CompoundTag claimed = new CompoundTag();
        for (Map.Entry<String, UUID> entry : this.claimedUniqueRules.entrySet()) {
            claimed.putUUID(entry.getKey(), entry.getValue());
        }
        tag.put("ClaimedUniqueRules", (Tag)claimed);
        return tag;
    }
}

