/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class AutoTitleProgress {
    private static final String ROOT = "mmorpgtitles";
    private static final String KEY_PROGRESS = "AutoTitleProgress";
    private static final String KEY_DONE = "Done";

    private static CompoundTag getRoot(ServerPlayer player) {
        CompoundTag data = player.getPersistentData();
        if (!data.contains(ROOT, 10)) {
            data.put(ROOT, (Tag)new CompoundTag());
        }
        return data.getCompound(ROOT);
    }

    private static CompoundTag getProgressRoot(ServerPlayer player) {
        CompoundTag root = AutoTitleProgress.getRoot(player);
        if (!root.contains(KEY_PROGRESS, 10)) {
            root.put(KEY_PROGRESS, (Tag)new CompoundTag());
        }
        return root.getCompound(KEY_PROGRESS);
    }

    private static CompoundTag getRuleTag(ServerPlayer player, String ruleId) {
        CompoundTag progress = AutoTitleProgress.getProgressRoot(player);
        if (!progress.contains(ruleId, 10)) {
            progress.put(ruleId, (Tag)new CompoundTag());
        }
        return progress.getCompound(ruleId);
    }

    public static int getProgress(ServerPlayer player, String ruleId, int index) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        return rule.getInt("c" + index);
    }

    public static void setProgress(ServerPlayer player, String ruleId, int index, int value) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        rule.putInt("c" + index, value);
    }

    public static boolean isCompleted(ServerPlayer player, String ruleId) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        return rule.getBoolean(KEY_DONE);
    }

    public static void setCompleted(ServerPlayer player, String ruleId) {
        CompoundTag rule = AutoTitleProgress.getRuleTag(player, ruleId);
        rule.putBoolean(KEY_DONE, true);
    }
}

