/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class ChatFormatData
extends SavedData {
    private static final String NAME = "mmorpgtitles_chat_format";
    private String format = "[{title}] <{player}>: {message}";

    public static ChatFormatData get(ServerLevel level) {
        return (ChatFormatData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ChatFormatData::new, ChatFormatData::load), NAME);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        this.setDirty();
    }

    public static ChatFormatData load(CompoundTag tag, HolderLookup.Provider lookup) {
        ChatFormatData data = new ChatFormatData();
        data.format = tag.getString("Format");
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        tag.putString("Format", this.format);
        return tag;
    }
}

