/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class ChatFormatter {
    private ChatFormatter() {
    }

    public static MutableComponent build(String format, ServerPlayer player, Component message) {
        if (format == null) {
            format = "";
        }
        MutableComponent out = Component.literal((String)"");
        String title = TitleData.getDisplayed(player);
        String titleDesc = title == null || title.isBlank() ? "" : TitleData.getDescription(player, title);
        boolean hasTitle = title != null && !title.isBlank();
        StringBuilder literalBuffer = new StringBuilder();
        Runnable flushLiteral = () -> {
            if (literalBuffer.length() > 0) {
                out.append((Component)Component.literal((String)literalBuffer.toString()));
                literalBuffer.setLength(0);
            }
        };
        int i = 0;
        while (i < format.length()) {
            if (format.startsWith("{title}", i)) {
                char c;
                if (hasTitle) {
                    flushLiteral.run();
                    MutableComponent titleComp = Component.literal((String)("\u00a7r" + title.replace('&', '\u00a7'))).withStyle(style -> titleDesc.isBlank() ? style : style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)titleDesc))));
                    out.append((Component)titleComp);
                } else {
                    char last;
                    while (literalBuffer.length() > 0 && literalBuffer.charAt(literalBuffer.length() - 1) == ' ') {
                        literalBuffer.deleteCharAt(literalBuffer.length() - 1);
                    }
                    if (literalBuffer.length() > 0 && ((last = literalBuffer.charAt(literalBuffer.length() - 1)) == '[' || last == '(' || last == '<' || last == '{')) {
                        literalBuffer.deleteCharAt(literalBuffer.length() - 1);
                    }
                }
                i += "{title}".length();
                if (hasTitle) continue;
                while (i < format.length() && format.charAt(i) == ' ') {
                    ++i;
                }
                if (i >= format.length() || (c = format.charAt(i)) != ']' && c != ')' && c != '>' && c != '}') continue;
                ++i;
                while (i < format.length() && format.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            if (format.startsWith("{player}", i)) {
                flushLiteral.run();
                out.append((Component)Component.literal((String)player.getName().getString()));
                i += "{player}".length();
                continue;
            }
            if (format.startsWith("{message}", i)) {
                flushLiteral.run();
                out.append(message);
                i += "{message}".length();
                continue;
            }
            literalBuffer.append(format.charAt(i));
            ++i;
        }
        flushLiteral.run();
        return out;
    }
}

