/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleEvents;
import com.fen.mmorpgtitles.ClientTitleEvents;
import com.fen.mmorpgtitles.ModCommands;
import com.fen.mmorpgtitles.TitleChatHandler;
import com.fen.mmorpgtitles.TitleEvents;
import com.fen.mmorpgtitles.TitleSystem;
import com.fen.mmorpgtitles.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="mmorpgtitles")
public class MmorpgTitlesMod {
    public static final String MOD_ID = "mmorpgtitles";

    public MmorpgTitlesMod(IEventBus modBus) {
        modBus.addListener(this::onRegisterPayloads);
        NeoForge.EVENT_BUS.register((Object)new TitleEvents());
        NeoForge.EVENT_BUS.register((Object)new TitleChatHandler());
        NeoForge.EVENT_BUS.register((Object)new AutoTitleEvents());
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register((Object)new ClientTitleEvents());
        }
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::onServerStarted);
        System.out.println("The mod Fen's MMORPG Titles has been successfully initialized.");
    }

    private void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        NetworkHandler.register(event);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void onServerStarted(ServerStartedEvent event) {
        try {
            for (ServerPlayer sp : event.getServer().getPlayerList().getPlayers()) {
                TitleSystem.restoreDisplayedTitle(sp);
            }
        }
        catch (Exception e) {
            System.err.println("[MMORPGTitles] Failed to restore displayed titles on server start: " + e.getMessage());
        }
    }
}

