/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleCondition;
import com.fen.mmorpgtitles.AutoTitleManager;
import com.fen.mmorpgtitles.AutoTitleRule;
import com.fen.mmorpgtitles.TitleData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class TitleExportImport {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String TITLES_DIR = "mmorpgtitles_data";

    private static Path getTitlesDirectory() {
        Path dir = Paths.get(TITLES_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("[MMORPGTitles] Failed to create titles directory: " + e.getMessage());
            }
        }
        return dir;
    }

    public static boolean exportTitles(ServerPlayer player, String fileName, MinecraftServer server) {
        if (fileName == null || fileName.trim().isEmpty()) {
            return false;
        }
        fileName = TitleExportImport.sanitizeFileName(fileName);
        try {
            List<String> titles = TitleData.getGrantedTitles(player);
            JsonArray titlesArray = new JsonArray();
            for (String title : titles) {
                JsonObject titleObj = new JsonObject();
                titleObj.addProperty("title", title);
                titleObj.addProperty("description", TitleData.getDescription(player, title));
                titlesArray.add((JsonElement)titleObj);
            }
            JsonArray rulesArray = new JsonArray();
            List<AutoTitleRule> rules = AutoTitleManager.getRules(server);
            for (AutoTitleRule rule : rules) {
                if (rule == null) continue;
                JsonObject ruleObj = new JsonObject();
                ruleObj.addProperty("id", rule.id);
                ruleObj.addProperty("title", rule.title);
                ruleObj.addProperty("description", rule.description);
                ruleObj.addProperty("unique", Boolean.valueOf(rule.unique));
                ruleObj.addProperty("mode", rule.mode);
                JsonArray conditionsArray = new JsonArray();
                if (rule.conditions != null) {
                    for (AutoTitleCondition condition : rule.conditions) {
                        if (condition == null) continue;
                        JsonElement conditionJson = GSON.toJsonTree((Object)condition);
                        conditionsArray.add(conditionJson);
                    }
                }
                ruleObj.add("conditions", (JsonElement)conditionsArray);
                rulesArray.add((JsonElement)ruleObj);
            }
            JsonObject root = new JsonObject();
            root.addProperty("version", (Number)2);
            root.addProperty("playerName", player.getName().getString());
            root.addProperty("exportTime", (Number)System.currentTimeMillis());
            root.add("titles", (JsonElement)titlesArray);
            root.add("rules", (JsonElement)rulesArray);
            Path filePath = TitleExportImport.getTitlesDirectory().resolve(fileName + ".json");
            String json = GSON.toJson((JsonElement)root);
            Files.writeString(filePath, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            System.err.println("[MMORPGTitles] Export error: " + e.getMessage());
            return false;
        }
    }

    public static boolean importTitles(ServerPlayer player, String fileName, MinecraftServer server) {
        if (fileName == null || fileName.trim().isEmpty()) {
            return false;
        }
        fileName = TitleExportImport.sanitizeFileName(fileName);
        try {
            int i;
            Path filePath = TitleExportImport.getTitlesDirectory().resolve(fileName + ".json");
            if (!Files.exists(filePath, new LinkOption[0])) {
                return false;
            }
            String json = Files.readString(filePath, StandardCharsets.UTF_8);
            JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (root == null) {
                return false;
            }
            if (root.has("titles")) {
                JsonArray titlesArray = root.getAsJsonArray("titles");
                for (i = 0; i < titlesArray.size(); ++i) {
                    String title;
                    JsonObject titleObj = titlesArray.get(i).getAsJsonObject();
                    if (!titleObj.has("title") || (title = titleObj.get("title").getAsString()) == null || title.isBlank()) continue;
                    String description = titleObj.has("description") ? titleObj.get("description").getAsString() : "";
                    TitleData.grant(player, title, description);
                }
            }
            if (root.has("rules")) {
                JsonArray rulesArray = root.getAsJsonArray("rules");
                for (i = 0; i < rulesArray.size(); ++i) {
                    JsonObject ruleObj = rulesArray.get(i).getAsJsonObject();
                    AutoTitleRule rule = new AutoTitleRule();
                    rule.id = ruleObj.get("id").getAsString();
                    rule.title = ruleObj.get("title").getAsString();
                    rule.description = ruleObj.has("description") ? ruleObj.get("description").getAsString() : "";
                    rule.unique = ruleObj.has("unique") && ruleObj.get("unique").getAsBoolean();
                    rule.mode = ruleObj.has("mode") ? ruleObj.get("mode").getAsString() : "all_of";
                    rule.conditions = new ArrayList<AutoTitleCondition>();
                    if (ruleObj.has("conditions")) {
                        JsonArray conditionsArray = ruleObj.getAsJsonArray("conditions");
                        for (int j = 0; j < conditionsArray.size(); ++j) {
                            try {
                                AutoTitleCondition condition = (AutoTitleCondition)GSON.fromJson(conditionsArray.get(j), AutoTitleCondition.class);
                                if (condition == null) continue;
                                rule.conditions.add(condition);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    rule.normalizeDefaults();
                    AutoTitleManager.addRule(server, rule);
                }
            }
            return true;
        }
        catch (IOException | RuntimeException e) {
            System.err.println("[MMORPGTitles] Import error: " + e.getMessage());
            return false;
        }
    }

    public static String getTitlesDirectoryPath() {
        return TitleExportImport.getTitlesDirectory().toAbsolutePath().toString();
    }

    public static List<String> getAvailableFiles() {
        ArrayList<String> files;
        block8: {
            files = new ArrayList<String>();
            try {
                Path dir = TitleExportImport.getTitlesDirectory();
                if (!Files.exists(dir, new LinkOption[0])) break block8;
                try (Stream<Path> stream = Files.list(dir);){
                    stream.filter(p -> p.toString().endsWith(".json")).forEach(p -> {
                        String name = p.getFileName().toString();
                        files.add(name.substring(0, name.length() - 5));
                    });
                }
            }
            catch (IOException e) {
                System.err.println("[MMORPGTitles] Error listing files: " + e.getMessage());
            }
        }
        return files;
    }

    private static String sanitizeFileName(String name) {
        return name.replaceAll("[<>:\"/\\|?*]", "_").replaceAll("\\s+", "_").replaceAll("_{2,}", "_");
    }
}

