/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles.mixin;

import com.fen.mmorpgtitles.TitleSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererNameTagMixin<T extends Entity> {
    private static final float TITLE_GAP_PIXELS = 1.0f;

    @Shadow
    public abstract Font getFont();

    @Inject(method={"renderNameTag"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.BEFORE)})
    private void mmorpgtitles$renderTitle(T entity, Component content, PoseStack poseStack, MultiBufferSource buffers, int packedLight, float partialTick, CallbackInfo ci) {
        String playerName;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Component title = TitleSystem.getPlayerTitle(player);
        if (title == null || title.getString().isBlank()) {
            return;
        }
        String titleStr = title.getString();
        String contentStr = content.getString();
        if (!contentStr.equals(playerName = player.getDisplayName().getString())) {
            return;
        }
        if (contentStr.contains(titleStr)) {
            return;
        }
        int nameTagYOffset = "deadmau5".equals(contentStr) ? -10 : 0;
        Font font = this.getFont();
        float f = nameTagYOffset;
        Objects.requireNonNull(font);
        float titleYOffset = f - (9.0f + 1.0f);
        if (player.getTeam() != null) {
            Objects.requireNonNull(font);
            titleYOffset -= 9.0f + 1.0f;
        }
        float xOffset = (float)(-font.width((FormattedText)title)) / 2.0f;
        boolean seeThrough = !entity.isDiscrete();
        float backgroundOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
        font.drawInBatch(title, xOffset, titleYOffset, 0x20FFFFFF, false, poseStack.last().pose(), buffers, seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, packedLight);
        if (seeThrough) {
            font.drawInBatch(title, xOffset, titleYOffset, -1, false, poseStack.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, packedLight);
        }
    }
}

