/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.AutoTitleCondition;
import com.fen.mmorpgtitles.AutoTitleGlobalData;
import com.fen.mmorpgtitles.AutoTitleManager;
import com.fen.mmorpgtitles.AutoTitleRule;
import com.fen.mmorpgtitles.ChatFormatData;
import com.fen.mmorpgtitles.TitleConfigData;
import com.fen.mmorpgtitles.TitleData;
import com.fen.mmorpgtitles.TitleExportImport;
import com.fen.mmorpgtitles.TitleSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ModCommands {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SELF_TITLES = (ctx, builder) -> {
        Entity patt1703$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (!(patt1703$temp instanceof ServerPlayer)) {
            return builder.buildFuture();
        }
        ServerPlayer sp = (ServerPlayer)patt1703$temp;
        return SharedSuggestionProvider.m_82970_(TitleData.getGrantedTitles(sp), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TARGET_TITLES = (ctx, builder) -> {
        try {
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            return SharedSuggestionProvider.m_82970_(TitleData.getGrantedTitles(target), (SuggestionsBuilder)builder);
        }
        catch (Exception e) {
            return builder.buildFuture();
        }
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_RULE_IDS = (ctx, builder) -> {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        List<AutoTitleRule> rules = AutoTitleManager.getRules(server);
        ArrayList<String> ids = new ArrayList<String>();
        for (AutoTitleRule rule : rules) {
            if (rule == null || rule.id == null || rule.id.isBlank()) continue;
            ids.add(rule.id);
        }
        return SharedSuggestionProvider.m_82970_(ids, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_DIMENSIONS = (ctx, builder) -> {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        return SharedSuggestionProvider.m_82926_(server.m_129784_().stream().map(key -> key.m_135782_()).toList(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_BIOMES = (ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256952_).m_6566_(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_STRUCTURES = (ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256944_).m_6566_(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTITIES = (ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256939_).m_6566_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtitle").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"grant").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            if (!TitleData.grant(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"), "")) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.grant.already"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.grant.success"), true);
            AutoTitleManager.playTitleSound(target, false);
            return 1;
        })).then(Commands.m_82127_((String)"desc").then(Commands.m_82129_((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String desc;
            String title;
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            if (!TitleData.grant(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"), desc = StringArgumentType.getString((CommandContext)ctx, (String)"description"))) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.grant.already"));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.grant.success.desc"), true);
            AutoTitleManager.playTitleSound(target, false);
            return 1;
        }))))))).then(ModCommands.buildAddRuleCommand(context))).then(ModCommands.buildRulesCommand())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"revoke").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_TARGET_TITLES).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            if (!TitleData.revoke(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"))) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.revoke.fail"));
                return 0;
            }
            String displayed = TitleData.getDisplayed(target);
            if (displayed == null || displayed.isBlank()) {
                TitleSystem.removePlayerTitle((Player)target);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.revoke.success"), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_TARGET_TITLES).executes(ctx -> {
            String title;
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            if (!TitleData.has(target, title = StringArgumentType.getString((CommandContext)ctx, (String)"title"))) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.set.fail"));
                return 0;
            }
            TitleData.setDisplayed(target, title);
            TitleSystem.setPlayerTitle((Player)target, title);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.set.success"), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh").requires(s -> s.m_6761_(2))).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                TitleSystem.restoreDisplayedTitle(sp);
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.refresh.success"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"display").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_SELF_TITLES).executes(ctx -> {
            Entity patt11198$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (!(patt11198$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt11198$temp;
            String title = StringArgumentType.getString((CommandContext)ctx, (String)"title");
            if (!TitleData.has(sp, title)) {
                sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.display.fail"));
                return 0;
            }
            TitleData.setDisplayed(sp, title);
            TitleSystem.setPlayerTitle((Player)sp, title);
            sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.display.success"));
            return 1;
        })))).then(Commands.m_82127_((String)"hide").executes(ctx -> {
            Entity patt12171$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (!(patt12171$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt12171$temp;
            TitleData.setDisplayed(sp, "");
            TitleSystem.removePlayerTitle((Player)sp);
            sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.hide"));
            return 1;
        }))).then(Commands.m_82127_((String)"list").executes(ctx -> {
            Entity patt12697$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (!(patt12697$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt12697$temp;
            List<String> titles = TitleData.getGrantedTitles(sp);
            if (titles.isEmpty()) {
                sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.list.empty"));
            } else {
                sp.m_213846_((Component)Component.m_237110_((String)"command.rtitle.list", (Object[])new Object[]{titles.toString()}));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Entity patt13711$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (!(patt13711$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt13711$temp;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            if (TitleExportImport.exportTitles(sp, name, server)) {
                String dirPath = TitleExportImport.getTitlesDirectoryPath();
                String fileName = name.replaceAll("[<>:\"/\\|?*]", "_").replaceAll("\\s+", "_").replaceAll("_{2,}", "_") + ".json";
                MutableComponent link = Component.m_237113_((String)("\u00a7n\u00a7e" + fileName)).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dirPath)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"command.rtitle.export.hover"))));
                sp.m_213846_((Component)Component.m_237110_((String)"command.rtitle.export.success", (Object[])new Object[]{link}));
                return 1;
            }
            sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.export.fail"));
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"import").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            List<String> files = TitleExportImport.getAvailableFiles();
            return SharedSuggestionProvider.m_82970_(files, (SuggestionsBuilder)builder);
        }).executes(ctx -> {
            Entity patt16205$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (!(patt16205$temp instanceof ServerPlayer)) {
                return 0;
            }
            ServerPlayer sp = (ServerPlayer)patt16205$temp;
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            if (TitleExportImport.importTitles(sp, name, server)) {
                sp.m_213846_((Component)Component.m_237110_((String)"command.rtitle.import.success", (Object[])new Object[]{name}));
                return 1;
            }
            sp.m_213846_((Component)Component.m_237115_((String)"command.rtitle.import.fail"));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chatprefix").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"on").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            TitleConfigData.get(sp.m_284548_()).setChatPrefixEnabled(true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.chatprefix.on"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            TitleConfigData.get(sp.m_284548_()).setChatPrefixEnabled(false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.chatprefix.off"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chatformat").requires(s -> s.m_6761_(2))).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String current = ChatFormatData.get(sp.m_284548_()).getFormat();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.rtitle.chatformat.current", (Object[])new Object[]{current}), false);
            return 1;
        })).then(Commands.m_82129_((String)"format", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer sp = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String format = StringArgumentType.getString((CommandContext)ctx, (String)"format");
            ChatFormatData.get(sp.m_284548_()).setFormat(format);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.chatformat.updated"), true);
            return 1;
        }))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildAddRuleCommand(CommandBuildContext context) {
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(s -> s.m_6761_(2));
        RequiredArgumentBuilder titleArg = Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string());
        RequiredArgumentBuilder descArg = Commands.m_82129_((String)"description", (ArgumentType)StringArgumentType.string());
        ModCommands.addConditionBranches(descArg, context);
        titleArg.then(Commands.m_82127_((String)"desc").then((ArgumentBuilder)descArg));
        ModCommands.addConditionBranches(titleArg, context);
        add.then((ArgumentBuilder)titleArg);
        return add;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildRulesCommand() {
        LiteralArgumentBuilder rules = (LiteralArgumentBuilder)Commands.m_82127_((String)"rules").requires(s -> s.m_6761_(2));
        rules.then(Commands.m_82127_((String)"list").executes(ModCommands::executeListRules));
        rules.then(Commands.m_82127_((String)"reload").executes(ctx -> {
            AutoTitleManager.reload(((CommandSourceStack)ctx.getSource()).m_81377_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.rule.reload"), true);
            return 1;
        }));
        rules.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_RULE_IDS).executes(ModCommands::executeRemoveRule)));
        return rules;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionBranches(ArgumentBuilder<CommandSourceStack, ?> root, CommandBuildContext context) {
        ModCommands.addKillBranch(root, "kill_player", context);
        ModCommands.addKillBranch(root, "kill", context);
        ModCommands.addKillMobBranch(root, context);
        root.then(Commands.m_82127_((String)"break_block").then(Commands.m_82129_((String)"block", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            String blockId = BuiltInRegistries.f_256975_.m_7981_((Object)BlockStateArgument.m_116123_((CommandContext)ctx, (String)"block").m_114669_().m_60734_()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.breakBlock(blockId, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false);
        })).then(Commands.m_82127_((String)"unique").executes(ctx -> {
            String blockId = BuiltInRegistries.f_256975_.m_7981_((Object)BlockStateArgument.m_116123_((CommandContext)ctx, (String)"block").m_114669_().m_60734_()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.breakBlock(blockId, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true);
        })))));
        root.then(Commands.m_82127_((String)"visit_dimension").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_DIMENSIONS).executes(ctx -> ModCommands.executeAddDimensionRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddDimensionRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.m_82127_((String)"visit_biome").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"biome", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_BIOMES).executes(ctx -> ModCommands.executeAddBiomeRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddBiomeRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.m_82127_((String)"visit_structure").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_STRUCTURES).executes(ctx -> ModCommands.executeAddStructureRule((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddStructureRule((CommandContext<CommandSourceStack>)ctx, true)))));
        root.then(Commands.m_82127_((String)"reach_level").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.reachLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")), false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.reachLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")), true)))));
        root.then(Commands.m_82127_((String)"deaths").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.deaths(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.deaths(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true)))));
        root.then(Commands.m_82127_((String)"fish").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.fish(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.fish(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")), true)))));
        return root;
    }

    private static void addKillBranch(ArgumentBuilder<CommandSourceStack, ?> root, String literal, CommandBuildContext context) {
        root.then(Commands.m_82127_((String)literal).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), null), false))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), null), true)))).then(Commands.m_82127_((String)"item").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(ctx -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)ItemArgument.m_120963_((CommandContext)ctx, (String)"item").m_120979_()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), itemId), false);
        })).then(Commands.m_82127_((String)"unique").executes(ctx -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)ItemArgument.m_120963_((CommandContext)ctx, (String)"item").m_120979_()).toString();
            return ModCommands.executeAddRule((CommandContext<CommandSourceStack>)ctx, AutoTitleCondition.killPlayers(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), itemId), true);
        }))))));
    }

    private static void addKillMobBranch(ArgumentBuilder<CommandSourceStack, ?> root, CommandBuildContext context) {
        root.then(Commands.m_82127_((String)"kill_mob").then(Commands.m_82129_((String)"mob", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITIES).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, false, null))).then(Commands.m_82127_((String)"unique").executes(ctx -> ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, true, null)))).then(Commands.m_82127_((String)"item").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).executes(ctx -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)ItemArgument.m_120963_((CommandContext)ctx, (String)"item").m_120979_()).toString();
            return ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, false, itemId);
        })).then(Commands.m_82127_((String)"unique").executes(ctx -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)ItemArgument.m_120963_((CommandContext)ctx, (String)"item").m_120979_()).toString();
            return ModCommands.executeAddMobRule((CommandContext<CommandSourceStack>)ctx, true, itemId);
        })))))));
    }

    private static int executeAddRule(CommandContext<CommandSourceStack> ctx, AutoTitleCondition condition, boolean unique) {
        if (condition == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.rule.add.fail"));
            return 0;
        }
        String title = StringArgumentType.getString(ctx, (String)"title");
        String description = "";
        try {
            description = StringArgumentType.getString(ctx, (String)"description");
        }
        catch (Exception ignored) {
            description = "";
        }
        AutoTitleRule rule = new AutoTitleRule();
        rule.title = title;
        rule.description = description;
        rule.unique = unique;
        rule.mode = "all_of";
        rule.conditions = new ArrayList<AutoTitleCondition>();
        rule.conditions.add(condition);
        String id = AutoTitleManager.addRule(((CommandSourceStack)ctx.getSource()).m_81377_(), rule);
        if (id == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.rule.add.fail"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.rtitle.rule.add.success", (Object[])new Object[]{id}), true);
        return 1;
    }

    private static int executeAddDimensionRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"dimension");
        boolean exists = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129784_().stream().anyMatch(key -> key.m_135782_().equals((Object)id));
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"command.rtitle.rule.invalid_dimension", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitDimension(id.toString()), unique);
    }

    private static int executeAddBiomeRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"biome");
        boolean exists = ((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256952_).m_7804_(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"command.rtitle.rule.invalid_biome", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitBiome(id.toString()), unique);
    }

    private static int executeAddStructureRule(CommandContext<CommandSourceStack> ctx, boolean unique) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"structure");
        boolean exists = ((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256944_).m_7804_(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"command.rtitle.rule.invalid_structure", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.visitStructure(id.toString()), unique);
    }

    private static int executeAddMobRule(CommandContext<CommandSourceStack> ctx, boolean unique, String itemId) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"mob");
        boolean exists = ((CommandSourceStack)ctx.getSource()).m_5894_().m_175515_(Registries.f_256939_).m_7804_(id);
        if (!exists) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"command.rtitle.rule.invalid_entity", (Object[])new Object[]{id.toString()}));
            return 0;
        }
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        return ModCommands.executeAddRule(ctx, AutoTitleCondition.killMob(id.toString(), count, itemId), unique);
    }

    private static int executeRemoveRule(CommandContext<CommandSourceStack> ctx) {
        String id = StringArgumentType.getString(ctx, (String)"id");
        boolean removed = AutoTitleManager.removeRule(((CommandSourceStack)ctx.getSource()).m_81377_(), id);
        if (!removed) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.rtitle.rule.remove.fail"));
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.rule.remove.success"), true);
        return 1;
    }

    private static int executeListRules(CommandContext<CommandSourceStack> ctx) {
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        List<AutoTitleRule> rules = AutoTitleManager.getRules(server);
        if (rules.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.rule.list.empty"), false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.rtitle.rule.list.header"), false);
        AutoTitleGlobalData global = null;
        if (server.m_129880_(Level.f_46428_) != null) {
            global = AutoTitleGlobalData.get(server.m_129880_(Level.f_46428_));
        }
        for (AutoTitleRule rule : rules) {
            if (rule == null) continue;
            boolean claimed = rule.unique && global != null && global.isClaimed(rule.id);
            String line = String.format("[%s] %s (unique=%s, mode=%s, conditions=%d%s)", rule.id, rule.title, rule.unique, rule.mode, rule.conditions == null ? 0 : rule.conditions.size(), claimed ? ", claimed" : "");
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)line), false);
        }
        return 1;
    }
}

