/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles;

import com.fen.mmorpgtitles.TitleSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TitleManager {
    private static final float NAME_TAG_SCALE = 0.025f;
    private static final float TITLE_GAP_PIXELS = 1.0f;
    private static final float SCOREBOARD_OFFSET = 0.25875f;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderName(RenderNameTagEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Component title = TitleSystem.getPlayerTitle(player);
        if (title == null) {
            return;
        }
        if (!TitleManager.shouldRenderWithNameTag(event, player)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource buffers = event.getMultiBufferSource();
        Font font = event.getEntityRenderer().m_114481_();
        poseStack.m_85836_();
        TitleManager.applyScoreboardOffset(player, event.getEntityRenderer(), poseStack);
        TitleManager.renderTitle(event, player, title, poseStack, buffers, font);
        poseStack.m_85849_();
    }

    private static void renderTitle(RenderNameTagEvent event, Player player, Component title, PoseStack poseStack, MultiBufferSource buffers, Font font) {
        TitleManager.applyNameTagTransform(player, poseStack);
        float f = TitleManager.getNameTagYOffset(event.getContent());
        Objects.requireNonNull(font);
        float yOffset = f - (9.0f + 1.0f);
        float xOffset = (float)(-font.m_92852_((FormattedText)title)) / 2.0f;
        boolean seeThrough = !player.m_20163_();
        float backgroundOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int backgroundColor = (int)(backgroundOpacity * 255.0f) << 24;
        int textColor = 0xFFFFFF;
        font.m_272077_(title, xOffset, yOffset, textColor, false, poseStack.m_85850_().m_252922_(), buffers, seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backgroundColor, event.getPackedLight());
        if (seeThrough) {
            font.m_272077_(title, xOffset, yOffset, textColor, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, event.getPackedLight());
        }
    }

    private static void applyScoreboardOffset(Player player, EntityRenderer<?> renderer, PoseStack poseStack) {
        if (!(renderer instanceof PlayerRenderer)) {
            return;
        }
        double distanceSqr = Minecraft.m_91087_().m_91290_().m_114471_((Entity)player);
        if (distanceSqr >= 100.0) {
            return;
        }
        Scoreboard scoreboard = player.m_36329_();
        Objective objective = scoreboard.m_83416_(2);
        if (objective != null) {
            poseStack.m_252880_(0.0f, 0.25875f, 0.0f);
        }
    }

    private static void applyNameTagTransform(Player player, PoseStack poseStack) {
        poseStack.m_252880_(0.0f, player.m_278726_(), 0.0f);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
    }

    private static int getNameTagYOffset(Component nameTag) {
        if (nameTag != null && "deadmau5".equals(nameTag.getString())) {
            return -10;
        }
        return 0;
    }

    private static boolean shouldRenderWithNameTag(RenderNameTagEvent event, Player player) {
        boolean visibleToLocal;
        float maxDistance;
        Event.Result result = event.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        if (result == Event.Result.ALLOW) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer == null) {
            return false;
        }
        double distanceSqr = minecraft.m_91290_().m_114471_((Entity)player);
        if (!ForgeHooksClient.isNameplateInRenderDistance((Entity)player, (double)distanceSqr)) {
            return false;
        }
        float f = maxDistance = player.m_20163_() ? 32.0f : 64.0f;
        if (distanceSqr >= (double)(maxDistance * maxDistance)) {
            return false;
        }
        boolean bl = visibleToLocal = !player.m_20177_((Player)localPlayer);
        if (player != localPlayer) {
            Team team = player.m_5647_();
            Team localTeam = localPlayer.m_5647_();
            if (team != null) {
                Team.Visibility visibility = team.m_7470_();
                switch (visibility) {
                    case ALWAYS: {
                        return visibleToLocal;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return localTeam == null ? visibleToLocal : team.m_83536_(localTeam) && (team.m_6259_() || visibleToLocal);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return localTeam == null ? visibleToLocal : !team.m_83536_(localTeam) && visibleToLocal;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && player != minecraft.m_91288_() && visibleToLocal && !player.m_20160_();
    }
}

