/*
 * Decompiled with CFR 0.152.
 */
package com.fen.mmorpgtitles.network;

import com.fen.mmorpgtitles.TitleSystem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TitlePacket {
    private final UUID playerUUID;
    private final String title;
    private final boolean remove;

    public TitlePacket(UUID playerUUID, String title, boolean remove) {
        this.playerUUID = playerUUID;
        this.title = title;
        this.remove = remove;
    }

    public static void encode(TitlePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.playerUUID);
        buffer.writeBoolean(packet.remove);
        if (!packet.remove) {
            buffer.m_130070_(packet.title);
        }
    }

    public static TitlePacket decode(FriendlyByteBuf buffer) {
        UUID playerUUID = buffer.m_130259_();
        boolean remove = buffer.readBoolean();
        String title = remove ? "" : buffer.m_130277_();
        return new TitlePacket(playerUUID, title, remove);
    }

    public static void handle(TitlePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TitlePacket.handleClient(packet)));
        context.setPacketHandled(true);
    }

    private static void handleClient(TitlePacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91073_ == null) {
            System.out.println("\u041a\u043b\u0438\u0435\u043d\u0442 \u043f\u043e\u043b\u0443\u0447\u0438\u043b \u043f\u0430\u043a\u0435\u0442 \u0441 \u0442\u0438\u0442\u0443\u043b\u043e\u043c, \u043d\u043e Minecraft \u0438\u043b\u0438 \u043c\u0438\u0440 \u0435\u0449\u0451 \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
            return;
        }
        Player direct = minecraft.f_91073_.m_46003_(packet.playerUUID);
        if (direct != null) {
            if (packet.remove) {
                TitleSystem.removePlayerTitle(direct);
            } else {
                TitleSystem.setPlayerTitle(direct, packet.title);
            }
            System.out.println("[MMORPGTitles] Applied title packet for " + direct.m_7755_().getString() + ": " + (packet.remove ? "remove" : packet.title));
            return;
        }
        for (Entity entity : minecraft.f_91073_.m_104735_()) {
            Player player;
            if (!(entity instanceof Player) || !(player = (Player)entity).m_20148_().equals(packet.playerUUID)) continue;
            if (packet.remove) {
                TitleSystem.removePlayerTitle(player);
            } else {
                TitleSystem.setPlayerTitle(player, packet.title);
            }
            System.out.println("\u041a\u043b\u0438\u0435\u043d\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043b \u043f\u0430\u043a\u0435\u0442 \u0441 \u0442\u0438\u0442\u0443\u043b\u043e\u043c \u0434\u043b\u044f " + player.m_7755_().getString() + ": " + (packet.remove ? "\u0443\u0434\u0430\u043b\u0438\u0442\u044c" : packet.title));
            return;
        }
        System.out.println("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u0433\u0440\u043e\u043a \u0441 UUID " + packet.playerUUID + " \u0434\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0442\u0438\u0442\u0443\u043b\u0430");
    }
}

