/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jei;

import com.voxelutopia.ultramarine.data.recipe.CompositeSmeltingRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CompositeSmeltingRecipeCategory
implements IRecipeCategory<CompositeSmeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"composite_smelting");
    public static final RecipeType<CompositeSmeltingRecipe> COMPOSITE_SMELTING_RECIPE_TYPE = new RecipeType(UID, CompositeSmeltingRecipe.class);
    public static final ResourceLocation TEXTURE_GUI = ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"textures/gui/brick_kiln.png");
    private final IDrawable background;
    private final int regularCookTime;
    private final IDrawable icon;
    private final Component localizedName;

    public CompositeSmeltingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE_GUI, 45, 16, 92, 54);
        this.regularCookTime = 200;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.BRICK_KILN.get()));
        this.localizedName = Component.translatable((String)"gui.jei.category.composite_smelting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, CompositeSmeltingRecipe recipe, @NotNull IFocusGroup focuses) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        builder.addAnimatedRecipeArrow(cookTime).setPosition(34, 17);
        builder.addAnimatedRecipeFlame(300).setPosition(11, 20);
        this.addExperience(builder, recipe);
        this.addCookTime(builder, recipe);
    }

    protected void addExperience(IRecipeExtrasBuilder builder, CompositeSmeltingRecipe recipe) {
        float experience = recipe.getExp();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            ((ITextWidget)builder.addText((FormattedText)experienceString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, CompositeSmeltingRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompositeSmeltingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getPrimaryIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 1).addIngredients(recipe.getSecondaryIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 19).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }

    @NotNull
    public RecipeType<CompositeSmeltingRecipe> getRecipeType() {
        return COMPOSITE_SMELTING_RECIPE_TYPE;
    }
}

