/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodworkingRecipe
extends SingleItemRecipe {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final String group;

    public WoodworkingRecipe(String pGroup, Ingredient pIngredient, ItemStack pResult) {
        super((RecipeType)RecipeTypeRegistry.WOODWORKING.get(), (RecipeSerializer)RecipeSerializerRegistry.WOODWORKING_SERIALIZER.get(), pGroup, pIngredient, pResult);
        this.group = pGroup;
        this.ingredient = pIngredient;
        this.result = pResult;
    }

    public boolean matches(SingleRecipeInput pContainer, @NotNull Level pLevel) {
        return this.ingredient.test(pContainer.getItem(0));
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput pContainer, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.WOODWORKING.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializerRegistry.WOODWORKING_SERIALIZER.get();
    }

    public static enum Serializer implements RecipeSerializer<WoodworkingRecipe>
    {
        INSTANCE;

        public static final MapCodec<WoodworkingRecipe> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, WoodworkingRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<WoodworkingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WoodworkingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SingleItemRecipe::getGroup), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(WoodworkingRecipe::getIngredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(WoodworkingRecipe::getResult)).apply((Applicative)i, WoodworkingRecipe::new));
            STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SingleItemRecipe::getGroup, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, WoodworkingRecipe::getIngredient, (StreamCodec)ItemStack.STREAM_CODEC, WoodworkingRecipe::getResult, WoodworkingRecipe::new);
        }
    }
}

