/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.event;

import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.ModBlockTags;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.EntityTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.data.registry.PoiTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.VillagerProfessionRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.SnowRoofRidge;
import com.voxelutopia.ultramarine.world.entity.TravellingMerchant;
import com.voxelutopia.ultramarine.world.saveddata.TravellingMerchantSpawnData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import org.slf4j.Logger;

@EventBusSubscriber
public class CommonEventHandler {
    private static final Logger LOGGER = Ultramarine.getLogger();

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        Player player = event.getEntity();
        if (state.is(ModBlockTags.MINEABLE_WITH_SHEARS) && player.getItemInHand(player.getUsedItemHand()).is(Tags.Items.TOOLS_SHEAR)) {
            event.setNewSpeed(event.getOriginalSpeed() * 4.0f);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public static void itemConversion(ItemExpireEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack item = itemEntity.getItem();
        if (itemEntity.isInWater() && item.is((Item)ItemRegistry.FIRED_BRICK.get())) {
            itemEntity.setItem(new ItemStack((ItemLike)ItemRegistry.CYAN_BRICK.get(), item.getCount()));
            itemEntity.level().playSound(null, (Entity)itemEntity, SoundEvents.LAVA_EXTINGUISH, SoundSource.NEUTRAL, 0.5f, 1.0f);
            event.setExtraLife(6000);
        }
    }

    @SubscribeEvent
    public static void chiselTableMultiblockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState placedBlock = event.getPlacedBlock();
        if (!placedBlock.is((Block)BlockRegistry.BRUSH_AND_INKSTONE.get())) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState blockBelow = event.getLevel().getBlockState(pos.below());
        if (blockBelow.is((Block)BlockRegistry.PORCELAIN_INLAID_TABLE.get())) {
            event.getLevel().setBlock(pos, (BlockState)((Block)BlockRegistry.CHISEL_TABLE.get()).defaultBlockState().setValue((Property)DecorativeBlock.FACING, (Comparable)((Direction)placedBlock.getValue((Property)DecorativeBlock.FACING))), 3);
        }
    }

    @SubscribeEvent
    public static void chiselTableMultiblockBreak(BlockEvent.BreakEvent event) {
        BlockState block = event.getState();
        BlockPos pos = event.getPos();
        if (block.is((Block)BlockRegistry.PORCELAIN_INLAID_TABLE.get()) && event.getLevel().getBlockState(pos.above()).is((Block)BlockRegistry.CHISEL_TABLE.get())) {
            event.getLevel().setBlock(pos.above(), (BlockState)((Block)BlockRegistry.BRUSH_AND_INKSTONE.get()).defaultBlockState().setValue((Property)DecorativeBlock.FACING, (Comparable)((Direction)block.getValue((Property)DecorativeBlock.FACING))), 3);
        }
    }

    @SubscribeEvent
    public static void roofSnowFall(BlockEvent.NeighborNotifyEvent event) {
        BlockState blockBelow;
        Block block;
        if (event.getState().is(Blocks.SNOW) && (block = (blockBelow = event.getLevel().getBlockState(event.getPos().below())).getBlock()) instanceof SnowRoofRidge) {
            SnowRoofRidge ridge = (SnowRoofRidge)block;
            if ((Integer)blockBelow.getValue((Property)SnowRoofRidge.SNOW_LAYERS) < 15) {
                ridge.handleSnow(blockBelow, event.getLevel(), event.getPos().below());
                event.getLevel().setBlock(event.getPos(), Blocks.AIR.defaultBlockState(), 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void travellingMerchantSpawnAttempt(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        if (event.getLevel().dimension() != Level.OVERWORLD || world.getDayTime() % 24000L != 0L) {
            return;
        }
        if (!(world.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING) && world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT))) {
            return;
        }
        TravellingMerchantSpawnData spawnData = (TravellingMerchantSpawnData)world.getDataStorage().computeIfAbsent(new SavedData.Factory(TravellingMerchantSpawnData::create, TravellingMerchantSpawnData::load), "travelling_merchant_spawn_data");
        int spawnRoll = world.random.nextInt(100);
        if (spawnRoll < spawnData.getSpawnChance()) {
            CommonEventHandler.spawnTrader(world);
            spawnData.resetSpawnChance();
        } else {
            spawnData.increaseSpawnChance();
        }
    }

    private static void spawnTrader(ServerLevel world) {
        ServerPlayer player = world.getRandomPlayer();
        if (player == null) {
            return;
        }
        BlockPos blockpos = player.blockPosition();
        world.getPoiManager().find(poi -> poi.is(PoiTypeRegistry.TRADE_POI.getKey()), pos1 -> true, blockpos, 32, PoiManager.Occupancy.ANY).ifPresent(pos -> {
            BlockPos potentialSpawn = null;
            for (int i = 0; i < 10; ++i) {
                int z;
                int y;
                int x = pos.getX() + world.random.nextInt(8) - 4;
                BlockPos rolledPos = new BlockPos(x, y = world.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = pos.getZ() + world.random.nextInt(8) - 4), z);
                if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)world, (BlockPos)rolledPos, (BlockState)world.getBlockState(rolledPos), (FluidState)world.getFluidState(rolledPos), (EntityType)EntityType.WANDERING_TRADER)) continue;
                potentialSpawn = rolledPos;
                break;
            }
            if (potentialSpawn == null) {
                return;
            }
            boolean hasSpaceAtSpawn = true;
            for (BlockPos blockPos : BlockPos.betweenClosed(potentialSpawn, (BlockPos)potentialSpawn.offset(1, 2, 1))) {
                if (world.getBlockState(blockPos).getCollisionShape((BlockGetter)world, blockPos).isEmpty()) continue;
                hasSpaceAtSpawn = false;
                break;
            }
            if (hasSpaceAtSpawn && !world.getBiome(pos).is(Biomes.THE_VOID)) {
                TravellingMerchant merchant = (TravellingMerchant)((EntityType)EntityTypeRegistry.TRAVELLING_MERCHANT.get()).spawn(world, potentialSpawn, MobSpawnType.EVENT);
                if (merchant == null) {
                    return;
                }
                merchant.setDespawnDelay(12000);
                merchant.setWanderTarget(potentialSpawn);
                merchant.restrictTo(potentialSpawn, 8);
            }
        });
    }

    @SubscribeEvent
    public static void villagerTradesHandler(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Int2ObjectMap trades = event.getTrades();
        if (profession == VillagerProfession.MASON) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.RAW_HEMATITE.get(), 2), 12, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.MAGNESITE.get(), 2), 12, 10, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ItemRegistry.JADE.get(), 1), 6, 20, 0.05f));
        }
        if (profession == VillagerProfession.TOOLSMITH) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ItemRegistry.BRONZE_INGOT.get(), 1), 12, 10, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), new ItemStack((ItemLike)ItemRegistry.CARRIAGE.get(), 1), 1, 10, 0.05f));
        }
        if (profession == VillagerProfession.FARMER) {
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get(), 8), 12, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get(), 8), 12, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 30), new ItemStack((ItemLike)ItemRegistry.SILK.get(), 4), 4, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 20), Optional.of(new ItemCost((ItemLike)ItemRegistry.EMPTY_BAMBOO_TEA_BASKET.get(), 1)), new ItemStack((ItemLike)ItemRegistry.BAMBOO_TEA_BASKET.get(), 1), 4, 10, 0.05f));
        }
        if (profession == VillagerProfession.LIBRARIAN) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 20), new ItemStack((ItemLike)ItemRegistry.XUAN_PAPER.get(), 4), 10, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 30), new ItemStack((ItemLike)ItemRegistry.PORCELAIN_TEAPOT.get(), 1), 2, 20, 0.05f));
        }
        if (profession == VillagerProfession.CLERIC) {
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), new ItemStack((ItemLike)ItemRegistry.SUNDIAL.get(), 1), 1, 20, 0.05f));
        }
        if (profession == VillagerProfessionRegistry.COOK.get()) {
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.RAW_MEAT.get(), 10), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.PORKCHOP, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.BEEF, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.CHICKEN, 20), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)ItemRegistry.COOKED_MEAT.get(), 4), 12, 2, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.MUTTON, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 4, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.RABBIT, 15), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 4, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ItemRegistry.GREASE.get(), 2), 8, 5, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ItemRegistry.FUR.get(), 2), 8, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.DRIED_KELP, 40), new ItemStack((ItemLike)Items.EMERALD, 2), 15, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.SUGAR, 40), new ItemStack((ItemLike)Items.EMERALD, 1), 20, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EGG, 16), new ItemStack((ItemLike)Items.EMERALD, 1), 20, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.MUNG_BEAN_CAKE.get(), 4), 12, 10, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.MOONCAKE.get(), 4), 12, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.CABBAGE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.CELERY_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.ORANGE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.APPLE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.EGGPLANT_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.PEAR_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)ItemRegistry.BAOZI.get(), 2), 6, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 25), new ItemStack((ItemLike)ItemRegistry.XIAOLONGBAO.get(), 1), 2, 30, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 30), new ItemStack((ItemLike)ItemRegistry.WINE_POT.get(), 1), 2, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 40), new ItemStack((ItemLike)ItemRegistry.BOTTLE_GOURD.get(), 1), 1, 30, 0.05f));
        }
    }

    @SubscribeEvent
    public static void wanderingTraderHandler(WandererTradesEvent event) {
        List rareTrades = event.getRareTrades();
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ItemRegistry.INCENSE.get(), 1), 6, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)ItemRegistry.SILK.get(), 1), 8, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), new ItemStack((ItemLike)ItemRegistry.JADE.get(), 1), 2, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)ItemRegistry.PAINTING_SCROLL.get(), 1), 1, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 20), new ItemStack((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_VASE.get(), 1), 1, 30, 0.05f));
    }
}

