/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.mojang.serialization.MapCodec;
import com.voxelutopia.ultramarine.world.block.BaseBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseDirectionalBlock
extends DirectionalBlock
implements BaseBlockPropertyHolder {
    private static final MapCodec<BaseDirectionalBlock> CODEC = BaseDirectionalBlock.simpleCodec(BaseDirectionalBlock::new);
    protected final BaseBlockProperty property;

    public BaseDirectionalBlock(BaseBlock block) {
        this(block.getProperty());
    }

    public BaseDirectionalBlock(BaseBlockProperty property) {
        super(property.properties());
        this.property = property;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    private BaseDirectionalBlock(BlockBehaviour.Properties properties) {
        this(new BaseBlockProperty(properties, BaseBlockProperty.BlockMaterial.STONE));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getNearestLookingDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (facing.getAxis().isHorizontal()) {
            newState = (BlockState)newState.setValue((Property)FACING, (Comparable)pRot.rotate(facing));
        }
        return newState;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState newState = pState;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (facing.getAxis().isHorizontal()) {
            newState = newState.rotate(pMirror.getRotation(facing));
        }
        return newState;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }
}

