/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CandleStick
extends DecorativeBlock {
    private final Vec3 flameOffset;

    public CandleStick(DecorativeBlock.Builder builder, Vec3 flameOffset) {
        super(builder);
        this.flameOffset = flameOffset;
    }

    @Override
    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        return this.isLuminous() ? (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)) : state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (stack.is(Items.FLINT_AND_STEEL) && pState.hasProperty((Property)LIT) && !((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            stack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (!pState.hasProperty((Property)LIT) || !((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        if (pLevel.getGameTime() % (long)(2 - pRandom.nextInt(1)) == 0L) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pPos.getX() + this.flameOffset.x, (double)pPos.getY() + this.flameOffset.y, (double)pPos.getZ() + this.flameOffset.z, 0.0, pRandom.nextDouble() * 0.01, 0.0);
        }
    }
}

