/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.AxialBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CentralAxialBlock
extends Block
implements AxialBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected Map<Direction.Axis, VoxelShape> shapeByAxis;
    private final boolean hasCollision;
    private final ShapeFunction shapeFunction;

    public CentralAxialBlock(BaseBlockProperty property, ShapeFunction shapeFunction, boolean hasCollision) {
        super(property.properties());
        BlockState state = (BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue(AXIS, (Comparable)Direction.Axis.X);
        this.registerDefaultState(state);
        this.shapeFunction = shapeFunction;
        this.hasCollision = hasCollision;
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness, int height, boolean hasCollision) {
        this(property, ShapeFunction.axialRotations(new RawVoxelShape(0.0, 0.0, (float)(16 - thickness) / 2.0f, 16.0, height, 16.0f - (float)(16 - thickness) / 2.0f)), hasCollision);
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness) {
        this(property, thickness, 16, false);
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness, int height) {
        this(property, thickness, height, true);
    }

    public CentralAxialBlock(BaseBlockProperty property, ShapeFunction shapeFunction) {
        this(property, shapeFunction, false);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER));
        return (BlockState)state.setValue(AXIS, (Comparable)pContext.getHorizontalDirection().getClockWise().getAxis());
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WATERLOGGED});
        pBuilder.add(new Property[]{AXIS});
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.hasCollision ? this.getShape(pState, pLevel, pPos, pContext) : Shapes.empty();
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        if (pRot == Rotation.CLOCKWISE_90 || pRot == Rotation.COUNTERCLOCKWISE_90) {
            newState = switch ((Direction.Axis)pState.getValue(AXIS)) {
                case Direction.Axis.X -> (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.Z);
                case Direction.Axis.Z -> (BlockState)pState.setValue(AXIS, (Comparable)Direction.Axis.X);
                default -> newState;
            };
        }
        return newState;
    }
}

