/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.mojang.serialization.MapCodec;
import com.voxelutopia.ultramarine.data.shape.BlockShapes;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.DiagonallyPlaceable;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DecorativeBlock
extends HorizontalDirectionalBlock
implements BaseBlockPropertyHolder,
DiagonallyPlaceable {
    private static final MapCodec<DecorativeBlock> CODEC = DecorativeBlock.simpleCodec(DecorativeBlock::new);
    public static final DirectionProperty HORIZONTAL_FACING_SHIFT = ModBlockStateProperties.HORIZONTAL_FACING_SHIFT;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private final BaseBlockProperty property;
    private final ShapeFunction shapeFunction;
    private final boolean diagonallyPlaceable;
    private final boolean directional;
    private final boolean noCollision;
    private final boolean luminous;
    private final boolean noFenceConnect;
    @Nullable
    private final Direction offsetDirection;
    protected StateDefinition<Block, BlockState> stateDefinition;

    public DecorativeBlock(BaseBlockProperty property, ShapeFunction shapeFunction, boolean directional, boolean diagonallyPlaceable, boolean luminous, boolean noCollision, boolean noFenceConnect, @Nullable Direction offset) {
        super(property.properties());
        this.property = property;
        this.shapeFunction = shapeFunction;
        this.directional = directional;
        this.diagonallyPlaceable = diagonallyPlaceable;
        this.luminous = luminous;
        this.noCollision = noCollision;
        this.noFenceConnect = noFenceConnect;
        this.offsetDirection = offset;
        StateDefinition.Builder stateDefinationBuilder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)stateDefinationBuilder);
        this.stateDefinition = stateDefinationBuilder.create(Block::defaultBlockState, BlockState::new);
        BlockState state = (BlockState)this.getStateDefinition().any();
        if (this.isDiagonallyPlaceable()) {
            state = (BlockState)state.setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(false));
        }
        if (this.isDirectional()) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        if (this.isDiagonallyPlaceable() && this.isDirectional()) {
            state = (BlockState)state.setValue((Property)HORIZONTAL_FACING_SHIFT, (Comparable)Direction.NORTH);
        }
        if (this.isLuminous()) {
            state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        this.registerDefaultState(state);
    }

    public DecorativeBlock(Builder builder) {
        this(builder.property, builder.shapeFunction, builder.directional, builder.diagonallyPlaceable, builder.luminous, builder.noCollision, builder.noFenceConnect, builder.offset);
    }

    @ApiStatus.Internal
    protected DecorativeBlock(BlockBehaviour.Properties properties) {
        this(new Builder(new BaseBlockProperty(properties, BaseBlockProperty.BlockMaterial.STONE)));
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stateDefinition;
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = this.setDiagonalStateForPlacement(this.defaultBlockState(), pContext);
        if (this.isDirectional() && this.isDiagonallyPlaceable()) {
            Pair directions = this.getMainAndShiftedDirections(pContext);
            state = (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)directions.getLeft()))).setValue((Property)HORIZONTAL_FACING_SHIFT, (Comparable)((Direction)directions.getRight()))).setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(this.getDiagonalState(pContext)));
        } else if (this.isDirectional() && !this.isDiagonallyPlaceable()) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
        } else if (!this.isDirectional() && this.isDiagonallyPlaceable()) {
            state = (BlockState)state.setValue((Property)DIAGONAL, (Comparable)Boolean.valueOf(this.getDiagonalState(pContext)));
        }
        if (this.isLuminous()) {
            state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        if (this.isDirectional()) {
            pBuilder.add(new Property[]{FACING});
        }
        if (this.isDiagonallyPlaceable()) {
            pBuilder.add(new Property[]{DIAGONAL});
        }
        if (this.isDirectional() && this.isDiagonallyPlaceable()) {
            pBuilder.add(new Property[]{HORIZONTAL_FACING_SHIFT});
        }
        if (this.isLuminous()) {
            pBuilder.add(new Property[]{LIT});
        }
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        DecorativeBlock decorativeBlock;
        BlockState newState = pState;
        Block block = pState.getBlock();
        if (block instanceof DecorativeBlock && (decorativeBlock = (DecorativeBlock)block).isDirectional()) {
            newState = (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
            if (decorativeBlock.isDiagonallyPlaceable()) {
                newState = (BlockState)newState.setValue((Property)HORIZONTAL_FACING_SHIFT, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HORIZONTAL_FACING_SHIFT)));
            }
        }
        return newState;
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        DecorativeBlock decorativeBlock;
        BlockState newState = pState;
        Block block = pState.getBlock();
        if (block instanceof DecorativeBlock && (decorativeBlock = (DecorativeBlock)block).isDirectional()) {
            newState = pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
            if (decorativeBlock.isDiagonallyPlaceable()) {
                newState = newState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)HORIZONTAL_FACING_SHIFT)));
            }
        }
        return newState;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.noCollision ? Shapes.empty() : this.getShape(pState, pLevel, pPos, pContext);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isLuminous()) {
            return (Boolean)state.getValue((Property)LIT) != false ? 14 : 0;
        }
        return 0;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }

    @Override
    public boolean isDiagonallyPlaceable() {
        return this.diagonallyPlaceable;
    }

    public boolean isLuminous() {
        return this.luminous;
    }

    public boolean isDirectional() {
        return this.directional;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return this.noFenceConnect ? BlockShapes.S16_H12.apply(pState) : super.getBlockSupportShape(pState, pReader, pPos);
    }

    public float getShadeBrightness(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        private final BaseBlockProperty property;
        private ShapeFunction shapeFunction = BlockShapes.S16_H16;
        private boolean diagonallyPlaceable;
        private boolean directional;
        private boolean luminous;
        private boolean noCollision;
        private boolean noFenceConnect;
        private Direction offset = null;

        public Builder(BaseBlockProperty property) {
            this.property = property;
        }

        public Builder shaped(VoxelShape shape) {
            return this.shaped(ShapeFunction.simpleShape(shape));
        }

        public Builder shaped(ShapeFunction shapeFunction) {
            this.shapeFunction = shapeFunction;
            return this;
        }

        public Builder diagonallyPlaceable() {
            this.diagonallyPlaceable = true;
            return this;
        }

        public Builder directional() {
            this.directional = true;
            return this;
        }

        public Builder luminous() {
            this.luminous = true;
            return this;
        }

        public Builder noCollision() {
            this.noCollision = true;
            return this;
        }

        public Builder noOcclusion() {
            this.property.properties().noOcclusion();
            return this;
        }

        public Builder noFenceConnect() {
            this.noFenceConnect = true;
            return this;
        }

        public Builder placeOffset(Direction direction) {
            this.offset = direction;
            return this;
        }

        public DecorativeBlock build() {
            return new DecorativeBlock(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        public abstract T self();
    }
}

