/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.WallSideBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Icicle
extends WallSideBlock {
    public static final IntegerProperty VARIANT = ModBlockStateProperties.VARIANT;
    private final int numVariants;
    private final ShapeFunction shapeFunction;

    public Icicle(int numVariants, ShapeFunction shapeFunction) {
        super(BaseBlockProperty.ice());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.numVariants = numVariants;
        this.shapeFunction = shapeFunction;
    }

    public Icicle(int numVariants) {
        this(numVariants, ShapeFunction.cardinalRotations(new RawVoxelShape(0.0, 0.0, 15.0, 16.0, 16.0, 16.0)));
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        int variant = pLevel.random.nextInt(3);
        BlockState newState = (BlockState)pState.setValue((Property)VARIANT, (Comparable)Integer.valueOf(variant));
        pLevel.setBlockAndUpdate(pPos, newState);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    public int getNumVariants() {
        return this.numVariants;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = super.getStateForPlacement(pContext);
        if (state == null) {
            return null;
        }
        return (BlockState)state.setValue((Property)VARIANT, (Comparable)Integer.valueOf(0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{VARIANT});
    }
}

