/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.SideBlock;
import com.voxelutopia.ultramarine.world.block.WallSideBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.OrientableBlockType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrientableWallSideBlock
extends WallSideBlock
implements SideBlock {
    public static final EnumProperty<OrientableBlockType> TYPE = ModBlockStateProperties.ORIENTABLE_BLOCK_TYPE;
    private final ShapeFunction shapeFunction;

    public OrientableWallSideBlock(BaseBlockProperty property) {
        this(property, ShapeFunction.sideOrientedShape(new RawVoxelShape(0.0, 0.0, 15.0, 16.0, 16.0, 16.0)));
    }

    public OrientableWallSideBlock(BaseBlockProperty property, ShapeFunction shapeFunction) {
        super(property);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TYPE, (Comparable)((Object)OrientableBlockType.LEFT))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeFunction = shapeFunction;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState state = this.defaultBlockState();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        Direction faceDir = pContext.getClickedFace();
        Direction[] lookDirs = pContext.getNearestLookingDirections();
        if (faceDir.getAxis().isHorizontal()) {
            state = (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)faceDir)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
            for (Direction dir : lookDirs) {
                if (!dir.getAxis().isHorizontal() || dir == faceDir || dir == faceDir.getOpposite()) continue;
                if (dir == faceDir.getOpposite().getClockWise()) {
                    state = (BlockState)state.setValue(TYPE, (Comparable)((Object)OrientableBlockType.LEFT));
                }
                if (dir != faceDir.getOpposite().getCounterClockWise()) continue;
                state = (BlockState)state.setValue(TYPE, (Comparable)((Object)OrientableBlockType.RIGHT));
            }
            return state;
        }
        return null;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{TYPE});
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState newState = pState;
        if (pMirror != Mirror.NONE) {
            newState = (BlockState)newState.setValue(TYPE, (Comparable)((Object)((OrientableBlockType)((Object)pState.getValue(TYPE))).getOpposite()));
        }
        newState = (BlockState)newState.setValue((Property)FACING, (Comparable)pMirror.rotation().rotate((Direction)pState.getValue((Property)FACING)));
        return newState;
    }
}

