/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.google.common.collect.ImmutableMap;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.BaseHorizontalDirectionalBlock;
import com.voxelutopia.ultramarine.world.block.RailingSlant;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RailingBlock
extends Block
implements BaseBlockPropertyHolder,
SimpleWaterloggedBlock {
    protected final BaseBlockProperty property;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<Direction, VoxelShape> shapeByPart;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty SHIFTED = ModBlockStateProperties.SHIFTED;
    public static final BooleanProperty POLE_LOCKED = ModBlockStateProperties.LOCKED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape MARBLE_POLE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)22.0, (double)10.0);
    private static final VoxelShape MARBLE_NORTH_SIDE = Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape MARBLE_SOUTH_SIDE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)16.0);
    private static final VoxelShape MARBLE_WEST_SIDE = Block.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape MARBLE_EAST_SIDE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0);
    public static final Map<Direction, VoxelShape> MARBLE_SHAPES = Map.of(Direction.UP, MARBLE_POLE, Direction.NORTH, MARBLE_NORTH_SIDE, Direction.SOUTH, MARBLE_SOUTH_SIDE, Direction.WEST, MARBLE_WEST_SIDE, Direction.EAST, MARBLE_EAST_SIDE);
    private static final VoxelShape WOODEN_POLE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    private static final VoxelShape WOODEN_NORTH_SIDE = Block.box((double)7.5, (double)2.5, (double)0.0, (double)8.5, (double)12.0, (double)8.5);
    private static final VoxelShape WOODEN_SOUTH_SIDE = Block.box((double)7.5, (double)2.5, (double)7.5, (double)8.5, (double)12.0, (double)16.0);
    private static final VoxelShape WOODEN_WEST_SIDE = Block.box((double)0.0, (double)2.5, (double)7.5, (double)8.5, (double)12.0, (double)8.5);
    private static final VoxelShape WOODEN_EAST_SIDE = Block.box((double)7.5, (double)2.5, (double)7.5, (double)16.0, (double)12.0, (double)8.5);
    public static final Map<Direction, VoxelShape> WOODEN_SHAPES = Map.of(Direction.UP, WOODEN_POLE, Direction.NORTH, WOODEN_NORTH_SIDE, Direction.SOUTH, WOODEN_SOUTH_SIDE, Direction.WEST, WOODEN_WEST_SIDE, Direction.EAST, WOODEN_EAST_SIDE);

    public RailingBlock(BaseBlockProperty property, Map<Direction, VoxelShape> partShapes) {
        super(property.properties().noOcclusion());
        this.property = property;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SHIFTED, (Comparable)Boolean.valueOf(false))).setValue((Property)POLE_LOCKED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByPart = partShapes;
        this.shapeByIndex = this.makeShapes();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos northSide = blockpos.north();
        BlockPos eastSide = blockpos.east();
        BlockPos southSide = blockpos.south();
        BlockPos westSide = blockpos.west();
        BlockState northState = levelreader.getBlockState(northSide);
        BlockState eastState = levelreader.getBlockState(eastSide);
        BlockState southState = levelreader.getBlockState(southSide);
        BlockState westState = levelreader.getBlockState(westSide);
        boolean north = this.connectsTo(Direction.NORTH, false, northSide, northState, (BlockGetter)levelreader);
        boolean east = this.connectsTo(Direction.EAST, false, eastSide, eastState, (BlockGetter)levelreader);
        boolean south = this.connectsTo(Direction.SOUTH, false, southSide, southState, (BlockGetter)levelreader);
        boolean west = this.connectsTo(Direction.WEST, false, westSide, westState, (BlockGetter)levelreader);
        boolean up = !(east && west && !north && !south || !east && !west && north && south);
        BlockState waterState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)waterState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        boolean north = (Boolean)pState.getValue((Property)NORTH);
        boolean south = (Boolean)pState.getValue((Property)SOUTH);
        boolean east = (Boolean)pState.getValue((Property)EAST);
        boolean west = (Boolean)pState.getValue((Property)WEST);
        boolean shifted = (Boolean)pState.getValue((Property)SHIFTED);
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN || pFacing == Direction.UP) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        if (pFacing == Direction.NORTH) {
            north = this.connectsTo(Direction.NORTH, shifted, pFacingPos, pFacingState, (BlockGetter)pLevel);
        }
        if (pFacing == Direction.SOUTH) {
            south = this.connectsTo(Direction.SOUTH, shifted, pFacingPos, pFacingState, (BlockGetter)pLevel);
        }
        if (pFacing == Direction.EAST) {
            east = this.connectsTo(Direction.EAST, shifted, pFacingPos, pFacingState, (BlockGetter)pLevel);
        }
        if (pFacing == Direction.WEST) {
            west = this.connectsTo(Direction.WEST, shifted, pFacingPos, pFacingState, (BlockGetter)pLevel);
        }
        boolean up = (Boolean)pState.getValue((Property)POLE_LOCKED) != false || (!east || !west || north || south) && (east || west || !north || !south);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    public BlockState updatePole(BlockState state) {
        boolean north = (Boolean)state.getValue((Property)NORTH);
        boolean south = (Boolean)state.getValue((Property)SOUTH);
        boolean east = (Boolean)state.getValue((Property)EAST);
        boolean west = (Boolean)state.getValue((Property)WEST);
        boolean up = (Boolean)state.getValue((Property)POLE_LOCKED) != false || (!east || !west || north || south) && (east || west || !north || !south);
        return (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    private boolean connectsTo(Direction connectsToDirection, Boolean isSelfShifted, BlockPos connectsToPos, BlockState connectsToState, BlockGetter level) {
        boolean canConnectToSlant = false;
        if (!isSelfShifted.booleanValue() && connectsToState.getBlock() instanceof RailingSlant) {
            facing = (Direction)connectsToState.getValue((Property)BaseHorizontalDirectionalBlock.FACING);
            Boolean shifted = (Boolean)connectsToState.getValue((Property)RailingSlant.SHIFTED);
            canConnectToSlant = shifted == false && connectsToDirection == facing.getOpposite() || shifted != false && connectsToDirection == facing;
        } else if (isSelfShifted.booleanValue() && connectsToState.getBlock() instanceof RailingSlant) {
            facing = (Direction)connectsToState.getValue((Property)BaseHorizontalDirectionalBlock.FACING);
            Boolean shifted = (Boolean)connectsToState.getValue((Property)RailingSlant.SHIFTED);
            canConnectToSlant = shifted == false && connectsToDirection == facing;
        } else if (isSelfShifted.booleanValue() && level.getBlockState(connectsToPos.below()).getBlock() instanceof RailingSlant) {
            BlockState blockBelow = level.getBlockState(connectsToPos.below());
            Direction facing = (Direction)blockBelow.getValue((Property)BaseHorizontalDirectionalBlock.FACING);
            Boolean shifted = (Boolean)blockBelow.getValue((Property)RailingSlant.SHIFTED);
            canConnectToSlant = shifted != false && connectsToDirection == facing.getOpposite();
        }
        boolean pSideSolid = connectsToState.isFaceSturdy(level, connectsToPos, connectsToDirection.getOpposite());
        return connectsToState.getBlock() instanceof RailingBlock || canConnectToSlant || !RailingBlock.isExceptionForConnection((BlockState)connectsToState) && pSideSolid;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getShape(pState, pLevel, pPos, pContext);
    }

    private Map<BlockState, VoxelShape> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean up : UP.getPossibleValues()) {
            for (Boolean east : EAST.getPossibleValues()) {
                for (Boolean north : NORTH.getPossibleValues()) {
                    for (Boolean west : WEST.getPossibleValues()) {
                        for (Boolean south : SOUTH.getPossibleValues()) {
                            VoxelShape shape = Shapes.empty();
                            if (north.booleanValue()) {
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.NORTH));
                            }
                            if (south.booleanValue()) {
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.SOUTH));
                            }
                            if (east.booleanValue()) {
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.EAST));
                            }
                            if (west.booleanValue()) {
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.WEST));
                            }
                            if (up.booleanValue()) {
                                shape = Shapes.or((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.UP));
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)up)).setValue((Property)EAST, (Comparable)east)).setValue((Property)WEST, (Comparable)west)).setValue((Property)NORTH, (Comparable)north)).setValue((Property)SOUTH, (Comparable)south);
                            for (Boolean shifted : SHIFTED.getPossibleValues()) {
                                for (Boolean locked : POLE_LOCKED.getPossibleValues()) {
                                    for (Boolean waterlogged : WATERLOGGED.getPossibleValues()) {
                                        blockstate = (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)SHIFTED, (Comparable)shifted)).setValue((Property)POLE_LOCKED, (Comparable)locked)).setValue((Property)WATERLOGGED, (Comparable)waterlogged);
                                        builder.put((Object)blockstate, (Object)shape);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{UP, NORTH, SOUTH, EAST, WEST, SHIFTED, POLE_LOCKED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }
}

