/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.entity.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SeatDecorativeBlock
extends DecorativeBlock {
    private final Vec3 seatOffset;

    public SeatDecorativeBlock(Builder builder) {
        super(builder);
        this.seatOffset = builder.seatOffset;
    }

    public static Builder with(BaseBlockProperty property) {
        return new Builder(property);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pState.is((Block)this) && pLevel.getEntitiesOfClass(SeatEntity.class, new AABB(pPos)).isEmpty()) {
            boolean ridingSuccess = false;
            if (!pLevel.isClientSide()) {
                SeatEntity seat = new SeatEntity(pLevel, Vec3.atCenterOf((Vec3i)pPos).add(this.seatOffset));
                pLevel.addFreshEntity((Entity)seat);
                ridingSuccess = pPlayer.startRiding((Entity)seat);
            }
            return ridingSuccess ? InteractionResult.sidedSuccess((boolean)pLevel.isClientSide()) : InteractionResult.PASS;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHit);
    }

    public static class Builder
    extends DecorativeBlock.Builder {
        private Vec3 seatOffset = new Vec3(0.0, 0.5, 0.0);

        public Builder(BaseBlockProperty property) {
            super(property);
        }

        public Builder seatOffset(Vec3 offset) {
            this.seatOffset = offset;
            return this;
        }

        @Override
        public SeatDecorativeBlock build() {
            return new SeatDecorativeBlock(this);
        }
    }
}

