/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseHorizontalDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StraightStairBlock
extends BaseHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    private static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE_BOTTOM = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE_BOTTOM = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0));
    private static final VoxelShape SOUTH_SHAPE_BOTTOM = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE_BOTTOM = Shapes.or((VoxelShape)BOTTOM_AABB, (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0));
    private static final VoxelShape EAST_SHAPE_TOP = Shapes.or((VoxelShape)TOP_AABB, (VoxelShape)Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape NORTH_SHAPE_TOP = Shapes.or((VoxelShape)TOP_AABB, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0));
    private static final VoxelShape SOUTH_SHAPE_TOP = Shapes.or((VoxelShape)TOP_AABB, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE_TOP = Shapes.or((VoxelShape)TOP_AABB, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0));

    public StraightStairBlock(BaseBlockProperty property) {
        super(property);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean bottom = pState.getValue(HALF) == Half.BOTTOM;
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> {
                if (bottom) {
                    yield NORTH_SHAPE_BOTTOM;
                }
                yield NORTH_SHAPE_TOP;
            }
            case Direction.SOUTH -> {
                if (bottom) {
                    yield SOUTH_SHAPE_BOTTOM;
                }
                yield SOUTH_SHAPE_TOP;
            }
            case Direction.WEST -> {
                if (bottom) {
                    yield WEST_SHAPE_BOTTOM;
                }
                yield WEST_SHAPE_TOP;
            }
            case Direction.EAST -> {
                if (bottom) {
                    yield EAST_SHAPE_BOTTOM;
                }
                yield EAST_SHAPE_TOP;
            }
            default -> Shapes.empty();
        };
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getClickedFace();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(blockpos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && pContext.getClickLocation().y - (double)blockpos.getY() > 0.5) ? Half.BOTTOM : Half.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{WATERLOGGED, HALF});
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }
}

