/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CenserBlockEntity
extends BlockEntity {
    private final int BURN_TIME = 1200;
    private int remainingTime = 0;
    private boolean lit = false;

    public CenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CENSER.get(), pos, state);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CenserBlockEntity pBlockEntity) {
        if (pBlockEntity.remainingTime <= 0) {
            pBlockEntity.finishIncense(pLevel, pPos, pState);
        } else {
            --pBlockEntity.remainingTime;
            if (pLevel.getGameTime() % 80L == 0L) {
                pLevel.getEntitiesOfClass(LivingEntity.class, new AABB(pPos).inflate(10.0)).forEach(e -> e.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0)));
            }
        }
    }

    public void lightIncense(Level pLevel, BlockPos pPos, BlockState pState) {
        this.lit = true;
        this.remainingTime = 1200;
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)DecorativeBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        this.setChanged();
    }

    public void finishIncense(Level pLevel, BlockPos pPos, BlockState pState) {
        this.lit = false;
        this.remainingTime = 0;
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)DecorativeBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        this.setChanged();
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.remainingTime = pTag.getInt("BurnTime");
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        pTag.putInt("BurnTime", this.remainingTime);
    }
}

