/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.menu;

import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.ModItemTags;
import com.voxelutopia.ultramarine.data.recipe.ChiselTableRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.MenuTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class ChiselTableMenu
extends AbstractContainerMenu {
    public static final int SLOT_MATERIAL = 0;
    public static final int SLOT_TEMPLATE = 1;
    public static final int SLOT_COLOR_START = 2;
    public static final int SLOT_COLOR_END = 6;
    public static final int SLOT_RESULT = 6;
    private static final int INV_SLOT_START = 7;
    private static final int INV_SLOT_END = 34;
    private static final int USE_ROW_SLOT_START = 34;
    private static final int USE_ROW_SLOT_END = 43;
    private static final Predicate<ItemStack> IS_MATERIAL = i -> i.is(ItemTags.LOGS) || i.is(ModItemTags.POLISHED_PLANKS) || i.is(ItemTags.WOOL);
    private static final Predicate<ItemStack> IS_TEMPLATE = i -> i.is(ModItemTags.CHISEL_TEMPLATES);
    private static final Predicate<ItemStack> IS_COLOR = i -> i.is(ModItemTags.COMMON_DYES) || i.is(ModItemTags.DYE_POWDER);
    private final ContainerLevelAccess access;
    private final Player player;
    private final ItemStackHandler crafting = new ItemStackHandler(6);
    private final ItemStackHandler result = new ItemStackHandler(1);
    private final IItemHandler inventory;

    public ChiselTableMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.NULL);
    }

    public ChiselTableMenu(int id, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)MenuTypeRegistry.CHISEL_TABLE.get(), id);
        this.inventory = new InvWrapper((Container)inventory);
        this.access = access;
        this.player = inventory.player;
        this.addSlot((Slot)new MaterialSlot(this, (IItemHandler)this.crafting, 0, 26, 25));
        this.addSlot((Slot)new TemplateSlot(this, (IItemHandler)this.crafting, 1, 53, 25));
        int i = 2;
        int j = 0;
        while (i < 6) {
            this.addSlot((Slot)new DyeSlot(this, (IItemHandler)this.crafting, i, 26 + j * 18, 52));
            ++i;
            ++j;
        }
        this.addSlot((Slot)new OutputSlot((IItemHandler)this.result, 0, 130, 34));
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addSlot((Slot)new SlotItemHandler(this.inventory, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot((Slot)new SlotItemHandler(this.inventory, k, 8 + k * 18, 142));
        }
    }

    public void slotsChanged(SlotItemHandler slot) {
        this.broadcastChanges();
        if (slot.getSlotIndex() <= 6) {
            this.createResult();
        }
    }

    public void createResult() {
        Level level = this.player.level();
        Container ingredients = this.wrapIngredients();
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)new InvWrapper(ingredients));
        List list = level.getRecipeManager().getRecipesFor((RecipeType)RecipeTypeRegistry.CHISEL_TABLE.get(), (RecipeInput)wrapper, level);
        if (list.size() > 1) {
            Ultramarine.getLogger().warn("Duplicate chisel table recipe: ");
            list.forEach(recipe -> Ultramarine.getLogger().warn(recipe.id().toString()));
        }
        if (list.isEmpty()) {
            this.result.setStackInSlot(0, ItemStack.EMPTY);
        } else {
            ChiselTableRecipe recipe2 = (ChiselTableRecipe)((RecipeHolder)list.getFirst()).value();
            ItemStack resultItemStack = recipe2.assemble((RecipeInput)wrapper, (HolderLookup.Provider)level.registryAccess());
            this.result.setStackInSlot(0, resultItemStack);
        }
    }

    protected void onTake(Player player, ItemStack itemStack, SlotItemHandler slot) {
        for (int i = 0; i < 6; ++i) {
            ItemStack item = this.crafting.getStackInSlot(i);
            this.crafting.setStackInSlot(i, item);
            if (i == 1) continue;
            item.shrink(1);
        }
        this.slotsChanged(slot);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemstack = slotItem.copy();
            if (pIndex == 6) {
                slotItem.getItem().onCraftedBy(slotItem, pPlayer.level(), pPlayer);
                if (!this.moveItemStackTo(slotItem, 7, 43, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItem, itemstack);
            } else if (pIndex > 6 ? (IS_MATERIAL.test(slotItem) ? !this.moveItemStackTo(slotItem, 0, 1, false) : (IS_TEMPLATE.test(slotItem) ? !this.moveItemStackTo(slotItem, 1, 2, false) : (IS_COLOR.test(slotItem) ? !this.moveItemStackTo(slotItem, 2, 6, false) : (pIndex < 34 ? !this.moveItemStackTo(slotItem, 34, 43, false) : pIndex < 43 && !this.moveItemStackTo(slotItem, 7, 34, false))))) : !this.moveItemStackTo(slotItem, 7, 43, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (slotItem.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotItem);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack pStack, @NotNull Slot pSlot) {
        return ((SlotItemHandler)pSlot).getItemHandler() != this.result && super.canTakeItemForPickAll(pStack, pSlot);
    }

    public void removed(@NotNull Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((level, blockPos) -> this.clearContainer(pPlayer, this.wrapIngredients()));
    }

    private Container wrapIngredients() {
        SimpleContainer container = new SimpleContainer(6);
        for (int i = 0; i < 6; ++i) {
            container.setItem(i, this.crafting.getStackInSlot(i));
        }
        return container;
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return ChiselTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)BlockRegistry.CHISEL_TABLE.get()));
    }

    class MaterialSlot
    extends IngredientSlot {
        public MaterialSlot(ChiselTableMenu this$0, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return IS_MATERIAL.test(stack);
        }
    }

    class TemplateSlot
    extends IngredientSlot {
        public TemplateSlot(ChiselTableMenu this$0, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return IS_TEMPLATE.test(stack);
        }
    }

    class DyeSlot
    extends IngredientSlot {
        public DyeSlot(ChiselTableMenu this$0, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return IS_COLOR.test(stack);
        }
    }

    class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }

        public void onTake(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
            super.onTake(pPlayer, pStack);
            ChiselTableMenu.this.onTake(pPlayer, pStack, this);
        }

        public void setChanged() {
            super.setChanged();
            ChiselTableMenu.this.slotsChanged(this);
        }

        public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
            int i = newStackIn.getCount() - oldStackIn.getCount();
            if (i > 0) {
                this.onQuickCraft(newStackIn, i);
            }
        }
    }

    class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void setChanged() {
            super.setChanged();
            ChiselTableMenu.this.slotsChanged(this);
        }
    }
}

