/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.entity;

import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TravellingMerchant
extends WanderingTrader {
    private static final List<MerchantOffer> TRADE_OPTIONS_SELL = new ArrayList<MerchantOffer>();
    private static final List<MerchantOffer> TRADE_OPTIONS_BUY = new ArrayList<MerchantOffer>();

    public TravellingMerchant(EntityType<? extends TravellingMerchant> entityType, Level level) {
        super(entityType, level);
        ArrayList<MerchantOffer> sell = new ArrayList<MerchantOffer>(TRADE_OPTIONS_SELL);
        Collections.shuffle(sell);
        ArrayList<MerchantOffer> buy = new ArrayList<MerchantOffer>(TRADE_OPTIONS_BUY);
        Collections.shuffle(buy);
        MerchantOffers offers = new MerchantOffers();
        offers.addAll(sell.subList(0, 4));
        offers.addAll(buy.subList(0, 2));
        this.offers = offers;
    }

    @NotNull
    public MerchantOffers getOffers() {
        return this.offers;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.27).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public static List<MerchantOffer> getTradeOptions() {
        return Stream.of(TRADE_OPTIONS_SELL, TRADE_OPTIONS_BUY).flatMap(Collection::stream).toList();
    }

    static {
        TRADE_OPTIONS_SELL.addAll(List.of(new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 10), new ItemStack((ItemLike)ItemRegistry.INCENSE.get()), 8, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 4), new ItemStack((ItemLike)ItemRegistry.XUAN_PAPER.get()), 20, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 6), new ItemStack((ItemLike)ItemRegistry.SILK.get()), 20, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 8), new ItemStack((ItemLike)Items.LAPIS_LAZULI), 10, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 8), new ItemStack((ItemLike)Items.PRISMARINE_SHARD), 10, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 15), new ItemStack((ItemLike)ItemRegistry.RED_SILK_FABRIC_ROLL.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 15), new ItemStack((ItemLike)ItemRegistry.GREEN_SILK_FABRIC_ROLL.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 15), new ItemStack((ItemLike)ItemRegistry.PURPLE_SILK_FABRIC_ROLL.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 20), new ItemStack((ItemLike)ItemRegistry.CLAY_DOLL_MALE.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 20), new ItemStack((ItemLike)ItemRegistry.CLAY_DOLL_FEMALE.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 30), new ItemStack((ItemLike)ItemRegistry.PAINTING_SCROLL.get()), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 10), new ItemStack((ItemLike)ItemRegistry.CHINESE_HERBS_BAG.get()), 5, 5, 0.05f)));
        TRADE_OPTIONS_BUY.addAll(List.of(new MerchantOffer(new ItemCost((ItemLike)Items.AMETHYST_SHARD), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 6), 8, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)Items.ENDER_PEARL), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 3), 10, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)Items.BOOK), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 3), 5, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)Items.NAUTILUS_SHELL), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 20), 2, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 4), 10, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 4), 10, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 6), 8, 5, 0.05f), new MerchantOffer(new ItemCost((ItemLike)ItemRegistry.JADE.get()), new ItemStack((ItemLike)ItemRegistry.COPPER_CASH_COIN.get(), 15), 2, 5, 0.05f)));
    }
}

