/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.item;

import com.voxelutopia.ultramarine.data.registry.SoundRegistry;
import com.voxelutopia.ultramarine.world.block.RailingBlock;
import com.voxelutopia.ultramarine.world.block.state.ChiralBlockType;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WoodenMallet
extends Item {
    public WoodenMallet() {
        super(new Item.Properties().durability(100));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        ItemStack item = pContext.getItemInHand();
        Optional<Player> player = Optional.ofNullable(pContext.getPlayer());
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        boolean success = false;
        if (blockstate.hasProperty((Property)ModBlockStateProperties.SHIFTED)) {
            BlockState pNewState = (BlockState)blockstate.setValue((Property)ModBlockStateProperties.SHIFTED, (Comparable)Boolean.valueOf((Boolean)blockstate.getValue((Property)ModBlockStateProperties.SHIFTED) == false));
            level.setBlock(blockpos, pNewState, 3);
            success = true;
        }
        if (blockstate.hasProperty(ModBlockStateProperties.CHIRAL_BLOCK_TYPE)) {
            level.setBlock(blockpos, (BlockState)blockstate.setValue(ModBlockStateProperties.CHIRAL_BLOCK_TYPE, (Comparable)((Object)((ChiralBlockType)((Object)blockstate.getValue(ModBlockStateProperties.CHIRAL_BLOCK_TYPE))).getOpposite())), 3);
            success = true;
        }
        if (blockstate.hasProperty((Property)ModBlockStateProperties.LOCKED) && player.isPresent() && player.get().isCrouching()) {
            Block block = (blockstate = (BlockState)blockstate.setValue((Property)ModBlockStateProperties.LOCKED, (Comparable)Boolean.valueOf((Boolean)blockstate.getValue((Property)ModBlockStateProperties.LOCKED) == false))).getBlock();
            if (block instanceof RailingBlock) {
                RailingBlock railingBlock = (RailingBlock)block;
                blockstate = railingBlock.updatePole(blockstate);
            }
            level.setBlock(blockpos, blockstate, 3);
            success = true;
        }
        if (success) {
            player.ifPresent(player1 -> {
                item.hurtAndBreak(1, (LivingEntity)player1, LivingEntity.getSlotForHand((InteractionHand)pContext.getHand()));
                player1.awardStat(Stats.ITEM_USED.get((Object)item.getItem()));
                level.playSound((Player)player.get(), blockpos, (SoundEvent)SoundRegistry.WOOD_HAMMER.get(), SoundSource.BLOCKS, 1.0f, 0.75f);
            });
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(pContext);
    }
}

