/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.helpers.GuiHelpers;
import com.deadzoke.ignitehud.helpers.Texture;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;

public class GuiClockWidget {
    private static final Map<String, ClockLine> WIDGET_LINES = new LinkedHashMap<String, ClockLine>();
    private static final Texture GUI_CLOCK = new Texture("clock", 128);

    public static void renderClockWidget(GuiGraphics guiGraphics, int posX, int posY) {
        int rowHeight = 8;
        int rowSpacing = 4;
        if (WIDGET_LINES.isEmpty()) {
            return;
        }
        int elementHeight = rowHeight * WIDGET_LINES.size() + rowSpacing * (WIDGET_LINES.size() - 1);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CLOCK.get(), posX - 6, posY - 4, 0.0f, 0.0f, 6, 3, GuiClockWidget.GUI_CLOCK.width, GuiClockWidget.GUI_CLOCK.height);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CLOCK.get(), posX - 6, posY - 1, 12.0f, 0.0f, 6, elementHeight + 1, 6, 3, GuiClockWidget.GUI_CLOCK.width, GuiClockWidget.GUI_CLOCK.height);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CLOCK.get(), posX - 6, posY + elementHeight, 6.0f, 0.0f, 6, 3, GuiClockWidget.GUI_CLOCK.width, GuiClockWidget.GUI_CLOCK.height);
        int index = 0;
        for (ClockLine clockLine : WIDGET_LINES.values()) {
            clockLine.render(guiGraphics, posX - 10, posY + (rowHeight + rowSpacing) * index);
            ++index;
        }
    }

    public static void addDay() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        new ClockLine("day", (guiGraphics, posX, posY) -> {
            long day = mc.level.getDayTime() / 24000L + 1L;
            String dayString = "Day " + day;
            guiGraphics.drawString(mc.font, dayString, posX - mc.font.width(dayString), posY, GuiHelpers.hexToARGB("#FFFFFF"));
        });
    }

    public static void addTime() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        new ClockLine("time", (guiGraphics, posX, posY) -> {
            long time = mc.level.getDayTime() % 24000L;
            long adjustedTime = (time + 6000L) % 24000L;
            int hour = (int)(adjustedTime / 1000L);
            int minute = (int)(adjustedTime % 1000L * 60L / 1000L);
            String timeString = String.format("%02d:%02d", hour, minute);
            int textWidth = mc.font.width(timeString);
            boolean sleepTime = time >= 12541L && time < 23458L;
            guiGraphics.drawString(mc.font, timeString, posX - textWidth, posY, GuiHelpers.hexToARGB("#FFFFFF"));
            if (!sleepTime) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CLOCK.get(), posX - textWidth - 2 - 10, posY - 1, 0.0f, 3.0f, 10, 10, GuiClockWidget.GUI_CLOCK.width, GuiClockWidget.GUI_CLOCK.height);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CLOCK.get(), posX - textWidth - 2 - 10, posY - 1, (float)(mc.level.getMoonPhase() * 10), 13.0f, 10, 10, GuiClockWidget.GUI_CLOCK.width, GuiClockWidget.GUI_CLOCK.height);
            }
        });
    }

    public static class ClockLine {
        private final ClockLineRenderer renderer;

        ClockLine(String id, ClockLineRenderer renderer) {
            this.renderer = renderer;
            WIDGET_LINES.put(id, this);
        }

        public void render(GuiGraphics guiGraphics, int posX, int posY) {
            this.renderer.render(guiGraphics, posX, posY);
        }
    }

    @FunctionalInterface
    public static interface ClockLineRenderer {
        public void render(GuiGraphics var1, int var2, int var3);
    }
}

