/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.helpers.GuiHelpers;
import com.deadzoke.ignitehud.helpers.Texture;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GuiEquippedItems {
    private static final Map<String, EquippedItem> ITEM_SLOTS = new LinkedHashMap<String, EquippedItem>();
    private static final Texture GUI_ITEMS = new Texture("items", 64, 32);

    public static List<EquippedItem> getEquippedItems() {
        return ITEM_SLOTS.values().stream().filter(item -> item.getItemStack() != null).toList();
    }

    public static void renderEquippedItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        List<EquippedItem> equippedItems = GuiEquippedItems.getEquippedItems();
        int baseW = 20;
        int baseH = 23;
        int spacing = 3;
        int posY = mc.getWindow().getGuiScaledHeight() - 52;
        int _posX = (mc.getWindow().getGuiScaledWidth() - (equippedItems.size() * (baseW + spacing) - spacing)) / 2;
        for (EquippedItem item : equippedItems) {
            int qty;
            float _durabilityProgress;
            ItemStack stack = item.getItemStack();
            boolean isDamageable = stack.isDamageableItem();
            boolean isUnbreakable = stack.get(DataComponents.UNBREAKABLE) != null;
            boolean shouldDrawDurabilityBar = isDamageable || isUnbreakable;
            float fade = 1.0f;
            if (isDamageable && (_durabilityProgress = (float)stack.getDamageValue() / (float)stack.getMaxDamage()) > 0.9f) {
                float output = 2.0f - ((float)Mth.clamp((double)_durabilityProgress, (double)0.9, (double)1.0) - 0.9f) / 0.1f * 1.2f;
                fade = Mth.cos((float)((float)mc.gui.getGuiTicks() / output)) / 4.0f + 0.75f;
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_ITEMS.get(), _posX, posY, !shouldDrawDurabilityBar ? (float)baseW : 0.0f, 0.0f, baseW, baseH, GuiEquippedItems.GUI_ITEMS.width, GuiEquippedItems.GUI_ITEMS.height, ARGB.white((float)fade));
            guiGraphics.renderItem((LivingEntity)mc.player, stack, _posX + 2, posY + 5, 0);
            guiGraphics.pose().pushMatrix();
            if (isDamageable) {
                int durability = stack.getMaxDamage() - stack.getDamageValue();
                float durabilityProgress = Math.max(0.0f, (float)durability / (float)stack.getMaxDamage());
                int[] rgb = GuiHelpers.HSVtoRGB(durabilityProgress * 2.0f, 1.0f, 1.0f);
                int tint = ARGB.color((int)ARGB.white((float)fade), (int)rgb[0], (int)rgb[1], (int)rgb[2]);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_ITEMS.get(), _posX + 2, posY + 1, 0.0f, 23.0f, (int)(durabilityProgress * 16.0f), 2, GuiEquippedItems.GUI_ITEMS.width, GuiEquippedItems.GUI_ITEMS.height, tint);
                GuiHelpers.drawCustomNumber(guiGraphics, _posX + baseW + 1 - (String.valueOf(durability).length() * 4 + 1), posY + 17, durability, tint);
            }
            if (isUnbreakable) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_ITEMS.get(), _posX + 2, posY + 1, 0.0f, 25.0f, 16, 2, GuiEquippedItems.GUI_ITEMS.width, GuiEquippedItems.GUI_ITEMS.height);
            }
            if (stack.isStackable() && (qty = mc.player.getInventory().countItem(stack.getItem())) > 1) {
                GuiHelpers.drawCustomNumber(guiGraphics, _posX + baseW + 1 - (String.valueOf(qty).length() * 4 + 1), posY + 17, qty);
            }
            guiGraphics.pose().popMatrix();
            _posX += baseW + spacing;
        }
    }

    public static class EquippedItem {
        public EquipmentSlot slot;

        EquippedItem(String id, EquipmentSlot slot) {
            this.slot = slot;
            ITEM_SLOTS.put(id, this);
        }

        public ItemStack getItemStack() {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return null;
            }
            ItemStack stack = mc.player.getItemBySlot(this.slot);
            return mc.player.hasItemInSlot(this.slot) && stack != ItemStack.EMPTY ? stack : null;
        }
    }
}

