/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.client.GuiClockWidget;
import com.deadzoke.ignitehud.client.GuiEquippedItems;
import com.deadzoke.ignitehud.client.GuiWidgetAttributes;
import com.deadzoke.ignitehud.helpers.BossBarColourTracker;
import com.deadzoke.ignitehud.helpers.GuiHelpers;
import com.deadzoke.ignitehud.helpers.Texture;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class GuiOverlay {
    private static final Texture GUI_BASE = new Texture("base", 128, 64);
    private static final Texture GUI_EXPERIENCE = new Texture("experience", 16, 32);
    private static final Texture GUI_HEALTH = new Texture("health", 128, 64);
    private static final Texture GUI_HEALTH_HEALING = new Texture("health-heal", 128, 16);
    private static final Texture GUI_HEALTH_REGENERATION = new Texture("health-regen", 128, 128);
    private static final Texture GUI_AIR = new Texture("air", 128, 32);
    private static final Texture GUI_MOUNT = new Texture("mount", 128, 64);
    private static final Texture GUI_EVENT = new Texture("event", 256, 128);
    private static final Texture GUI_EFFECTS = new Texture("effects", 64, 64);
    private static final Texture GUI_NUMBERS_ROMAN = new Texture("numbers-roman", 24, 60);
    private static ItemStack previousItemStack;
    private static int selectedItemTimer;

    public static void HARDCORE_ICON(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || !GuiHelpers.shouldDrawSurvivalHUD() || !GuiHelpers.isHardcore()) {
            return;
        }
        GuiHelpers.push("hardcore_icon");
        int posX = 30;
        int posY = 14;
        boolean uvX = false;
        int uvY = 29;
        int uvW = 10;
        int uvH = 10;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_BASE.get(), posX, posY, (float)uvX, (float)uvY, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        GuiHelpers.pop();
    }

    public static void EXPERIENCE_LEVEL(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.options.hideGui || !GuiHelpers.hasExperience() || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        GuiHelpers.push("experience_level");
        int posX = 35;
        int posY = 38;
        String expLevel = String.valueOf(mc.player.experienceLevel);
        GuiHelpers.drawOutlinedString(guiGraphics, posX - mc.font.width(expLevel) / 2, posY, expLevel, GuiHelpers.hexToARGB("#C8FF8F"), GuiHelpers.hexToARGB("#000000"));
        GuiHelpers.pop();
    }

    public static void PLAYER_FRAME(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        GuiHelpers.push("player_frame");
        int posX = 20;
        int posY = 15;
        int uvW = 29;
        int uvH = 29;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_BASE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        GuiHelpers.pop();
    }

    public static void EXPERIENCE_BAR(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.options.hideGui || !GuiHelpers.hasExperience() || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        GuiHelpers.push("experience_bar");
        int posX = 18;
        int posY = 17;
        int uvW = 5;
        int uvH = 25;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EXPERIENCE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        int progress = (int)Math.ceil(mc.player.experienceProgress * (float)uvH);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EXPERIENCE.get(), posX, posY + uvH - progress, (float)uvW, (float)(uvH - progress), uvW, progress, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        GuiHelpers.pop();
    }

    public static void PLAYER_ICON(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null) {
            return;
        }
        GuiHelpers.push("player_icon");
        int posX = 26;
        int posY = 21;
        int size = 17;
        ResourceLocation playerTexture = GuiHelpers.getPlayerSkin();
        if (playerTexture != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, playerTexture, posX, posY, (float)size, (float)size, size, size, size * 8, size * 8);
            if (mc.options.isModelPartEnabled(PlayerModelPart.HAT)) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, playerTexture, posX, posY, (float)(size * 5), (float)size, size, size, size * 8, size * 8);
            }
        }
        GuiHelpers.pop();
    }

    public static void PLAYER_NAME(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null) {
            return;
        }
        GuiHelpers.push("player_name");
        int posX = 56;
        int posY = 16;
        if (!GuiHelpers.shouldDrawSurvivalHUD()) {
            posY = 26;
        }
        String text = mc.player.getDisplayName() != null ? mc.player.getDisplayName().getString() : "Player";
        guiGraphics.drawString(mc.font, text, posX, posY, GuiHelpers.hexToARGB("#FFFFFF"));
        GuiHelpers.pop();
    }

    public static void PLAYER_HEALTH(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        GuiHelpers.push("player_health");
        int posX = 54;
        int posY = 27;
        LocalPlayer player = mc.player;
        float health = player.getHealth();
        AttributeInstance maxHealthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        float healthProgress = maxHealthAttribute != null ? health / (float)maxHealthAttribute.getValue() : 0.0f;
        healthProgress = Math.min(Math.max(healthProgress, 0.0f), 1.0f);
        int healthBarType = 0;
        if (player.hasEffect(MobEffects.WITHER)) {
            healthBarType = 3;
        } else if (player.isFullyFrozen()) {
            healthBarType = 4;
        } else if (player.hasEffect(MobEffects.POISON)) {
            healthBarType = 2;
        } else if (player.hasEffect(MobEffects.ABSORPTION)) {
            healthBarType = 1;
        }
        boolean uvX = false;
        int uvY = 0;
        int uvW = 91;
        int uvH = 5;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_HEALTH.get(), posX, posY, (float)uvX, (float)(uvY + healthBarType * uvH * 2), uvW, uvH, GuiOverlay.GUI_HEALTH.width, GuiOverlay.GUI_HEALTH.height);
        float fade = 1.0f;
        if (healthProgress <= 0.17f) {
            fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / 3.0f)) + 1.4f) / 2.0f;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_HEALTH.get(), posX, posY, (float)uvX, (float)(uvY + uvH + healthBarType * uvH * 2), (int)((float)uvW * healthProgress), uvH, GuiOverlay.GUI_HEALTH.width, GuiOverlay.GUI_HEALTH.height, ARGB.white((float)fade));
        if (GuiHelpers.isHealing(health)) {
            int HuvX = 0;
            int HuvY = 0;
            int HuvW = 91;
            int HuvH = 5;
            int Hframes = 2;
            double Hspeed = 0.25;
            GuiHelpers.renderAnimation(guiGraphics, GUI_HEALTH_HEALING.get(), posX, posY, HuvX, HuvY, HuvW, HuvH, GuiOverlay.GUI_HEALTH_HEALING.width, GuiOverlay.GUI_HEALTH_HEALING.height, Hspeed, Hframes);
        }
        if (player.hasEffect(MobEffects.REGENERATION)) {
            int RuvX = 0;
            int RuvY = 0;
            int RuvW = 91;
            int RuvH = 5;
            int Rframes = 20;
            double Rspeed = 1.0;
            GuiHelpers.renderAnimation(guiGraphics, GUI_HEALTH_REGENERATION.get(), posX, posY, RuvX, RuvY, RuvW, RuvH, GuiOverlay.GUI_HEALTH_REGENERATION.width, GuiOverlay.GUI_HEALTH_REGENERATION.height, Rspeed, Rframes);
        }
        GuiHelpers.pop();
    }

    public static void WIDGET_ATTRIBUTES(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        GuiHelpers.push("widget_attributes");
        GuiWidgetAttributes.addFoodLevel(mc);
        GuiWidgetAttributes.addSaturationLevel(mc);
        GuiWidgetAttributes.addArmorLevel(mc);
        GuiWidgetAttributes.addToughnessLevel(mc);
        GuiWidgetAttributes.renderAttributeList(guiGraphics, 55, 34, 5);
        GuiHelpers.pop();
    }

    public static void AIR_LEVEL(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        GuiHelpers.push("air_level");
        int posX = (mc.getWindow().getGuiScaledWidth() - 121) / 2;
        int posY = mc.getWindow().getGuiScaledHeight() - 65;
        float air = mc.player.getAirSupply();
        if (mc.player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || air < 300.0f) {
            float airProgress = air / 300.0f;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_AIR.get(), posX, posY, 0.0f, 0.0f, 121, 5, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_AIR.get(), posX + 1, posY + 1, 1.0f, 6.0f, (int)(airProgress * 121.0f), 3, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            int iconIndex = (int)(-(air / 2.0f - 3.0f));
            if (iconIndex < 0) {
                iconIndex = 0;
            }
            if (iconIndex > 2) {
                iconIndex = -1;
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_AIR.get(), (mc.getWindow().getGuiScaledWidth() - 10) / 2, posY - 2, (float)(iconIndex * 10), 10.0f, 10, 10, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
        }
        GuiHelpers.pop();
    }

    public static void VEHICLE_INFO(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null) {
            return;
        }
        GuiHelpers.push("vehicle_info");
        int posX = 21;
        int posY = 65;
        Entity vehicleEntity = mc.player.getVehicle();
        if (vehicleEntity instanceof LivingEntity) {
            boolean canJump;
            LivingEntity vehicle = (LivingEntity)vehicleEntity;
            boolean bl = canJump = mc.player.jumpableVehicle() != null;
            if (canJump) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX, posY, 0.0f, 20.0f, 6, 25, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX, posY, 6.0f, 20.0f, 6, 19, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX + 9, posY, 12.0f, 20.0f, 10, 10, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            guiGraphics.drawString(mc.font, vehicle.getName(), posX + 21, posY + 1, GuiHelpers.hexToARGB("#FFFFFF"));
            float healthProgress = Math.min(vehicle.getHealth() / vehicle.getMaxHealth(), 1.0f);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX + 10, posY + 12, 0.0f, 0.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX + 10, posY + 12, 0.0f, 5.0f, (int)(91.0f * healthProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            if (canJump) {
                float jumpProgress = mc.player.getJumpRidingScale();
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX + 10, posY + 18, 0.0f, 10.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_MOUNT.get(), posX + 10, posY + 18, 0.0f, 15.0f, (int)(91.0f * jumpProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            }
        }
        GuiHelpers.pop();
    }

    public static void BOSS_BAR(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || mc.level == null) {
            return;
        }
        GuiHelpers.push("boss_bar");
        int uvW = 182;
        int posX = (mc.getWindow().getGuiScaledWidth() - uvW) / 2;
        int posY = 15;
        int spacing = 19;
        ArrayList<BossEvent> nearbyBosses = new ArrayList<BossEvent>(BossBarColourTracker.getAll().values());
        int _posY = posY;
        for (BossEvent event : nearbyBosses) {
            Component name = event.getName();
            int nameWidth = mc.font.width((FormattedText)name);
            int nameBgWidth = 3 + nameWidth + 3;
            int nameBgPosX = posX + (uvW - nameBgWidth - 8) / 2 - 1;
            int nameBgPosY = _posY + 2;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), nameBgPosX, nameBgPosY, 0.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), nameBgPosX + 4, nameBgPosY, 8.0f, 0.0f, nameBgWidth, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), nameBgPosX + 4 + nameBgWidth, nameBgPosY, 4.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int barPosY = _posY + 6;
            float healthRatio = event.getProgress();
            int filledWidth = (int)(healthRatio * (float)(uvW - 2));
            int barIndex = switch (event.getColor()) {
                default -> throw new MatchException(null, null);
                case BossEvent.BossBarColor.PINK -> 0;
                case BossEvent.BossBarColor.BLUE -> 1;
                case BossEvent.BossBarColor.RED -> 2;
                case BossEvent.BossBarColor.GREEN -> 3;
                case BossEvent.BossBarColor.YELLOW -> 4;
                case BossEvent.BossBarColor.PURPLE -> 5;
                case BossEvent.BossBarColor.WHITE -> 6;
            };
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), posX, barPosY, 0.0f, 6.0f, uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), posX + 1, barPosY, 1.0f, (float)(11 + barIndex * 5), filledWidth, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int notchesIndex = switch (event.getOverlay().getName()) {
                case "progress" -> 1;
                case "notched_6" -> 0;
                case "notched_10" -> 1;
                case "notched_12" -> 2;
                case "notched_20" -> 3;
                default -> 0;
            };
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EVENT.get(), posX, barPosY, 0.0f, (float)(46 + notchesIndex * 5), uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            GuiHelpers.drawOutlinedString(guiGraphics, posX + (uvW - nameWidth) / 2, _posY, name.getString(), GuiHelpers.hexToARGB("#ffffff"), GuiHelpers.hexToARGB("#000000"));
            _posY += spacing;
        }
        GuiHelpers.pop();
    }

    public static void ITEM_NAME(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        ItemStack selectedItemStack = mc.player.getMainHandItem();
        if (selectedItemStack != previousItemStack) {
            previousItemStack = selectedItemStack;
            selectedItemTimer = (int)(150.0 * (Double)mc.options.notificationDisplayTime().get());
        }
        if (--selectedItemTimer <= 0 || previousItemStack.isEmpty()) {
            return;
        }
        GuiHelpers.push("item_name");
        if (selectedItemTimer > 0 && !selectedItemStack.isEmpty()) {
            int l;
            MutableComponent mutablecomponent = Component.empty().append(selectedItemStack.getHoverName()).withStyle(selectedItemStack.getRarity().getStyleModifier());
            if (selectedItemStack.has(DataComponents.CUSTOM_NAME)) {
                mutablecomponent.withStyle(ChatFormatting.ITALIC);
            }
            Component highlightTip = selectedItemStack.getHighlightTip((Component)mutablecomponent);
            int i = mc.font.width((FormattedText)highlightTip);
            int j = (guiGraphics.guiWidth() - i) / 2;
            int k = guiGraphics.guiHeight() - 67;
            if (!mc.gameMode.canHurtPlayer()) {
                k += 14;
            }
            if ((l = (int)Math.min((float)selectedItemTimer * 256.0f / 10.0f, 255.0f)) > 0) {
                Font font = IClientItemExtensions.of((ItemStack)selectedItemStack).getFont(selectedItemStack, IClientItemExtensions.FontContext.SELECTED_ITEM_NAME);
                if (font == null) {
                    guiGraphics.drawStringWithBackdrop(mc.font, highlightTip, j, k, i, ARGB.color((int)l, (int)-1));
                } else {
                    j = (guiGraphics.guiWidth() - font.width((FormattedText)highlightTip)) / 2;
                    guiGraphics.drawStringWithBackdrop(font, highlightTip, j, k, i, ARGB.color((int)l, (int)-1));
                }
            }
        }
        GuiHelpers.pop();
    }

    public static void EQUIPPED_ITEMS(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        GuiHelpers.push("item_name");
        new GuiEquippedItems.EquippedItem("head", EquipmentSlot.HEAD);
        new GuiEquippedItems.EquippedItem("chest", EquipmentSlot.CHEST);
        new GuiEquippedItems.EquippedItem("legs", EquipmentSlot.LEGS);
        new GuiEquippedItems.EquippedItem("feet", EquipmentSlot.FEET);
        new GuiEquippedItems.EquippedItem("main_hand", EquipmentSlot.MAINHAND);
        new GuiEquippedItems.EquippedItem("off_hand", EquipmentSlot.OFFHAND);
        GuiEquippedItems.renderEquippedItems(guiGraphics);
        GuiHelpers.pop();
    }

    public static void EFFECTS(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.player == null || mc.level == null || !GuiHelpers.shouldDrawSurvivalHUD()) {
            return;
        }
        Collection effects = mc.player.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        if (mc.screen != null && mc.screen.showsActiveEffects()) {
            return;
        }
        GuiHelpers.push("effects");
        int baseW = 27;
        int baseH = 17;
        int effectSpacing = 3;
        int rowSpacing = 10;
        int count = 0;
        for (MobEffectInstance effectInstance : Ordering.natural().reverse().sortedCopy((Iterable)effects)) {
            if (!IClientMobEffectExtensions.of((MobEffectInstance)effectInstance).isVisibleInGui(effectInstance) || !effectInstance.showIcon()) {
                return;
            }
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            int effectDuration = effectInstance.getDuration();
            int posX = mc.getWindow().getGuiScaledWidth() - (15 + baseW + (baseW + effectSpacing) * (count % 4));
            int posY = mc.getWindow().getGuiScaledHeight() - 15 - baseH - (baseH + rowSpacing) * (count / 4);
            int effectBackgroundTextureOffset = 0;
            if (effectInstance.isAmbient()) {
                effectBackgroundTextureOffset = 2;
            } else if (!effect.isBeneficial()) {
                effectBackgroundTextureOffset = 1;
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_EFFECTS.get(), posX, posY, 0.0f, (float)(baseH * effectBackgroundTextureOffset), baseW, baseH, GuiOverlay.GUI_EFFECTS.width, GuiOverlay.GUI_EFFECTS.height);
            float fade = 1.0f;
            if (!effectInstance.isInfiniteDuration() && !effectInstance.isAmbient() && effectInstance.endsWithin(200)) {
                fade = GuiHelpers.blinkEffect(effectDuration, (float)effectDuration / 200.0f, 4.0f, 10.0f, 0.25f, 1.0f);
            }
            ResourceLocation effectIcon = Gui.getMobEffectSprite((Holder)effectInstance.getEffect());
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, effectIcon, posX + 5, posY - 6, 18, 18, ARGB.white((float)fade));
            int strength = effectInstance.getAmplifier();
            if (strength > 0 && strength < 10) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_NUMBERS_ROMAN.get(), posX + 16, posY - 1, 12.0f, (float)(6 + 6 * (strength - 1)), 12, 6, GuiOverlay.GUI_NUMBERS_ROMAN.width, GuiOverlay.GUI_NUMBERS_ROMAN.height);
            }
            String effectDurationTime = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)mc.level.tickRateManager().tickrate()).getString();
            String effectDurationOutput = effectDuration < 71980 ? effectDurationTime : "-:-";
            int effectDurationPosX = effectInstance.isInfiniteDuration() || effectDuration >= 7198 ? 15 : 14;
            GuiHelpers.drawOutlinedString(guiGraphics, posX - mc.font.width(effectDurationOutput) / 2 + effectDurationPosX, posY + 11, effectDurationOutput, GuiHelpers.decimalToARGB(effect.getColor()), GuiHelpers.hexToARGB("#000000"));
            ++count;
        }
        GuiHelpers.pop();
    }

    public static void CLOCK(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui) {
            return;
        }
        GuiHelpers.push("clock");
        int posX = mc.getWindow().getGuiScaledWidth() - 20;
        int posY = 20;
        GuiClockWidget.addDay();
        GuiClockWidget.addTime();
        GuiClockWidget.renderClockWidget(guiGraphics, posX, posY);
        GuiHelpers.pop();
    }

    static {
        selectedItemTimer = 0;
    }
}

