/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.events;

import com.deadzoke.ignitehud.client.GuiOverlay;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="ignitehud", value={Dist.CLIENT})
public class GuiEvents {
    private static final Set<String> BLOCKED_OVERLAYS = Set.of("air_level", "armor_level", "experience_bar", "food_level", "jump_meter", "vehicle_health", "player_health", "effects", "selected_item_name", "boss_overlay", "experience_level", "contextual_info_bar_background");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Pre event) {
        if (event.getName().getNamespace().equals("minecraft") && BLOCKED_OVERLAYS.contains(event.getName().getPath())) {
            event.setCanceled(true);
        }
    }

    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        GuiEvents.registerGuiOverlay(event, "experience_bar", GuiOverlay::EXPERIENCE_BAR);
        GuiEvents.registerGuiOverlay(event, "player_icon", GuiOverlay::PLAYER_ICON);
        GuiEvents.registerGuiOverlay(event, "player_frame", GuiOverlay::PLAYER_FRAME);
        GuiEvents.registerGuiOverlay(event, "experience_level", GuiOverlay::EXPERIENCE_LEVEL);
        GuiEvents.registerGuiOverlay(event, "hardcore_icon", GuiOverlay::HARDCORE_ICON);
        GuiEvents.registerGuiOverlay(event, "player_name", GuiOverlay::PLAYER_NAME);
        GuiEvents.registerGuiOverlay(event, "player_health", GuiOverlay::PLAYER_HEALTH);
        GuiEvents.registerGuiOverlay(event, "widget_attributes", GuiOverlay::WIDGET_ATTRIBUTES);
        GuiEvents.registerGuiOverlay(event, "vehicle_info", GuiOverlay::VEHICLE_INFO);
        GuiEvents.registerGuiOverlay(event, "boss_bar", GuiOverlay::BOSS_BAR);
        GuiEvents.registerGuiOverlay(event, "clock", GuiOverlay::CLOCK);
        GuiEvents.registerGuiOverlay(event, "air_level", GuiOverlay::AIR_LEVEL);
        GuiEvents.registerGuiOverlay(event, "item_name", GuiOverlay::ITEM_NAME);
        GuiEvents.registerGuiOverlay(event, "equipped_items", GuiOverlay::EQUIPPED_ITEMS);
        GuiEvents.registerGuiOverlay(event, "effects", GuiOverlay::EFFECTS);
    }

    public static void registerGuiOverlay(RegisterGuiLayersEvent event, String id, Consumer<GuiGraphics> layer) {
        ResourceLocation resource = ResourceLocation.fromNamespaceAndPath((String)"ignitehud", (String)id);
        event.registerBelow(VanillaGuiLayers.HOTBAR, resource, (guiGraphics, _p2) -> layer.accept(guiGraphics));
    }
}

