/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.helpers.GuiHelpers;
import com.deadzoke.ignitehud.helpers.Texture;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GuiWidgetAttributes {
    private static final Map<String, WidgetAttribute> WIDGET_ATTRIBUTES = new LinkedHashMap<String, WidgetAttribute>();
    private static final Texture GUI_BASE = new Texture("base", 128, 64);

    public static void renderAttributeList(GuiGraphics guiGraphics, int posX, int posY, int spacing) {
        Minecraft mc = Minecraft.getInstance();
        int iconSize = 10;
        int uvY = 29;
        int _posX = posX;
        for (WidgetAttribute attribute : WIDGET_ATTRIBUTES.values()) {
            if (!attribute.renderOnEmptyValue && (attribute.value == null || attribute.value.isEmpty() || attribute.value.equals("0"))) continue;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_BASE.get(), _posX, posY, (float)((attribute.iconIndex + 1) * iconSize), (float)uvY, iconSize, iconSize, GuiWidgetAttributes.GUI_BASE.width, GuiWidgetAttributes.GUI_BASE.height, ARGB.white((float)attribute.fade));
            _posX += iconSize;
            guiGraphics.drawString(mc.font, attribute.value, _posX += 2, posY + 1, attribute.color);
            _posX += mc.font.width(attribute.value);
            _posX += spacing;
        }
    }

    public static void addFoodLevel(Minecraft mc) {
        int foodLevel = mc.player.getFoodData().getFoodLevel();
        float fade = 1.0f;
        if (foodLevel <= 3) {
            fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / Math.max((float)foodLevel, 0.8f))) + 1.4f) / 2.0f;
        }
        if (mc.player.hasEffect(MobEffects.HUNGER)) {
            new WidgetAttribute("food_level", 1, String.valueOf(foodLevel), GuiHelpers.hexToARGB("#d2e3b5"), fade);
        } else {
            new WidgetAttribute("food_level", 0, String.valueOf(foodLevel), GuiHelpers.hexToARGB("#e5c4ac"), fade);
        }
    }

    public static void addSaturationLevel(Minecraft mc) {
        String saturationLevel = String.valueOf((int)mc.player.getFoodData().getSaturationLevel());
        if (mc.player.hasEffect(MobEffects.HUNGER)) {
            new WidgetAttribute("saturation_level", 3, saturationLevel, GuiHelpers.hexToARGB("#e5e699"));
        } else {
            new WidgetAttribute("saturation_level", 2, saturationLevel, GuiHelpers.hexToARGB("#f0d556"));
        }
    }

    public static void addArmorLevel(Minecraft mc) {
        String armorLevel = String.valueOf(mc.player.getArmorValue());
        new WidgetAttribute("armor_level", 4, armorLevel, GuiHelpers.hexToARGB("#d1d3e3"), 1.0f, false);
    }

    public static void addToughnessLevel(Minecraft mc) {
        String toughnessLevel = String.valueOf(Mth.floor((double)mc.player.getAttributeValue(Attributes.ARMOR_TOUGHNESS)));
        new WidgetAttribute("toughness_level", 5, toughnessLevel, GuiHelpers.hexToARGB("#9ff8e5"), false);
    }

    public static class WidgetAttribute {
        public int iconIndex;
        public String value;
        public int color;
        public float fade = 1.0f;
        public boolean renderOnEmptyValue = true;

        WidgetAttribute(String id, int iconIndex, String value, int color) {
            new WidgetAttribute(id, iconIndex, value, color, 1.0f, true);
        }

        WidgetAttribute(String id, int iconIndex, String value, int color, boolean renderOnEmptyValue) {
            new WidgetAttribute(id, iconIndex, value, color, 1.0f, renderOnEmptyValue);
        }

        WidgetAttribute(String id, int iconIndex, String value, int color, float fade) {
            new WidgetAttribute(id, iconIndex, value, color, fade, true);
        }

        WidgetAttribute(String id, int iconIndex, String value, int color, float fade, boolean renderOnEmptyValue) {
            this.iconIndex = iconIndex;
            this.value = value;
            this.color = color;
            this.renderOnEmptyValue = renderOnEmptyValue;
            this.fade = fade;
            WIDGET_ATTRIBUTES.put(id, this);
        }
    }
}

