/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.helpers;

import com.deadzoke.ignitehud.helpers.Texture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.GameType;

public class GuiHelpers {
    private static final Texture GUI_CUSTOM_NUMBERS_5 = new Texture("numbers_5", 64, 8);

    public static void push(String id) {
        Profiler.get().push(id);
    }

    public static void pop() {
        Profiler.get().pop();
    }

    public static boolean shouldDrawSurvivalHUD() {
        Minecraft mc = Minecraft.getInstance();
        return (mc.player == null || !mc.player.isSpectator()) && (mc.gameMode == null || mc.gameMode.getPlayerMode() != GameType.CREATIVE);
    }

    public static boolean hasExperience() {
        Minecraft mc = Minecraft.getInstance();
        return mc.gameMode != null && mc.gameMode.hasExperience();
    }

    public static boolean isHardcore() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level != null && mc.level.getLevelData().isHardcore();
    }

    public static void drawOutlinedString(GuiGraphics guiGraphics, int posX, int posY, String text, int color, int outline) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        guiGraphics.drawString(font, text, posX, posY - 1, outline, false);
        guiGraphics.drawString(font, text, posX + 1, posY, outline, false);
        guiGraphics.drawString(font, text, posX, posY + 1, outline, false);
        guiGraphics.drawString(font, text, posX - 1, posY, outline, false);
        guiGraphics.drawString(font, text, posX, posY, color, false);
    }

    public static int hexToARGB(String color) {
        String string = color = color.startsWith("#") ? color.substring(1) : color;
        if (color.length() == 6) {
            int rgb = Integer.parseInt(color, 16);
            return 0xFF000000 | rgb;
        }
        if (color.length() == 8) {
            int rgba = Integer.parseInt(color, 16);
            int r = rgba >> 24 & 0xFF;
            int g = rgba >> 16 & 0xFF;
            int b = rgba >> 8 & 0xFF;
            int a = rgba & 0xFF;
            return a << 24 | r << 16 | g << 8 | b;
        }
        throw new IllegalArgumentException("Invalid hex color: " + color);
    }

    public static int decimalToARGB(int rgb) {
        return GuiHelpers.decimalToARGB(rgb, 1.0f);
    }

    public static int decimalToARGB(int rgb, float alpha) {
        return ARGB.as8BitChannel((float)alpha) << 24 | rgb & 0xFFFFFF;
    }

    public static boolean isHealing(float health) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return false;
        }
        long healthBlinkTime = 0L;
        float lastHealth = 0.0f;
        if (mc.player.invulnerableTime > 0) {
            if (health < lastHealth) {
                healthBlinkTime = mc.gui.getGuiTicks() + 20;
            } else if (health > lastHealth) {
                healthBlinkTime = mc.gui.getGuiTicks() + 10;
            }
        }
        return healthBlinkTime > (long)mc.gui.getGuiTicks() && (healthBlinkTime - (long)mc.gui.getGuiTicks()) / 3L % 2L == 1L;
    }

    public static void renderAnimation(GuiGraphics guiGraphics, ResourceLocation texture, int posX, int posY, int uvX, int uvY, int uvW, int uvH, int textureW, int textureH, double speed, int frames) {
        Minecraft mc = Minecraft.getInstance();
        int frame = (int)((double)mc.gui.getGuiTicks() * speed % (double)frames);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, posX, posY, (float)uvX, (float)(uvY + frame * uvH), uvW, uvH, textureW, textureH);
    }

    public static int[] HSVtoRGB(float h, float s, float v) {
        float[] rgb = new float[3];
        if (h == -1.0f) {
            int gray = GuiHelpers.clampToByte(v * 255.0f);
            return new int[]{gray, gray, gray};
        }
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        if ((i & 1) == 0) {
            f = 1.0f - f;
        }
        float m = v * (1.0f - s);
        float n = v * (1.0f - s * f);
        switch (i) {
            case 0: 
            case 6: {
                rgb[0] = v;
                rgb[1] = n;
                rgb[2] = m;
                break;
            }
            case 1: {
                rgb[0] = n;
                rgb[1] = v;
                rgb[2] = m;
                break;
            }
            case 2: {
                rgb[0] = m;
                rgb[1] = v;
                rgb[2] = n;
                break;
            }
            case 3: {
                rgb[0] = m;
                rgb[1] = n;
                rgb[2] = v;
                break;
            }
            case 4: {
                rgb[0] = n;
                rgb[1] = m;
                rgb[2] = v;
                break;
            }
            case 5: {
                rgb[0] = v;
                rgb[1] = m;
                rgb[2] = n;
            }
        }
        return new int[]{GuiHelpers.clampToByte(rgb[0] * 255.0f), GuiHelpers.clampToByte(rgb[1] * 255.0f), GuiHelpers.clampToByte(rgb[2] * 255.0f)};
    }

    private static int clampToByte(float value) {
        return Math.max(0, Math.min(255, Math.round(value)));
    }

    public static void drawCustomNumber(GuiGraphics guiGraphics, int posX, int posY, int number) {
        GuiHelpers.drawCustomNumber(guiGraphics, posX, posY, number, -1);
    }

    public static void drawCustomNumber(GuiGraphics guiGraphics, int posX, int posY, int number, int color) {
        String t_number = Integer.toString(number);
        for (int i = 0; i < t_number.length(); ++i) {
            int num = Character.getNumericValue(t_number.charAt(i));
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_CUSTOM_NUMBERS_5.get(), posX + 4 * i, posY, (float)(5 * num), 0.0f, 5, 7, GuiHelpers.GUI_CUSTOM_NUMBERS_5.width, GuiHelpers.GUI_CUSTOM_NUMBERS_5.height, color);
        }
    }

    public static float blinkEffect(float time, float progress, float min, float max, float fadeMin, float fadeMax) {
        float range = max - min;
        float frequency = (float)(Math.PI * 2 / (double)(min + progress * range));
        float t = ((float)Math.cos(time * frequency) + 1.0f) * 0.5f;
        return fadeMin + (fadeMax - fadeMin) * t;
    }

    public static ResourceLocation getPlayerSkin() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return null;
        }
        return mc.player.getSkin().texture();
    }
}

