/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.api;

import com.deadzoke.ignitehud.client.clock.IClockLineProvider;
import com.deadzoke.ignitehud.client.playerattributes.IPlayerAttributeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OverlayApi {
    private static final Set<String> OVERLAYS_TO_OVERRIDE = new HashSet<String>();
    private static final Map<String, IPlayerAttributeProvider> PLAYER_ATTRIBUTES = new LinkedHashMap<String, IPlayerAttributeProvider>();
    private static final Map<String, IClockLineProvider> CLOCK_LINES = new LinkedHashMap<String, IClockLineProvider>();

    public static void init() {
        OverlayApi.addOverlaysToOverride(new String[]{"minecraft:air_level", "minecraft:armor_level", "minecraft:experience_bar", "minecraft:food_level", "minecraft:jump_meter", "minecraft:vehicle_health", "minecraft:player_health", "minecraft:effects", "minecraft:selected_item_name", "minecraft:boss_overlay", "minecraft:experience_level"});
    }

    public static void addOverlaysToOverride(String[] overlayNames) {
        Collections.addAll(OVERLAYS_TO_OVERRIDE, overlayNames);
    }

    public static Set<String> getOverlaysToOverride() {
        return Collections.unmodifiableSet(OVERLAYS_TO_OVERRIDE);
    }

    public static void addPlayerAttribute(String key, IPlayerAttributeProvider provider) {
        PLAYER_ATTRIBUTES.put(key, provider);
    }

    public static Collection<IPlayerAttributeProvider> getPlayerAttributes() {
        return Collections.unmodifiableCollection(PLAYER_ATTRIBUTES.values());
    }

    public static void addClockLine(String key, IClockLineProvider provider) {
        CLOCK_LINES.put(key, provider);
    }

    public static Collection<IClockLineProvider> getClockLines() {
        return Collections.unmodifiableCollection(CLOCK_LINES.values());
    }
}

