/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client;

import com.deadzoke.ignitehud.api.OverlayApi;
import com.deadzoke.ignitehud.client.bossbar.GuiBossBar;
import com.deadzoke.ignitehud.client.clock.IClockLine;
import com.deadzoke.ignitehud.client.clock.IClockLineProvider;
import com.deadzoke.ignitehud.client.items.GuiItems;
import com.deadzoke.ignitehud.client.playerattributes.IPlayerAttributeProvider;
import com.deadzoke.ignitehud.client.playerattributes.PlayerAttribute;
import com.deadzoke.ignitehud.client.texture.GuiTexture;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.GameUtil;
import com.deadzoke.ignitehud.util.RenderUtil;
import com.deadzoke.ignitehud.util.TextUtil;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class GuiOverlay {
    private static final GuiTexture GUI_BASE = new GuiTexture("base", 64);
    private static final GuiTexture GUI_EXPERIENCE = new GuiTexture("experience", 16, 32);
    private static final GuiTexture GUI_HEALTH = new GuiTexture("health", 128, 64);
    private static final GuiTexture GUI_HEALTH_HEALING = new GuiTexture("health-heal", 128, 16);
    private static final GuiTexture GUI_HEALTH_REGENERATION = new GuiTexture("health-regen", 128);
    private static final GuiTexture GUI_AIR = new GuiTexture("air", 128, 32);
    private static final GuiTexture GUI_MOUNT = new GuiTexture("mount", 128, 64);
    private static final GuiTexture GUI_EVENT = new GuiTexture("event", 256, 128);
    private static final GuiTexture GUI_EFFECTS = new GuiTexture("effects", 64);
    private static final GuiTexture GUI_CLOCK = new GuiTexture("clock", 16);
    private static final GuiTexture GUI_NUMBERS_ROMAN = new GuiTexture("numbers-roman", 24, 60);

    public static void renderHardcoreIcon(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.HARDCORE_ICON_ENABLE.getAsBoolean() || mc.options.hideGui || !GameUtil.shouldDrawSurvivalHUD() || mc.level == null || !mc.level.getLevelData().isHardcore()) {
            return;
        }
        RenderUtil.push("hardcore_icon");
        int posX = 30;
        int posY = 14;
        boolean uvX = false;
        int uvY = 29;
        int uvW = 10;
        int uvH = 10;
        guiGraphics.blit(RenderType::guiTextured, GUI_BASE.get(), posX, posY, (float)uvX, (float)uvY, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        RenderUtil.pop();
    }

    public static void renderExperienceLevel(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.EXPERIENCE_LEVEL_ENABLE.getAsBoolean() || mc.player == null || mc.options.hideGui || mc.gameMode == null || !mc.gameMode.hasExperience() || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("experience_level");
        int posX = 35;
        int posY = 38;
        String expLevel = String.valueOf(mc.player.experienceLevel);
        TextUtil.drawOutlinedString(guiGraphics, posX - mc.font.width(expLevel) / 2, posY, expLevel, ColorUtil.hexToDecimal("#C8FF8F"), ColorUtil.hexToDecimal("#000000"));
        RenderUtil.pop();
    }

    public static void renderPlayerFrame(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.PLAYER_FRAME_ENABLE.getAsBoolean() || mc.options.hideGui) {
            return;
        }
        RenderUtil.push("player_frame");
        int posX = 20;
        int posY = 15;
        int uvW = 29;
        int uvH = 29;
        guiGraphics.blit(RenderType::guiTextured, GUI_BASE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_BASE.width, GuiOverlay.GUI_BASE.height);
        RenderUtil.pop();
    }

    public static void renderExperienceBar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.EXPERIENCE_BAR_ENABLE.getAsBoolean() || mc.player == null || mc.options.hideGui || mc.gameMode == null || !mc.gameMode.hasExperience() || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("experience_bar");
        int posX = 18;
        int posY = 17;
        int uvW = 5;
        int uvH = 25;
        guiGraphics.blit(RenderType::guiTextured, GUI_EXPERIENCE.get(), posX, posY, 0.0f, 0.0f, uvW, uvH, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        int progress = (int)Math.ceil(mc.player.experienceProgress * (float)uvH);
        guiGraphics.blit(RenderType::guiTextured, GUI_EXPERIENCE.get(), posX, posY + uvH - progress, (float)uvW, (float)(uvH - progress), uvW, progress, GuiOverlay.GUI_EXPERIENCE.width, GuiOverlay.GUI_EXPERIENCE.height);
        RenderUtil.pop();
    }

    public static void renderPlayerIcon(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.PLAYER_ICON_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null) {
            return;
        }
        RenderUtil.push("player_icon");
        int posX = 26;
        int posY = 21;
        int size = 17;
        ResourceLocation playerTexture = mc.player.getSkin().texture();
        guiGraphics.blit(RenderType::guiTextured, playerTexture, posX, posY, (float)size, (float)size, size, size, size * 8, size * 8);
        if (mc.options.isModelPartEnabled(PlayerModelPart.HAT)) {
            guiGraphics.blit(RenderType::guiTextured, playerTexture, posX, posY, (float)(size * 5), (float)size, size, size, size * 8, size * 8);
        }
        RenderUtil.pop();
    }

    public static void renderPlayerName(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.PLAYER_NAME_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null) {
            return;
        }
        RenderUtil.push("player_name");
        int posX = 56;
        int posY = 16;
        if (!GameUtil.shouldDrawSurvivalHUD()) {
            posY = 26;
        }
        String text = mc.player.getDisplayName() != null ? mc.player.getDisplayName().getString() : "Player";
        guiGraphics.drawString(mc.font, text, posX, posY, ColorUtil.hexToDecimal("#FFFFFF"));
        RenderUtil.pop();
    }

    public static void renderPlayerHealth(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.PLAYER_HEALTH_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("player_health");
        int posX = 54;
        int posY = 27;
        LocalPlayer player = mc.player;
        float health = player.getHealth();
        AttributeInstance maxHealthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        float healthProgress = maxHealthAttribute != null ? health / (float)maxHealthAttribute.getValue() : 0.0f;
        healthProgress = Math.min(Math.max(healthProgress, 0.0f), 1.0f);
        int healthBarType = 0;
        if (player.hasEffect(MobEffects.WITHER)) {
            healthBarType = 3;
        } else if (player.isFullyFrozen()) {
            healthBarType = 4;
        } else if (player.hasEffect(MobEffects.POISON)) {
            healthBarType = 2;
        } else if (player.hasEffect(MobEffects.ABSORPTION)) {
            healthBarType = 1;
        }
        boolean uvX = false;
        int uvY = 0;
        int uvW = 91;
        int uvH = 5;
        guiGraphics.blit(RenderType::guiTextured, GUI_HEALTH.get(), posX, posY, (float)uvX, (float)(uvY + healthBarType * uvH * 2), uvW, uvH, GuiOverlay.GUI_HEALTH.width, GuiOverlay.GUI_HEALTH.height);
        float fade = 1.0f;
        if (healthProgress <= 0.17f) {
            fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / 3.0f)) + 1.4f) / 2.0f;
        }
        guiGraphics.blit(RenderType::guiTextured, GUI_HEALTH.get(), posX, posY, (float)uvX, (float)(uvY + uvH + healthBarType * uvH * 2), (int)((float)uvW * healthProgress), uvH, GuiOverlay.GUI_HEALTH.width, GuiOverlay.GUI_HEALTH.height, ARGB.white((float)fade));
        if (GameUtil.isHealing(health)) {
            int HuvX = 0;
            int HuvY = 0;
            int HuvW = 91;
            int HuvH = 5;
            int Hframes = 2;
            double Hspeed = 0.25;
            RenderUtil.renderAnimation(guiGraphics, GUI_HEALTH_HEALING.get(), posX, posY, HuvX, HuvY, HuvW, HuvH, GuiOverlay.GUI_HEALTH_HEALING.width, GuiOverlay.GUI_HEALTH_HEALING.height, Hspeed, Hframes);
        }
        if (player.hasEffect(MobEffects.REGENERATION)) {
            int RuvX = 0;
            int RuvY = 0;
            int RuvW = 91;
            int RuvH = 5;
            int Rframes = 20;
            double Rspeed = 1.0;
            RenderUtil.renderAnimation(guiGraphics, GUI_HEALTH_REGENERATION.get(), posX, posY, RuvX, RuvY, RuvW, RuvH, GuiOverlay.GUI_HEALTH_REGENERATION.width, GuiOverlay.GUI_HEALTH_REGENERATION.height, Rspeed, Rframes);
        }
        RenderUtil.pop();
    }

    public static void renderWidgetAttributes(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.WIDGET_ATTRIBUTES_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        int posX = 55;
        RenderUtil.push("widget_attributes");
        for (IPlayerAttributeProvider provider : OverlayApi.getPlayerAttributes()) {
            PlayerAttribute attribute = provider.build();
            if (attribute == null) continue;
            posX += attribute.render(guiGraphics, posX, 34);
            posX += 5;
        }
        RenderUtil.pop();
    }

    public static void renderAirLevel(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.AIR_LEVEL_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        RenderUtil.push("air_level");
        int posX = (mc.getWindow().getGuiScaledWidth() - 121) / 2;
        int posY = mc.getWindow().getGuiScaledHeight() - 65;
        float air = mc.player.getAirSupply();
        if (mc.player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || air < 300.0f) {
            float airProgress = air / 300.0f;
            guiGraphics.blit(RenderType::guiTextured, GUI_AIR.get(), posX, posY, 0.0f, 0.0f, 121, 5, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            guiGraphics.blit(RenderType::guiTextured, GUI_AIR.get(), posX + 1, posY + 1, 1.0f, 6.0f, (int)(airProgress * 121.0f), 3, GuiOverlay.GUI_AIR.width, GuiOverlay.GUI_AIR.height);
            if (airProgress > 0.0f) {
                ResourceLocation icon = TextUtil.getIconTexture("bubble");
                int iconIndex = Math.max((int)(-(air / 2.0f - 3.0f)), 0);
                guiGraphics.blit(RenderType::guiTextured, icon, (mc.getWindow().getGuiScaledWidth() - 10) / 2, posY - 2, (float)(iconIndex * 10), 0.0f, 10, 10, 30, 10);
            }
        }
        RenderUtil.pop();
    }

    public static void renderVehicleInfo(GuiGraphics guiGraphics) {
        boolean canJump;
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.VEHICLE_INFO_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || !((entity = mc.player.getVehicle()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity vehicle = (LivingEntity)entity;
        int posX = 20;
        int linesPosX = posX + 6 + 5;
        int posY = 60;
        int linesPosY = posY + 3;
        int barHeight = 0;
        RenderUtil.push("vehicle_info");
        TextUtil.renderIcon(guiGraphics, "pet", linesPosX, linesPosY);
        guiGraphics.drawString(mc.font, vehicle.getName(), linesPosX + 10 + 2, linesPosY + 1, ColorUtil.hexToDecimal("#FFFFFF"));
        float healthProgress = Math.min(vehicle.getHealth() / vehicle.getMaxHealth(), 1.0f);
        guiGraphics.blit(RenderType::guiTextured, GUI_MOUNT.get(), linesPosX, linesPosY + (barHeight += 12), 0.0f, 0.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
        guiGraphics.blit(RenderType::guiTextured, GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 5.0f, (int)(91.0f * healthProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
        barHeight += 6;
        boolean bl = canJump = mc.player.jumpableVehicle() != null;
        if (canJump) {
            float jumpProgress = mc.player.getJumpRidingScale();
            guiGraphics.blit(RenderType::guiTextured, GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 10.0f, 91, 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            guiGraphics.blit(RenderType::guiTextured, GUI_MOUNT.get(), linesPosX, linesPosY + barHeight, 0.0f, 15.0f, (int)(91.0f * jumpProgress), 5, GuiOverlay.GUI_MOUNT.width, GuiOverlay.GUI_MOUNT.height);
            barHeight += 5;
        }
        RenderUtil.renderVerticalBar(guiGraphics, GUI_MOUNT, posX, posY, 0, 20, barHeight + 1);
        RenderUtil.pop();
    }

    public static void renderBossBar(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.BOSS_BARS_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.level == null) {
            return;
        }
        RenderUtil.push("boss_bar");
        int uvW = 182;
        int posX = (mc.getWindow().getGuiScaledWidth() - uvW) / 2;
        int posY = 15;
        int spacing = 19;
        ArrayList<BossEvent> nearbyBosses = new ArrayList<BossEvent>(GuiBossBar.getAll().values());
        int _posY = posY;
        for (BossEvent event : nearbyBosses) {
            Component name = event.getName();
            int nameWidth = mc.font.width((FormattedText)name);
            int nameBgWidth = 3 + nameWidth + 3;
            int nameBgPosX = posX + (uvW - nameBgWidth - 8) / 2 - 1;
            int nameBgPosY = _posY + 2;
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), nameBgPosX, nameBgPosY, 0.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), nameBgPosX + 4, nameBgPosY, 8.0f, 0.0f, nameBgWidth, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), nameBgPosX + 4 + nameBgWidth, nameBgPosY, 4.0f, 0.0f, 4, 6, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int barPosY = _posY + 6;
            float healthRatio = event.getProgress();
            int filledWidth = (int)(healthRatio * (float)(uvW - 2));
            int barIndex = switch (event.getColor()) {
                default -> throw new MatchException(null, null);
                case BossEvent.BossBarColor.PINK -> 0;
                case BossEvent.BossBarColor.BLUE -> 1;
                case BossEvent.BossBarColor.RED -> 2;
                case BossEvent.BossBarColor.GREEN -> 3;
                case BossEvent.BossBarColor.YELLOW -> 4;
                case BossEvent.BossBarColor.PURPLE -> 5;
                case BossEvent.BossBarColor.WHITE -> 6;
            };
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), posX, barPosY, 0.0f, 6.0f, uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), posX + 1, barPosY, 1.0f, (float)(11 + barIndex * 5), filledWidth, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            int notchesIndex = switch (event.getOverlay().getName()) {
                case "progress" -> 1;
                case "notched_6" -> 0;
                case "notched_10" -> 1;
                case "notched_12" -> 2;
                case "notched_20" -> 3;
                default -> 0;
            };
            guiGraphics.blit(RenderType::guiTextured, GUI_EVENT.get(), posX, barPosY, 0.0f, (float)(46 + notchesIndex * 5), uvW, 5, GuiOverlay.GUI_EVENT.width, GuiOverlay.GUI_EVENT.height);
            TextUtil.drawOutlinedString(guiGraphics, posX + (uvW - nameWidth) / 2, _posY, name.getString(), ColorUtil.hexToDecimal("#ffffff"), ColorUtil.hexToDecimal("#000000"));
            _posY += spacing;
        }
        RenderUtil.pop();
    }

    public static void renderItemName(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.ITEM_NAME_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        RenderUtil.push("item_name");
        RenderUtil.renderHeldItemName(guiGraphics, guiGraphics.guiWidth() / 2, guiGraphics.guiHeight() - 67);
        RenderUtil.pop();
    }

    public static void renderEquippedItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.EQUIPPED_ITEMS_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.gameMode == null || mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        RenderUtil.push("item_name");
        LinkedHashSet<EquipmentSlot> equipmentSlots = new LinkedHashSet<EquipmentSlot>();
        equipmentSlots.add(EquipmentSlot.HEAD);
        equipmentSlots.add(EquipmentSlot.CHEST);
        equipmentSlots.add(EquipmentSlot.LEGS);
        equipmentSlots.add(EquipmentSlot.FEET);
        equipmentSlots.add(EquipmentSlot.MAINHAND);
        equipmentSlots.add(EquipmentSlot.OFFHAND);
        GuiItems.addItems(equipmentSlots);
        GuiItems.renderItems(guiGraphics);
        RenderUtil.pop();
    }

    public static void renderEffects(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.EFFECTS_ENABLE.getAsBoolean() || mc.options.hideGui || mc.player == null || mc.level == null || !GameUtil.shouldDrawSurvivalHUD()) {
            return;
        }
        Collection effects = mc.player.getActiveEffects();
        if (effects.isEmpty()) {
            return;
        }
        if (mc.screen != null && mc.screen.showsActiveEffects()) {
            return;
        }
        RenderUtil.push("effects");
        int baseW = 27;
        int baseH = 17;
        int effectSpacing = 3;
        int rowSpacing = 10;
        int count = 0;
        MobEffectTextureManager mobeffecttexturemanager = mc.getMobEffectTextures();
        for (MobEffectInstance effectInstance : Ordering.natural().reverse().sortedCopy((Iterable)effects)) {
            if (!IClientMobEffectExtensions.of((MobEffectInstance)effectInstance).isVisibleInGui(effectInstance) || !effectInstance.showIcon()) {
                return;
            }
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            int effectDuration = effectInstance.getDuration();
            int posX = mc.getWindow().getGuiScaledWidth() - (15 + baseW + (baseW + effectSpacing) * (count % 4));
            int posY = mc.getWindow().getGuiScaledHeight() - 15 - baseH - (baseH + rowSpacing) * (count / 4);
            int effectBackgroundTextureOffset = 0;
            if (effectInstance.isAmbient()) {
                effectBackgroundTextureOffset = 2;
            } else if (!effect.isBeneficial()) {
                effectBackgroundTextureOffset = 1;
            }
            guiGraphics.blit(RenderType::guiTextured, GUI_EFFECTS.get(), posX, posY, 0.0f, (float)(baseH * effectBackgroundTextureOffset), baseW, baseH, GuiOverlay.GUI_EFFECTS.width, GuiOverlay.GUI_EFFECTS.height);
            float fade = 1.0f;
            if (!effectInstance.isInfiniteDuration() && !effectInstance.isAmbient() && effectInstance.endsWithin(200)) {
                fade = RenderUtil.blinkEffect(effectDuration, (float)effectDuration / 200.0f, 4.0f, 10.0f, 0.25f, 1.0f);
            }
            TextureAtlasSprite textureatlassprite = mobeffecttexturemanager.get(effectInstance.getEffect());
            guiGraphics.blitSprite(RenderType::guiTextured, textureatlassprite, posX + 5, posY - 6, 18, 18, ARGB.white((float)fade));
            int strength = effectInstance.getAmplifier();
            if (strength > 0 && strength < 10) {
                guiGraphics.blit(RenderType::guiTextured, GUI_NUMBERS_ROMAN.get(), posX + 16, posY - 1, 12.0f, (float)(6 + 6 * (strength - 1)), 12, 6, GuiOverlay.GUI_NUMBERS_ROMAN.width, GuiOverlay.GUI_NUMBERS_ROMAN.height);
            }
            String effectDurationTime = MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)mc.level.tickRateManager().tickrate()).getString();
            String effectDurationOutput = effectDuration < 71980 ? effectDurationTime : "-:-";
            int effectDurationPosX = effectInstance.isInfiniteDuration() || effectDuration >= 71980 ? 15 : 14;
            TextUtil.drawOutlinedString(guiGraphics, posX - mc.font.width(effectDurationOutput) / 2 + effectDurationPosX, posY + 11, effectDurationOutput, effect.getColor(), 0);
            ++count;
        }
        RenderUtil.pop();
    }

    public static void renderClock(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.CLOCK_ENABLE.getAsBoolean() || mc.options.hideGui) {
            return;
        }
        Collection<IClockLineProvider> clockLines = OverlayApi.getClockLines();
        if (clockLines.isEmpty()) {
            return;
        }
        RenderUtil.push("clock");
        int posX = mc.getWindow().getGuiScaledWidth() - 20;
        int posY = 20;
        int rowHeight = 8;
        int rowSpacing = 4;
        int index = 0;
        for (IClockLineProvider clockLineProvider : clockLines) {
            IClockLine clockLine = clockLineProvider.build();
            if (clockLine == null) continue;
            clockLine.render(guiGraphics, posX - 10, posY + (rowHeight + rowSpacing) * index);
            ++index;
        }
        int elementHeight = rowHeight * index + rowSpacing * (index - 1);
        guiGraphics.blit(RenderType::guiTextured, GUI_CLOCK.get(), posX - 6, posY - 4, 0.0f, 0.0f, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        guiGraphics.blit(RenderType::guiTextured, GUI_CLOCK.get(), posX - 6, posY - 1, 0.0f, 3.0f, 6, elementHeight + 1, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        guiGraphics.blit(RenderType::guiTextured, GUI_CLOCK.get(), posX - 6, posY + elementHeight, 0.0f, 6.0f, 6, 3, GuiOverlay.GUI_CLOCK.width, GuiOverlay.GUI_CLOCK.height);
        RenderUtil.pop();
    }
}

