/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client.clock;

import com.deadzoke.ignitehud.api.OverlayApi;
import com.deadzoke.ignitehud.client.clock.IClockLine;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class GuiClock {
    public static void init() {
        OverlayApi.addClockLine("day", GuiClock::addDay);
        OverlayApi.addClockLine("time", GuiClock::addTime);
    }

    public static IClockLine addDay() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.DAY_ENABLE.getAsBoolean() || mc.level == null) {
            return null;
        }
        return (guiGraphics, posX, posY) -> {
            long day = mc.level.getDayTime() / 24000L + 1L;
            String dayString = "Day " + day;
            guiGraphics.drawString(mc.font, dayString, posX - mc.font.width(dayString), posY, ColorUtil.hexToDecimal("#FFFFFF"));
        };
    }

    public static IClockLine addTime() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.TIME_ENABLE.getAsBoolean() || mc.level == null) {
            return null;
        }
        return (guiGraphics, posX, posY) -> {
            long time = mc.level.getDayTime() % 24000L;
            long adjustedTime = (time + 6000L) % 24000L;
            int hour = (int)(adjustedTime / 1000L);
            int minute = (int)(adjustedTime % 1000L * 60L / 1000L);
            String timeString = String.format("%02d:%02d", hour, minute);
            int textWidth = mc.font.width(timeString);
            boolean sleepTime = time >= 12541L && time < 23458L;
            guiGraphics.drawString(mc.font, timeString, posX - textWidth, posY, ColorUtil.hexToDecimal("#FFFFFF"));
            if (!sleepTime) {
                TextUtil.renderIcon(guiGraphics, "sun", posX - textWidth - 2 - 10, posY - 1);
            } else {
                ResourceLocation moonIcon = TextUtil.getIconTexture("moon");
                guiGraphics.blit(RenderType::guiTextured, moonIcon, posX - textWidth - 2 - 10, posY - 1, (float)(mc.level.getMoonPhase() * 10), 0.0f, 10, 10, 80, 10);
            }
        };
    }
}

