/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client.items;

import com.deadzoke.ignitehud.client.texture.GuiTexture;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.TextUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GuiItems {
    private static final Map<String, EquipmentSlot> ITEM_SLOTS = new LinkedHashMap<String, EquipmentSlot>();
    private static final GuiTexture GUI_ITEMS = new GuiTexture("items", 64, 32);

    public static void addItems(Set<EquipmentSlot> equipmentSlots) {
        for (EquipmentSlot slot : equipmentSlots) {
            ITEM_SLOTS.put(slot.getName(), slot);
        }
    }

    public static List<ItemStack> getItems() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return null;
        }
        return ITEM_SLOTS.values().stream().filter(slot -> mc.player.hasItemInSlot(slot) && mc.player.getItemBySlot(slot) != ItemStack.EMPTY).map(slot -> mc.player.getItemBySlot(slot)).toList();
    }

    public static void renderItems(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        List<ItemStack> equippedItems = GuiItems.getItems();
        if (equippedItems == null || equippedItems.isEmpty()) {
            return;
        }
        int baseW = 20;
        int baseH = 23;
        int spacing = 3;
        int posY = mc.getWindow().getGuiScaledHeight() - 52;
        int _posX = (mc.getWindow().getGuiScaledWidth() - (equippedItems.size() * (baseW + spacing) - spacing)) / 2;
        for (ItemStack stack : equippedItems) {
            int qty;
            float _durabilityProgress;
            boolean isDamageable = stack.isDamageableItem();
            boolean isUnbreakable = stack.get(DataComponents.UNBREAKABLE) != null;
            boolean shouldDrawDurabilityBar = isDamageable || isUnbreakable;
            float fade = 1.0f;
            if (isDamageable && (_durabilityProgress = (float)stack.getDamageValue() / (float)stack.getMaxDamage()) > 0.9f) {
                float output = 2.0f - ((float)Mth.clamp((double)_durabilityProgress, (double)0.9, (double)1.0) - 0.9f) / 0.1f * 1.2f;
                fade = Mth.cos((float)((float)mc.gui.getGuiTicks() / output)) / 4.0f + 0.75f;
            }
            guiGraphics.blit(RenderType::guiTextured, GUI_ITEMS.get(), _posX, posY, !shouldDrawDurabilityBar ? (float)baseW : 0.0f, 0.0f, baseW, baseH, GuiItems.GUI_ITEMS.width, GuiItems.GUI_ITEMS.height, ARGB.white((float)fade));
            guiGraphics.renderItem((LivingEntity)mc.player, stack, _posX + 2, posY + 5, 0);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            if (isDamageable) {
                int durability = stack.getMaxDamage() - stack.getDamageValue();
                float durabilityProgress = Math.max(0.0f, (float)durability / (float)stack.getMaxDamage());
                int[] rgb = ColorUtil.HSVtoRGB(durabilityProgress * 2.0f, 1.0f, 1.0f);
                int tint = ARGB.color((int)ARGB.white((float)fade), (int)rgb[0], (int)rgb[1], (int)rgb[2]);
                guiGraphics.blit(RenderType::guiTextured, GUI_ITEMS.get(), _posX + 2, posY + 1, 0.0f, 23.0f, (int)(durabilityProgress * 16.0f), 2, GuiItems.GUI_ITEMS.width, GuiItems.GUI_ITEMS.height, tint);
                TextUtil.drawCustomNumber(guiGraphics, _posX + baseW + 1 - (String.valueOf(durability).length() * 4 + 1), posY + 17, durability, tint);
            }
            if (isUnbreakable) {
                guiGraphics.blit(RenderType::guiTextured, GUI_ITEMS.get(), _posX + 2, posY + 1, 0.0f, 25.0f, 16, 2, GuiItems.GUI_ITEMS.width, GuiItems.GUI_ITEMS.height);
            }
            if (stack.isStackable() && (qty = mc.player.getInventory().countItem(stack.getItem())) > 1) {
                TextUtil.drawCustomNumber(guiGraphics, _posX + baseW + 1 - (String.valueOf(qty).length() * 4 + 1), posY + 17, qty);
            }
            guiGraphics.pose().popPose();
            _posX += baseW + spacing;
        }
    }
}

