/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.client.playerattributes;

import com.deadzoke.ignitehud.api.OverlayApi;
import com.deadzoke.ignitehud.client.playerattributes.PlayerAttribute;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.util.ColorUtil;
import com.deadzoke.ignitehud.util.TextUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GuiPlayerAttributes {
    public static void init() {
        OverlayApi.addPlayerAttribute("food", GuiPlayerAttributes::addFood);
        OverlayApi.addPlayerAttribute("saturation", GuiPlayerAttributes::addSaturation);
        OverlayApi.addPlayerAttribute("armor", GuiPlayerAttributes::addArmor);
        OverlayApi.addPlayerAttribute("toughness", GuiPlayerAttributes::addToughness);
    }

    private static PlayerAttribute addFood() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.FOOD_ENABLE.getAsBoolean() || mc.player == null) {
            return null;
        }
        int foodLevel = mc.player.getFoodData().getFoodLevel();
        float fade = 1.0f;
        if (foodLevel <= 3) {
            fade = (Mth.cos((float)((float)mc.gui.getGuiTicks() / Math.max((float)foodLevel, 0.8f))) + 1.4f) / 2.0f;
        }
        ResourceLocation icon = TextUtil.getIconTexture("food");
        String color = "#e5c4ac";
        if (mc.player.hasEffect(MobEffects.HUNGER)) {
            icon = TextUtil.getIconTexture("food_hunger");
            color = "#d2e3b5";
        }
        return new PlayerAttribute(icon, String.valueOf(foodLevel), ColorUtil.hexToDecimal(color), fade);
    }

    private static PlayerAttribute addSaturation() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.SATURATION_ENABLE.getAsBoolean() || mc.player == null) {
            return null;
        }
        int saturationLevel = (int)mc.player.getFoodData().getSaturationLevel();
        ResourceLocation icon = TextUtil.getIconTexture("saturation");
        String color = "#f0d556";
        if (mc.player.hasEffect(MobEffects.HUNGER)) {
            icon = TextUtil.getIconTexture("saturation_hunger");
            color = "#e5e699";
        }
        return new PlayerAttribute(icon, String.valueOf(saturationLevel), ColorUtil.hexToDecimal(color));
    }

    private static PlayerAttribute addArmor() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.ARMOR_ENABLE.getAsBoolean() || mc.player == null || mc.player.getArmorValue() <= 0) {
            return null;
        }
        int armorLevel = mc.player.getArmorValue();
        ResourceLocation icon = TextUtil.getIconTexture("armor");
        String color = "#d1d3e3";
        return new PlayerAttribute(icon, String.valueOf(armorLevel), ColorUtil.hexToDecimal(color));
    }

    private static PlayerAttribute addToughness() {
        Minecraft mc = Minecraft.getInstance();
        if (!Config.CONFIG.TOUGHNESS_ENABLE.getAsBoolean() || mc.player == null || Mth.floor((double)mc.player.getAttributeValue(Attributes.ARMOR_TOUGHNESS)) <= 0) {
            return null;
        }
        int toughnessLevel = Mth.floor((double)mc.player.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        ResourceLocation icon = TextUtil.getIconTexture("armor_toughness");
        String color = "#9ff8e5";
        return new PlayerAttribute(icon, String.valueOf(toughnessLevel), ColorUtil.hexToDecimal(color));
    }
}

