/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.events;

import com.deadzoke.ignitehud.api.OverlayApi;
import com.deadzoke.ignitehud.client.GuiOverlay;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="ignitehud", value={Dist.CLIENT})
public class GuiEvents {
    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Pre event) {
        Set<String> overlaysToOverride = OverlayApi.getOverlaysToOverride();
        if (overlaysToOverride.isEmpty()) {
            return;
        }
        String name = event.getName().toString();
        if (overlaysToOverride.contains(name)) {
            event.setCanceled(true);
        }
    }

    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        GuiEvents.registerGuiOverlay(event, "experience_bar", GuiOverlay::renderExperienceBar);
        GuiEvents.registerGuiOverlay(event, "player_icon", GuiOverlay::renderPlayerIcon);
        GuiEvents.registerGuiOverlay(event, "player_frame", GuiOverlay::renderPlayerFrame);
        GuiEvents.registerGuiOverlay(event, "experience_level", GuiOverlay::renderExperienceLevel);
        GuiEvents.registerGuiOverlay(event, "hardcore_icon", GuiOverlay::renderHardcoreIcon);
        GuiEvents.registerGuiOverlay(event, "player_name", GuiOverlay::renderPlayerName);
        GuiEvents.registerGuiOverlay(event, "player_health", GuiOverlay::renderPlayerHealth);
        GuiEvents.registerGuiOverlay(event, "widget_attributes", GuiOverlay::renderWidgetAttributes);
        GuiEvents.registerGuiOverlay(event, "vehicle_info", GuiOverlay::renderVehicleInfo);
        GuiEvents.registerGuiOverlay(event, "boss_bar", GuiOverlay::renderBossBar);
        GuiEvents.registerGuiOverlay(event, "clock", GuiOverlay::renderClock);
        GuiEvents.registerGuiOverlay(event, "air_level", GuiOverlay::renderAirLevel);
        GuiEvents.registerGuiOverlay(event, "item_name", GuiOverlay::renderItemName);
        GuiEvents.registerGuiOverlay(event, "equipped_items", GuiOverlay::renderEquippedItems);
        GuiEvents.registerGuiOverlay(event, "effects", GuiOverlay::renderEffects);
    }

    public static void registerGuiOverlay(RegisterGuiLayersEvent event, String id, Consumer<GuiGraphics> layer) {
        ResourceLocation resource = ResourceLocation.fromNamespaceAndPath((String)"ignitehud", (String)id);
        event.registerBelow(VanillaGuiLayers.HOTBAR, resource, (guiGraphics, _p2) -> layer.accept(guiGraphics));
    }
}

