/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.util;

import com.deadzoke.ignitehud.util.MathUtil;

public class ColorUtil {
    public static int hexToDecimal(String color) {
        return Integer.parseInt(color.replace("#", ""), 16);
    }

    public static int[] HSVtoRGB(float h, float s, float v) {
        float[] rgb = new float[3];
        if (h == -1.0f) {
            int gray = MathUtil.clampToByte(v * 255.0f);
            return new int[]{gray, gray, gray};
        }
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        if ((i & 1) == 0) {
            f = 1.0f - f;
        }
        float m = v * (1.0f - s);
        float n = v * (1.0f - s * f);
        switch (i) {
            case 0: 
            case 6: {
                rgb[0] = v;
                rgb[1] = n;
                rgb[2] = m;
                break;
            }
            case 1: {
                rgb[0] = n;
                rgb[1] = v;
                rgb[2] = m;
                break;
            }
            case 2: {
                rgb[0] = m;
                rgb[1] = v;
                rgb[2] = n;
                break;
            }
            case 3: {
                rgb[0] = m;
                rgb[1] = n;
                rgb[2] = v;
                break;
            }
            case 4: {
                rgb[0] = n;
                rgb[1] = m;
                rgb[2] = v;
                break;
            }
            case 5: {
                rgb[0] = v;
                rgb[1] = m;
                rgb[2] = n;
            }
        }
        return new int[]{MathUtil.clampToByte(rgb[0] * 255.0f), MathUtil.clampToByte(rgb[1] * 255.0f), MathUtil.clampToByte(rgb[2] * 255.0f)};
    }
}

