/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.util;

import com.deadzoke.ignitehud.client.texture.GuiTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class RenderUtil {
    private static ItemStack lastToolHighlight = ItemStack.EMPTY;
    private static float toolHighlightTimer = 0.0f;

    public static void push(String id) {
        Profiler.get().push(id);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void pop() {
        Profiler.get().pop();
    }

    public static void renderAnimation(GuiGraphics guiGraphics, ResourceLocation texture, int posX, int posY, int uvX, int uvY, int uvW, int uvH, int textureW, int textureH, double speed, int frames) {
        Minecraft mc = Minecraft.getInstance();
        int frame = (int)((double)mc.gui.getGuiTicks() * speed % (double)frames);
        guiGraphics.blit(RenderType::guiTextured, texture, posX, posY, (float)uvX, (float)(uvY + frame * uvH), uvW, uvH, textureW, textureH);
    }

    public static float blinkEffect(float time, float progress, float min, float max, float fadeMin, float fadeMax) {
        float range = max - min;
        float frequency = (float)(Math.PI * 2 / (double)(min + progress * range));
        float t = ((float)Math.cos(time * frequency) + 1.0f) * 0.5f;
        return fadeMin + (fadeMax - fadeMin) * t;
    }

    public static void renderVerticalBar(GuiGraphics guiGraphics, GuiTexture texture, int posX, int posY, int uvX, int uvY, int height) {
        guiGraphics.blit(RenderType::guiTextured, texture.get(), posX, posY, (float)uvX, (float)uvY, 6, 3, 6, 3, texture.width, texture.height);
        guiGraphics.blit(RenderType::guiTextured, texture.get(), posX, posY + 3, (float)uvX, (float)(uvY + 3), 6, height, 6, 3, texture.width, texture.height);
        guiGraphics.blit(RenderType::guiTextured, texture.get(), posX, posY + 3 + height, (float)uvX, (float)(uvY + 6), 6, 3, 6, 3, texture.width, texture.height);
    }

    public static void renderHeldItemName(GuiGraphics guiGraphics, int posX, int posY) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            ItemStack itemstack = mc.player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty()) {
                toolHighlightTimer = 0.0f;
            } else if (!lastToolHighlight.isEmpty() && itemstack.is(lastToolHighlight.getItem()) && itemstack.getHoverName().equals((Object)lastToolHighlight.getHoverName()) && itemstack.getHighlightTip(itemstack.getHoverName()).equals((Object)lastToolHighlight.getHighlightTip(lastToolHighlight.getHoverName()))) {
                if (toolHighlightTimer > 0.0f) {
                    toolHighlightTimer -= 0.5f;
                }
            } else {
                toolHighlightTimer = (int)(300.0 * (Double)mc.options.notificationDisplayTime().get());
            }
            lastToolHighlight = itemstack;
            if (toolHighlightTimer > 0.0f && !lastToolHighlight.isEmpty()) {
                MutableComponent itemNameMutableComponent = Component.empty().append(itemstack.getHoverName());
                itemNameMutableComponent.withStyle(itemstack.getRarity().getStyleModifier());
                if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                    itemNameMutableComponent.withStyle(ChatFormatting.ITALIC);
                }
                Component highlightTip = itemstack.getHighlightTip((Component)itemNameMutableComponent);
                int textWidth = mc.font.width((FormattedText)highlightTip);
                int _posX = posX - textWidth / 2;
                int fade = (int)(toolHighlightTimer * 256.0f / 10.0f);
                if (fade > 255) {
                    fade = 255;
                }
                if (fade > 0) {
                    Font font = IClientItemExtensions.of((ItemStack)lastToolHighlight).getFont(lastToolHighlight, IClientItemExtensions.FontContext.SELECTED_ITEM_NAME);
                    if (font == null) {
                        guiGraphics.drawStringWithBackdrop(mc.font, highlightTip, _posX, posY, textWidth, ARGB.color((int)fade, (int)-1));
                    } else {
                        _posX = (guiGraphics.guiWidth() - font.width((FormattedText)highlightTip)) / 2;
                        guiGraphics.drawStringWithBackdrop(font, highlightTip, _posX, posY, textWidth, ARGB.color((int)fade, (int)-1));
                    }
                }
            }
        }
    }
}

