/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.util;

import com.deadzoke.ignitehud.client.texture.GuiTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class TextUtil {
    private static final GuiTexture GUI_CUSTOM_NUMBERS_5 = new GuiTexture("numbers_5", 64, 8);

    public static void drawOutlinedString(GuiGraphics guiGraphics, int posX, int posY, String text, int color, int outline) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        guiGraphics.drawString(font, text, posX, posY - 1, outline, false);
        guiGraphics.drawString(font, text, posX + 1, posY, outline, false);
        guiGraphics.drawString(font, text, posX, posY + 1, outline, false);
        guiGraphics.drawString(font, text, posX - 1, posY, outline, false);
        guiGraphics.drawString(font, text, posX, posY, color, false);
    }

    public static void drawCustomNumber(GuiGraphics guiGraphics, int posX, int posY, int number) {
        TextUtil.drawCustomNumber(guiGraphics, posX, posY, number, -1);
    }

    public static void drawCustomNumber(GuiGraphics guiGraphics, int posX, int posY, int number, int color) {
        String t_number = Integer.toString(number);
        for (int i = 0; i < t_number.length(); ++i) {
            int num = Character.getNumericValue(t_number.charAt(i));
            guiGraphics.blit(RenderType::guiTextured, GUI_CUSTOM_NUMBERS_5.get(), posX + 4 * i, posY, (float)(5 * num), 0.0f, 5, 7, TextUtil.GUI_CUSTOM_NUMBERS_5.width, TextUtil.GUI_CUSTOM_NUMBERS_5.height, color);
        }
    }

    public static ResourceLocation getIconTexture(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"ignitehud", (String)("textures/gui/icons/" + id + ".png"));
    }

    public static void renderIcon(GuiGraphics guiGraphics, String id, int posX, int posY) {
        ResourceLocation icon = TextUtil.getIconTexture(id);
        guiGraphics.blit(RenderType::guiTextured, icon, posX, posY, 0.0f, 0.0f, 10, 10, 10, 10);
    }
}

