/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud;

import com.deadzoke.ignitehud.api.overlay.OverlayApi;
import com.deadzoke.ignitehud.client.GuiClock;
import com.deadzoke.ignitehud.client.GuiPlayerAttributes;
import com.deadzoke.ignitehud.client.GuiPlayerBars;
import com.deadzoke.ignitehud.config.Config;
import com.deadzoke.ignitehud.events.GuiEvents;
import com.deadzoke.ignitehud.integrations.IronsSpellbooksIntegration;
import com.deadzoke.ignitehud.integrations.LegendarySurvivalOverhaulIntegration;
import com.deadzoke.ignitehud.integrations.SereneSeasonsIntegration;
import com.mojang.logging.LogUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.slf4j.Logger;

@Mod(value="ignitehud", dist={Dist.CLIENT})
public class IgniteHUD {
    public static final String MODID = "ignitehud";
    public static final Logger LOGGER = LogUtils.getLogger();

    public IgniteHUD(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(GuiEvents::registerGuiOverlays);
        modEventBus.addListener(IgniteHUD::onClientSetup);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG_SPEC);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            OverlayApi.init();
            GuiPlayerBars.init();
            GuiPlayerAttributes.init();
            GuiClock.init();
            if (ModList.get().isLoaded("irons_spellbooks")) {
                IronsSpellbooksIntegration.init();
            }
            if (ModList.get().isLoaded("legendarysurvivaloverhaul")) {
                LegendarySurvivalOverhaulIntegration.init();
            }
            if (ModList.get().isLoaded("sereneseasons")) {
                SereneSeasonsIntegration.init();
            }
        });
    }
}

