/*
 * Decompiled with CFR 0.152.
 */
package com.deadzoke.ignitehud.api.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class WidgetAttribute {
    private final String id;
    private final List<Supplier<ResourceLocation>> iconProviders = new ArrayList<Supplier<ResourceLocation>>();
    private final Supplier<String> valueSupplier;
    private final List<Supplier<Integer>> colorProviders;
    private final Supplier<Float> fadeSupplier;
    private final Supplier<Boolean> visibilitySupplier;

    public WidgetAttribute(Builder builder) {
        this.id = builder.id;
        this.iconProviders.addAll(builder.iconProviders);
        this.valueSupplier = builder.valueSupplier;
        this.colorProviders = builder.colorProviders;
        this.fadeSupplier = builder.fadeSupplier;
        this.visibilitySupplier = builder.visibilitySupplier;
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation getIcon() {
        for (Supplier<ResourceLocation> provider : this.iconProviders) {
            try {
                ResourceLocation icon = provider.get();
                if (icon == null) continue;
                return icon;
            }
            catch (Exception exception) {
            }
        }
        return ResourceLocation.fromNamespaceAndPath((String)"ignitehud", (String)"textures/unknown.png");
    }

    public void addIconProvider(Supplier<ResourceLocation> provider, int priority) {
        if (priority == 0) {
            this.iconProviders.addFirst(provider);
        } else {
            this.iconProviders.add(Math.min(priority, this.iconProviders.size() - 1), provider);
        }
    }

    public void addIconProvider(Supplier<ResourceLocation> provider) {
        this.addIconProvider(provider, 0);
    }

    public String getValue() {
        return this.valueSupplier.get();
    }

    public int getColor() {
        for (Supplier<Integer> provider : this.colorProviders) {
            try {
                return provider.get();
            }
            catch (Exception exception) {
            }
        }
        return 0xFFFFFF;
    }

    public void addColorProvider(Supplier<Integer> provider, int priority) {
        if (priority == 0) {
            this.colorProviders.addFirst(provider);
        } else {
            this.colorProviders.add(Math.min(priority, this.colorProviders.size() - 1), provider);
        }
    }

    public void addColorProvider(Supplier<Integer> provider) {
        this.addColorProvider(provider, 0);
    }

    public float getFade() {
        return this.fadeSupplier.get().floatValue();
    }

    public boolean isVisible() {
        return this.visibilitySupplier.get();
    }

    public static class Builder {
        private final String id;
        private List<Supplier<ResourceLocation>> iconProviders = new ArrayList<Supplier<ResourceLocation>>();
        private Supplier<String> valueSupplier = () -> "0";
        private List<Supplier<Integer>> colorProviders = new ArrayList<Supplier<Integer>>();
        private Supplier<Float> fadeSupplier = () -> Float.valueOf(1.0f);
        private Supplier<Boolean> visibilitySupplier = () -> true;

        public Builder(String id) {
            this.id = id;
        }

        public Builder withIcon(ResourceLocation icon) {
            this.iconProviders.add(() -> icon);
            return this;
        }

        public Builder withIcon(Supplier<ResourceLocation> iconSupplier) {
            this.iconProviders.add(iconSupplier);
            return this;
        }

        public Builder withValue(Supplier<String> valueSupplier) {
            this.valueSupplier = valueSupplier;
            return this;
        }

        public Builder withColor(int color) {
            this.colorProviders.add(() -> color);
            return this;
        }

        public Builder withColor(Supplier<Integer> colorSupplier) {
            this.colorProviders.add(colorSupplier);
            return this;
        }

        public Builder withFade(Supplier<Float> fadeSupplier) {
            this.fadeSupplier = fadeSupplier;
            return this;
        }

        public Builder withVisibility(Supplier<Boolean> visibilitySupplier) {
            this.visibilitySupplier = visibilitySupplier;
            return this;
        }

        public WidgetAttribute build() {
            return new WidgetAttribute(this);
        }
    }
}

